Option Explicit

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

Sub UT_CenterScreen (frmSubForm As Form)

' Copyright  1993, 1994 by Computer Technologies, Inc. All rights reserved.

' This procedure centers a form on the screen. The form
' will be offset to just above center on the vertical axis.

    Dim nLeftPos      As Integer
    Dim nTopPos       As Integer

    nLeftPos = (Screen.Width - frmSubForm.Width) / 2
    nTopPos = (Screen.Height - frmSubForm.Height) / 2.4

    frmSubForm.Move nLeftPos, nTopPos

End Sub

Function UT_SetReadOnly (ctlControl As Control, bFlag As Integer) As Integer

' Copyright  1994 by Computer Technologies, Inc. All rights reserved.

    Const WM_USER = &H400
    Const EM_SETREADONLY = WM_USER + 31

    Dim nResult             As Integer

    nResult = APISendMessage(ctlControl.hWnd, EM_SETREADONLY, bFlag, 0&)
    UT_SetReadOnly = nResult

End Function

