{==============================================================}
{     Saved as: MEMAVAIL.PAS                                   }
{     By Pat Anderson                                          }
{     Last modified: Wed 12-28-1988                            }
{     Turbo Pascal 4/5                                         }
{==============================================================}

{$V-,R-,S-}
PROGRAM AvailMem;

USES
  Dos;

CONST
  StackSize = 16384;
  CodeSize = 4448;
  DataSize = 659;

VAR
  FreeMemory, FreeMemoryInKB,
  MemoryRequired  : longint;
  ErrorCode : integer;

BEGIN
  IF ParamCount < 1 THEN
    BEGIN
      WriteLn;
      WriteLn ('You must specify the amount of memory you wish to test for,');
      WriteLn ('expressed in kilobytes.');
      WriteLn;
      WriteLn ('  e.g., MEMAVAIL 384');
      WriteLn;
      WriteLn ('The program returns ErrorLevels as follows:');
      WriteLn;
      WriteLn ('  0 = Available memory >= memory required - OK to proceed');
      WriteLn ('  1 = Available memory < memory required - no go');
      WriteLn ('  2 = Parameter specified could not be converted to number');
      Halt;
    END;

  {retrieve memory requirement specified on comnmand line}
  Val (ParamStr (1), MemoryRequired, ErrorCode);
  IF ErrorCode <> 0 THEN
    BEGIN
      WriteLn;
      WriteLn ('The command line parameter specified is not a valid number!');
      Halt (3);
    END;

  {Get amount of memory available, convert to KB}
  FreeMemory := MemAvail;
  FreeMemory := FreeMemory + StackSize + CodeSize + DataSize;
  FreeMemoryInKB := FreeMemory div 1024;
  WriteLn;
  WriteLn ('Free memory: ',FreeMemory,
           ' (',FreeMemoryInKB,' KB)');

  {Return appropriate error level}
  IF FreeMemoryInKB >= MemoryRequired THEN
    BEGIN
      WriteLn ('Available memory equals or exceeds required memory!');
      Halt (0);
    END
  ELSE
    BEGIN
      WriteLn ('Available memory is less than memory required!');
      Halt (1);
    END;

END.


