/* RTNCODE.C ** Program to allow other programs to return an ERRORLEVEL
		to Batch files. Specifically applicable for those programming
		language that don't support the return code facility of DOS.
		The requirement here is that the language supports the ability
		to poke bytes into memory.
							-- R.D.Allen, 12/30/86

Instructions: The value of the byte at Segment 40h, Offset ffh, will be used
	as the return code back to the original process (like a Batch file).
	The only reserved values are 0 and 255. 0 is good status, 255 is
	failure.

	0040:00ff is a "safe" value as it is in the inter-program 
	communication area (ICA) as allowed for by DOS (promise).

	So instead of having in your ".bat" file.....

myprog input1 input2 input3

	.....you install....

rtncode myprog input_1 input_2 input_3

	.... and you use pokes to 40:00ff to assure the return code
	value.


	FREE TO USE BUT NOT TO PROFIT!
	Stelson Products Company
	1625 Travis, Garland, TX 75042
*/

/* Compiled with Lattice 3.1 library */

void prn_long(char *, long);
void mk_title();

#include <stdio.h>
#include <stdlib.h>

/*********
*    NAME:	MY_TITLE
*     USE:  	Make a title and store it in Blurb global. This string
*		should be output before all print lines to identify the
*		author marks and program name.
*   INPUT:  	char	*string; 	-- pointer to argv[0]
*  OUTPUT:  	nothing
*********/

char Blurb[24];

void my_title(string)
char	*string;
{
char	node[12];
char	*strchr();

	stcgfn(node, string);
	*strchr(node, '.') = '\0';
	sprintf(Blurb, "SPC-%s> ", node);
}

/*********
*    NAME:	MAIN
*     USE:  	Using the command line passed, fork using the command
*		line as the arguments. Look in the special place for the
*		return code.
*   INPUT:  	
*  OUTPUT:  	
*********/

#define	SEGMENT	(unsigned int)0x40
#define OFFSET	(unsigned int)0xff

void main(argc, argv)
int	argc;
char	**argv;
{
int	error, rtn;
char	byte;

	my_title(argv[0]);

	byte = 0;
	poke(SEGMENT, OFFSET, &byte, 1);

	error = forkvp(argv[1], &argv[1]);
	rtn = wait();

	if(error == -1) {
		poserr(Blurb);
		byte = 0xff;
	}
	else {
		peek(SEGMENT, OFFSET, &byte, 1);
		printf("%sReturn code was %d, now %d\n", 
			Blurb, rtn & 0xff, (int) byte);
	}

	exit((int)byte);
}
                                                                                                        