               PAGE 60,132
TITLE  FUNKY.COM  VER.2.1  7-AUG-83  19:30
comment *

                        FUNKY.COM


        VERSION 2.0     7-AUG-83

        Written by      Warren Craycroft
                        6236 Oakdale Ave.
                        Oakland, CA  94605


        (C)  1983  by Warren Craycroft.  Permission is granted to copy and
        distribute this program, including source code, provided that no
        charge shall be made except for a reasonable charge for the media
        and handling, and that this notice shall remain intact in all copies.


*
comment *
        This program is a utility that can be used with DOS 2.0
        to allow an n-way branch (typically a menu selection) during
        execution of a batch file.  The program does this by
        testing the user's one key response and returning to DOS an
        "errorlevel" code corresponding to the EXTENDED keycode.
        This errorlevel code can then be tested by the
        batch file program using the IF ERRORLEVEL n  statement.

        When FUNKY is run in a batch file, an appropriate menu
        has been displayed for the user via REM or ECHO statements.
        The user answers with any key that generates an EXTENDED keycode.
        Examples of such keys are the following:

                the function keys F1 - F10

                the shifted function keys

                the Alt-function keys

                the cursor control keys

                most Alt-alphanumeric keys

        If a key that does not generate an EXTENDED code is struck, then this
        program tests for the ESC key, and returns one of two codes:

                if the non-extended key is ESC,  errorlevel = 0

                for any other non-extended key,  errorlevel = 255

        No other error-checking is done by FUNKY.  The subsequent Batch
        File IF tests must determine whether the keystroke response is
        within the extended keycode range, or is an ESC key or other
        "regular" key.  Some examples of extended keycodes are as follows:

                F1 ... F10              59 ... 68

                Shifted F1 ... F10      84 ... 93

                Control F1 ... F10      94 ... 103

                Alt     F1 ... F10      104 ... 113



        A complete list of extended codes and the keys that generate them can
        be found in the IBM Tech Reference, Revised 1982, Table 26, P. 3-14

        Remember that the subsequent IF clauses are "greater than or equal
        to"  and  "less than", so the order of the IF tests is important.

                IF ERRORLEVEL N         means   if errorlevel >= n

                IF NOT ERRORLEVEL N     means   if errorlevel < n


                INCLUDE THESE FILES WHEN ASSEMBLING:

                        PARSER.INC
                        QDISPLAY.INC
                        QGETKEY.INC
                        Q_CMDS.INC


*
;
;               constant equates
;
ESC_CHAR        EQU     1BH             ;ascii ESC keycode
BEL_CHAR        EQU     07              ;ascii BEL code
CR              EQU     0DH             ;ascii carriage return
LF              EQU     0AH             ;ascii  line feed
BLANK_CHAR      EQU     20H             ;ascii blank keycode
;
;       declare a relocatable segment.  Follow the .COM file requirements
;       by ORG'ing to 100H and making all segment register references relative
;       to CS (no relocatable values MOV'ed into segment registers).
;
;
COM_CODE      SEGMENT
;
                ORG     80H             ;Program Segment Prefix command line
PSP_CMD_LINE    LABEL   BYTE

                ORG     100H            ;for COM file
;
                ASSUME  CS:COM_CODE,DS:COM_CODE  ;tell assembler values in
                                        ;CS and DS upon entering this code
;
;       parse command line in PSP for commands inside slashes
;
;       leave CX pointing to first character after leading delimiters if no
;       slashes, or first char after second slash
;
START           PROC    FAR             ;FAR is meaningless; no RET's
;
;       address of PSP's unformatted command line into SI
;
                MOV     SI,OFFSET PSP_CMD_LINE
;
INCLUDE         PARSER.INC
INCLUDE         QDISPLAY.INC
INCLUDE         QGETKEY.INC
;
;       AL = user's answering keystroke.  Test it for extended code
;
                OR      AL,AL           ;is the keycode zero?
                JZ      EXTENDED        ;jump if yes, it's an extended code
                                        ;DOS gives extended code on 2nd call
;
;       not an extended keycode.  FUNKY looks for only one "regular" key,
;       the ESC key:
;
;               if the non-extended key is ESC, errorlevel = 0
;
;               for any other non-extended key, errorlevel = 255
;
                MOV     AH,AL           ;non-extended keycode into AH
                SUB     AL,AL           ;return zero in AL if ESC key
                CMP     AH,ESC_CHAR     ;is it ESC?
                JE      EXIT            ;if yes, return zero errorlevel
                DEC     AL              ;else return 255 errorlevel for ...
                JMP     EXIT            ;... any other non-extended key
;
;       an "extended keycode flag" was received on first call to DOS
;       so call again to get the actual extended code
;
EXTENDED:       MOV     AH,8            ;else extended keycode was typed
                INT     21H             ;get extended code with 2nd call
;
;       AL contains the extended keycode.  Examples are
;
;               F1 ... F10              59 ... 68
;
;               Shifted F1 ... F10      84 ... 93
;
;               Alt  F1 ... F10         104 ... 113
;
;       Return this code as the errorlevel
;
;       The batch file that called FUNKY should then branch appropriatly
;       using IF tests.
;
EXIT:           MOV     AH,4CH          ;DOS fn call for exit
                INT     21H             ;(DOS Manual, p. D-49)
START           ENDP
PAGE
INCLUDE         Q_CMDS.INC
PAGE
;
;        variable data area
;
USERS_ATTRIB    DB      1 DUP(?)        ;temp storage of character attrib
;
COM_CODE        ENDS
                END     START
