#define EXTERN
#define TURBOC

#define PEEK_BYTE(s,o)     (*(char far *)    ( (long)(s)<<16 | (o) ) )
#define PEEK_WORD(s,o)     (*(int far *)     ( (long)(s)<<16 | (o) ) )
#define POKE_BYTE(s,o,b)   (*(char far *)    ( (long)(s)<<16 | (o) ) = b)
#define POKE_WORD(s,o,w)   (*(int far *)     ( (long)(s)<<16 | (o) ) = w)
#define GET_CRT_MODE() PEEK_BYTE(0x40, 0x49)

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include "async.h"


#define		COM1		 0
#define		COM2		 1
#define		COM3		 2
#define		COM4		 3
#define     CTRL_BRK  3
#define     COUNT     200
#define     DELAY_TIME 1000


void interrupt int23(void) ;
void CloseUp(void) ;
void cserve_log_off(void) ;
void init_port(void) ;
void init_modem(void) ;
char ch, ModData ;
int key, port;


void interrupt int23()
{
   exit(0) ;
}
   
void CloseUp(void)
{
   char *rtr ;
   Async_Close(port);
	exit(0);
}
void init_port()
{
	port = COM2 ;
	Async_Init();
	if (!Async_Open(port, 2400, 'E', 7, 1, 1000) )
		 printf("Error opening COM%1s\\n", port+1);
}

void init_modem()
{
   char buffer[80] ;
   int b = 0 ;
   Async_Send_String(port,"ATZ\r") ;
   sleep(3) ;
   for(b = 0; b < 1000 && !Async_Buffer_Check(port); b++ )
      ;

   for(b=0; Async_Receive(port, &ModData) && b < 80;)
      buffer[b++] = ModData ;
   buffer[b] = NULL ;
   if(!strstr(buffer, "OK") )
      {
      printf("\n\n  Error addressing modem") ;
      exit(0) ;
      }
}

clunk()
{
   sound(85) ;
   delay(50) ;
   sound(65) ;
   delay(40) ;
   nosound() ;
}


void dial(char *number)
{
   char buffer[80] ;
   char r_buf[80] ;
   int i,j,b,t,flag ;
   strcpy(buffer, "ATDT") ;
   strcat(buffer, number) ;
   strcat(buffer,"\r") ;
   printf("\n\n") ;

   for(i = 0; i < COUNT; i++)
      {
      printf("Dialing %s, %i previous attempts...           \r",number,i) ;
      Async_Send_String(port,buffer) ;
      for(t = 0; t < 60; t++)              /* this loop controls how long to wait */
         {                                 /* should be about 45 seconds */
         for(j = 0; j < 5; j++) {          /* this loop delays for modem response */
            if(kbhit())
               return ;                    /* should be ~1 second */
            delay(200) ;
            }
         if(bioskey(1) )
            if( (bioskey(0) & 0xFF) == 27)
               break ;
         for(b = 0; Async_Receive(port, &ModData) && b < 80;)
            {
            r_buf[b++] = ModData ;
            r_buf[b] = NULL ;
            delay(10) ;
            }
         if(strstr(r_buf,"BUSY") ) {
            printf("!@# BUSY AGAIN! ") ;
            clreol() ;
            break ;   /* immediately dial again */
            }
         }
      delay(DELAY_TIME) ;
      }
   
}

ProcessInputs()	/* dummy routine for Delay module */
{
}

void get_number(char * buffer)
{
   char local[42] ;
   int c ;
   int i = 0 ;

   do {
      c = getch() ;
        switch(c) {
         case 0:
            getch() ;
            clunk() ;
            break ;
         case 8:
            if( i > 0 ){
               local[--i] = NULL ;
               printf("%c %c",8,8) ;        /* print a destructive BS */
               }
            break ;

         case 13:
            break ;
         case 27:
            local[0] = NULL ;
            break ;
         case 44:
         case 45:
         case 48:
         case 49:
         case 50:
         case 51:
         case 52:
         case 53:
         case 54:
         case 55:
         case 56:
         case 57:
           local[i++] = c ;
           local[i] = NULL ;
           printf("%c",c) ;
           break ;
         default:
            clunk() ;
            break ;
         }
      }
      while( c != 27 && c != 13 && i < 40) ;
      strcpy(buffer,local) ;
      printf("\n") ;
}





main(argc,argv)
int argc;
char **argv ;
{
   char buffer[80] ;
   if(argc == 1) {
      printf("\n\n\nNumber for DEMOND to dial: ") ;
      get_number(buffer) ;
      }
   if(argc == 2) 
      strcpy(buffer,argv[1]) ;
   if(argc > 2) {
      printf("\nUSAGE: DEMOND [number]") ;
      exit(1) ;
      }
   setcbrk(0) ;
   setvect(0x23, int23);
   init_port();
   atexit(CloseUp) ;
   init_modem() ;
   printf("\n\nIf you hear the phone ring, pick up the hand set and hit any key") ;
   dial(buffer) ;
}

