;       title   : "chd"
;
;CHD, by Stephen Barsky, lets you change directories without having to use the
;backslash key in some cases, which can be awkward to reach on some keyboards.
;For example, if you are in C:\WP\LETTERS and want to get to C:\COMM, DOS makes
;you enter CD\COMM, while CHD lets you just enter CD COMM.  (See PC Magazine,
;February 24, 1987, page 309, for a full explanation.)  Now if some ambitious
;programmer wants to make this REALLY useful, it would be nice for this to
;search ALL levels for a specified directory name. Eg: To get from
;C:\WP\LETTERS\BIZ to C:\WP\LETTERS\PERS, you presently have to type the whole
;path name. Why not have CHD PERS keep searching until it finds the first
;subdirectory named PERS? If someone makes this change, please send a copy to
;The Public (Software) Library, P.O.Box 35705, Houston, TX 77235-5705, or
;
cseg    segment para    public 'CODE'

        org     100h
        assume  cs:cseg,ds:cseg,es:cseg,ss:cseg

cd      proc    near                            ;get the current
        mov     ah,47h                          ; directory path
        mov     dl,0                            ;into path
        mov     si,offset path+1
        int     21h

        xor     bx,bx                           ;load the number of
        mov     si,80h                          ;chars passed to
        mov     bl,[si]                         ;this program into bl
        cmp     bl,0                            ;If nothing, then display
        jz      saywhere                        ;this directory

        add     si,bx                           ;Else, make SI point to
        inc     si                              ;the trailing carr return
        mov     byte ptr [si],0                 ; and replace the cr with a 0

loop1:  dec     si                              ;Search backwards from the
        cmp     byte ptr [si],20h               ;trailing CR(now a 0)
        jne     loop1                           ;until you hit a space

        inc     si                              ;point to 1st char of the
        cmp     byte ptr [si],0                 ;parameter.  If its the
                                                ;trailing 0, then display
mybug:  je      saywhere                        ;dir, else save loc of name
        mov     savestart,si

        mov     dx,si                           ;Try setting curr directory
        mov     ah,3bh                          ; to specified path
        int     21h                             ; name.
        jnc     done                            ;It worked, we're done

        mov     di,offset path+1                ;Else find the trailing
        mov     cx,64                           ;zero in the name of
        xor     ax,ax                           ; the current dir and
        cld                                     ;leave the value in DI(+1)
        repne   scasb                           ; Replace zero with backslash
        mov     byte ptr[di-1],"\"

        mov     si,savestart                    ;Copy specified path name
        push    ds                              ; to the end of the
        pop     es                              ; current directory
        repne   movsb                           ;

        mov     dx,offset path                  ;Attempt to change
        mov     ah,3bh                          ;directory
        int     21h                             ;
        jnc     done                            ;It is! & we're gone

;look under the root directory

        mov     dx,savestart                    ;Patch in the leading
        dec     dx                              ; backslash to the
        mov     si,dx                           ; path to see if it's
     mov     byte ptr[si],"\"                   ; under the root
        mov     ah,3bh                          ;Attempt change of
        int     21h                             ;directory.
        jnc     done                            ;It is, we're done.

; else give up.

        mov     dx,offset errmess               ;"We regret to inform you..."
        mov     ah,9                            ;Display error
        int     21h                             ; message and
        mov     rcode,1                         ; set return code.

done: mov       ah,4ch                          ; Exit with return
        mov     al,rcode                        ;  code.
        int     21h                             ;

saywhere:
        mov     di,offset path+1                ; Set DI
        mov     cx,64                           ;  to point to
        xor     ax,ax                           ;  the trailing edge
        cld                                     ; in the path name.
        repne   scasb
        mov     word ptr[di-1],0d0ah            ;patch in a CRLF seq.

        mov     ah,19h                          ;Get the default
        int     21h                             ;drive and
        add     al,"A"                          ;save in Drive.
        mov     drive,al
        mov     dx,offset drive                 ;Display the
        mov     ah,9                            ;current drive and
        int     21h                             ;directory.
        jmp     done

cd      endp

errmess         db      "invalid directory",0ah,0dh,"$"
savestart       dw      0
rcode           db      0

drive           db      0
                db      ":"

path            db      "\"
                db      63 dup ("$")

cseg    ends
        end     cd
