/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : os9fmt.exe
 -----------------------------------------------------------------------------
   file-name	  : p_err.c
   date     	  : 14.12.1993
   last change	  : 14.12.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : Print Error Messages according to int 13h Bios
                    Interrupt description

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             14.12.93  WEW
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>


void p_err(err)
int err;
{
   short y;
   fflush(stdout);
   y=wherey();

   gotoxy(1,y);
   cprintf("\n");
   switch (err)
   {
       case 1:
          cprintf("Bad Command %d",err);
          break;
       case 2:
          cprintf("Address Mark not found %d",err);
          break;
       case 3:
          cprintf("Tried to write on write protected disk %d",err);
          break;
       case 4:
          cprintf("sector not found %d",err);
          break;
       case 5:
          cprintf("reset failed %d",err);
          break;
       case 6:
          cprintf("Diskette removed or changed %d",err);
          break;
       case 7:
          cprintf("bad parameter Table %d",err);
          break;
       case 8:
          cprintf("DMA Overun %d",err);
          break;
       case 9:
          cprintf("attempt to DMA across 64k boundary %d",err);
          break;
       case 0x0a:
          cprintf("bad sector detected %d",err);
          break;
       case 0x0b:
          cprintf("bad track detected %d",err);
          break;
       case 0x0c:
          cprintf("Unsupported track or media type %d",err);
          break;
       case 0x0d:
          cprintf("Invalid number of sectors on format %d",err);
          break;
       case 0x0e:
          cprintf("control data address mark detected %d",err);
          break;
       case 0x0f:
          cprintf("DMA arbitration level out of range %d",err);
          break;
       case 0x10:
          cprintf("uncorrectable CRC/EEC on read %d",err);
          break;
       case 0x11:
          cprintf("ECC corrected data error %d",err);
          break;
       case 0x20:
          cprintf("controller failure %d",err);
          break;
       case 0x40:
          cprintf("seek failed %d",err);
          break;
       case 0x80:
          cprintf("timeout %d",err);
          break;
       case 0xaa:
          cprintf("drive not ready %d",err);
          break;
       case 0xbb:
          cprintf("undefined error %d",err);
          break;
       case 0xcc:
          cprintf("write fault %d",err);
          break;
       case 0xe0:
          cprintf("status error %d",err);
          break;
       case 0xff:
          cprintf("sense operation failed %d",err);
          break;
       default:
          cprintf("Unknown Error %d",err);
          break;
   }
   exit(1);
}
