/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : os9fmt.exe
 -----------------------------------------------------------------------------
   file-name	  : setd17.c
   date     	  : 13.12.1993
   last change	  : 13.12.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : 
I found it necessary for the Toshiba T5200 Laptop to call this function.
When os9fmt doesn't call function 17 this computer tries to format the disk
in HD format without checking the memory at 40:90 and 40:91.

Function 17h    Set Disk Type for Format (diskette)
entry   AH      17h
        AL      00h     not used
                01h     160, 180, 320, or 360Kb diskette in 360kb drive
                02h     360Kb diskette in 1.2Mb drive
                03h     1.2Mb diskette in 1.2Mb drive
                04h     720Kb diskette in 720Kb drive
        DL      drive number (0-7)
return  CF      set on error
        AH      status of operation (see 01h above)
note 1) This function is probably enhanced for the PS/2 series to detect
        1.44 in 1.44 and 720k in 1.44.
     2) This function is not supported for floppy disks on the PC or XT.
     3) If the change line is active for the specified drive, it is reset.
     4) The BIOS sets the data rate for the specified drive and media type.
        The rate is 250k/sec for double-density media and 500k/sec for high
        density media. The proper hardware is required.

        returns from Function 8
        BL      drive type  (AT/PS2 floppies only)
                01h     if 360 Kb, 40 track, 5"
                02h     if 1.2 Mb, 80 track, 5"
                03h     if 720 Kb, 80 track, 3"
                04h     if 1.44 Mb, 80 track, 3"


   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             13.12.93  WEW
*****************************************************************************/
#include <dos.h>
#include "mdos.h"

extern drv_typ drv;

#define CF 1

unsigned char setd17(drive)
unsigned short drive;
{
    unsigned short type;
    struct REGPACK reg;
    int i;


    if (drive==0)
    {
        type=drv.lwa;
    }
    else
    {
        type=drv.lwb;
    }

    if ((type==3) || (type == 4)) type = 4;   /* convert func8 to func17 */

    for (i=0;i<RETRIES;i++)
    {
        reg.r_ax=type |0x1700;    /* int 13h Function 17 */
        reg.r_bx=0;
        reg.r_cx=0;

        reg.r_dx=drive;
        intr(0x13,&reg);
        if ((reg.r_flags &CF) == 0) break;
    }

    if (i==RETRIES)
    {
        if ((reg.r_flags & CF) != 0)
        {
            return((reg.r_ax>>8)&0xff);
        }
    }
    return(0);
}