title   'QUIKFLOP.ASM by Dave Williams, 11/24/1988 ver 2.00'
comment / This program was written and assembled with MASM 5.1. Since it
          doesn't use any of the special directives from MASM 5.x, it should
          assemble under any earlier version.

           The JMP SHORT (label) instructions are to tell the assembler that
          this is a near jump, which saves a bit of code space. Plus MASM
          5.1 bitches and moans about it.

           Version 2.00 at the request of Mike Arst in Seattle, who for some
          reason wanted to restore his floppies to their defaults for something.
        /

cseg    segment para public 'code'
        assume  cs:cseg,ds:cseg,es:cseg
main    proc    far
        org     100h
start:  jmp     begin

lf      equ     0Ah                     ;ASCII for linefeed
cr      equ     0Dh                     ;ASCII for carriage return
bel     equ     07h                     ;ASCII bell character
logon   db      'QuikFlop v2.01 Copyright (c) Dave Williams 1989',cr,lf,'$'
logoff  db   lf,'         Diskette parameters changed',cr,lf,'$'
help    db      ' Syntax: quikflop /Q /R ',cr,lf
        db      '         /Q speeds up floppy drive',cr,lf
        db      '         /R resets to IBM defaults',cr,lf,'$'
IBM     db   lf,'         Parameters reset to IBM defaults',cr,lf,'$'
badparm db  bel,'Bad Parameter',cr,lf,'$'
defname db      'NUL',2 dup (0)         ;make larger for more params later

begin:
        mov     dx,offset logon         ;say hello and display copyright
        mov     ah,09h                  ;DOS function to display a string
        int     21h                     ;call DOS

        cmp  byte ptr ds:[80h],0        ;any command line parameter chars?
        jz      help_msg                ;no, show them the help screen
        cmp byte ptr ds:[81h],'/'       ;is first character a slash? 
        jz      get_toggle              ;yes, go get toggle char(s)

read_data:  mov  si,82h                 ;see if there're any parameters
            mov  bx,offset defname      ;point bx to defname

; get toggle character(s)
get_toggle:
        lodsb                           ;load next byte & INC SI
        cmp     al,'/'                  ;is it a toggle character?
        jz      get_toggle              ;yes, so try again
what_toggle:
        and     al,95   ;capitalize (if it gets here, it's the char after a /)
        cmp     al,'Q'                  ;gimme an Q?
        jz      setparms                ;set parms to generalized fast mode
        cmp     al,'R'                  ;gimme an R?
        jz      reset_IBM               ;reset parms to IBM defaults
        mov     dx,offset badparm       ;beep 'em and say there's a problem
        mov     ah,09h                  ;DOS function to display a string
        int     21h                     ;call DOS
        jmp short help_msg              ;give 'em the help message again


;let's do it
setparms:
; begin BIOS table modification (the GUTS!)
        push    ds                      ;save for linkage
        xor     ax,ax                   ;clear for return
        push    ax                      ;put in stack

        push    ds                      ;modify diskette parameters
        mov     ds,ax                   ;offset into disk table
        lds     di,dword ptr ds:78h     ;address of disk table
        mov     byte ptr [di],175       ;modify step rate     (normal 239)
        mov     byte ptr [di+2],5       ;and motor stop delay (normal 37)
        mov     byte ptr [di+0Ch],0     ;and head settle time (normal 15-25)
        mov     byte ptr [di+0Ah],1     ;motor start time, 1/8 sec increments
        int     13h                     ;reset diskette system
        pop     ds                      ;clear the stack
; tell 'em we're done and goodbye
        mov     dx,offset logoff        ;tell 'em we're through
        mov     ah,09h                  ;DOS function to display a string
        int     21h                     ;call DOS
        jmp short exitok


reset_IBM:
; begin BIOS table modification (same routine as setparms)
        push    ds                      ;save for linkage
        xor     ax,ax                   ;clear for return
        push    ax                      ;put in stack

        push    ds                      ;modify diskette parameters
        mov     ds,ax                   ;offset into disk table
        lds     di,dword ptr ds:78h     ;address of disk table
        mov     byte ptr [di],239       ;reset step rate      (normal 239)
        mov     byte ptr [di+2],37      ;and motor stop delay (normal 37)
        mov     byte ptr [di+0Ch],25    ;and head settle time (normal 15-25)
        mov     byte ptr [di+10h],2     ;motor start time, 1/8 sec increments
        pop     ds                      ;clear the stack

        mov     dx,offset IBM           ;tell 'em we reset everything
        mov     ah,09h                  ;DOS function to display a string
        int     21h                     ;call DOS
        jmp short exitok


help_msg:
        mov     dx,offset help          ;tell 'em about the program
        mov     ah,9
        int     21h
        jmp short exitok

; exit to DOS
exitok: mov     al,0                    ;set errorlevel to 0
        mov     ah,04Ch                 ;exit w/errorlevel
        int     21h

main    endp
cseg    ends
        end     start

COMMENT /
 table of data on diskette parameter table:
Interrupt 1Eh  Vector of Diskette Controller Parameters
(0:0078h)       Dword address points to data base table that is used by BIOS.
                Default location is at 0F000:0EFC7h. 11-byte table format:
                bytes:
                00h     4-bit step rate, 4-bit head unload time 
                01h     7-bit head load time, 1-bit DMA flag
                02h     54.9254 ms counts - delay till motor off (37-38 typ)
                03h     sector size: 
                        00h     128 bytes
                        01h     256 bytes
                        02h     512 bytes
                        03h     1024 bytes
                04h     last sector on track (8 or 9 typical)
                05h     gap between sectors on read/write (42 typical)
                06h     data length for DMA transfers (0FFh typical)
                07h     gap length between sectors for format (80 typical)
                08h     sector fill byte for format (0F6h typical)
                09h     head settle time (in milliseconds) (15 to 25 typical)
                        DOS 1.0   0
                        DOS 2.10  15
                        DOS 3.1   1   (allegedly)
                0Ah     motor start time (in 1/8 second intervals) (2 to 4 typ.)
                        DOS 2.10  2
COMMENT /
