  Program FixEXEFileHeader;
  uses dos;

  type
    HeaderRec = Record
                     Sig      : Array[0..1] of Char;
                     ImgLen   : Word;
                     FilSiz   : Word;
                     RelTbl   : Word;
                     HdrSiz   : Word;
                     MinPar   : Word;
                     MaxPar   : Word;
                     StkOfs   : Word;
                     SPOfs    : Word;
                     ChkSum   : Word;
                     IPOfs    : Word;
                     CSOfs    : Word;
                     RelOfs   : Word;
                     OvrNum   : Word;
                   end;

  var
    exefile : file of HeaderRec;
    hrec       : HeaderRec;
    fname      : string[64];
    err        : word;
    oldvalue   : longint;
    i          : byte;
    ans        : Char;

  Procedure GiveHelp;
    begin
      WriteLn('ExeMax is a program to patch a Turbo Pascal (or any)');
      WriteLn('executable (.EXE) file to request all memory when it');
      WriteLn('loads.  The Turbo Pascal compiler only allows compilation');
      WriteLn('to request up to 640k.  If you have more and you want all');
      WriteLn('you have, the .EXE file must ask for it.  It does this by');
      WriteLn('signalling DOS that it requests one megabyte.  DOS, of ');
      WriteLn(
        'course, doesn''t have one megabyte, but gives it all it has.');
      WriteLn('In order to achieve this result the values at offsets');
      WriteLn('13 and 14 of the header of the .EXE file must be 255.');
      WriteLn('ExeMax takes care of that.');
      WriteLn;
      WriteLn('Syntax:  EXEMAX [d:] [path] [filename] | [/? | /H]');
      WriteLn('         Wildcards are not permitted');
      WriteLn;
      fname := '';
    end;

  Procedure GetName;
    begin
      Write(#13'Name of EXE file to fix (? for Help, Q to Quit): ');
      ReadLn(fname);
      if (pos('/',fname) <> 0) or (pos('?',fname) <> 0)
        or (pos('*',fname) <> 0) then GiveHelp;
    end;

  Procedure ErrorProc(e : word; stopcode : boolean);
    begin
      Write('Error ',e,' - ');
      case e of
        2      : Write('File not found');
        3      : Write('Invalid path');
        4      : Write('Too many open files');
        5      : Write('Access denied');
        6      : Write('Invalid file handle');
       12      : Write('Invalid file mode');
      100      : Write('Disk read error');
      101      : Write('Disk write error');
      103      : Write('File not open');
      104      : Write('File not open for input');
      105      : Write('File not open for output');
      150      : Write('Disk is write protected');
      152      : Write('Driver not ready');
      156      : Write('Disk seek error');
      157      : Write('Unknown media');
      158      : Write('Sector not found');
      160      : Write('Device write fault');
      161      : Write('Device read fault');
      162      : Write('Hardware failure');
      else       Write('Unspecified error');
      end; { case }
      if stopcode then
        begin
           WriteLn(' - Aborting...');
           halt(e);
        end else WriteLn;
    end;

  begin
    WriteLn;
    WriteLn('EXEMAX.EXE by Rick Housh');
    WriteLn;
    repeat
      err := 0;
      fname := '';
      if ParamCount > 0 then fname := ParamStr(1);
      if (fname = 'Q') or (fname = 'q') then fname := '';
      if (pos('/',fname) <> 0) or (pos('?',fname) <> 0)
        or (pos('*',fname) <> 0) then
          begin
            GiveHelp;
            Halt(0);
          end;
      if fname = '' then repeat GetName until fname <> '';
      if (fname = 'Q') or (fname = 'q') then halt;
      i := pos('.',fname);
      if i > 1 then fname[0] := chr(i - 1);
      if pos('.',fname) = 1 then
        begin
          WriteLn(#7,'Illegal file name.  Aborting...');
          Halt(1);
        end;
      for i := 1 to length(fname) do fname[i] := Upcase(fname[i]);
      fname := fname + '.EXE';
      assign(exefile,fname);
      filemode := 0;
      {$I-}
      reset(exefile);
      {$I+}
      err := IOResult;
      if err <> 0 then
        begin
          WriteLn(#7'Error ',err,' opening ',fname);
          ErrorProc(err,false);
          WriteLn;
        end;
    until err = 0;
    read(exefile,hrec);
    close(exefile);
    if HRec.Sig <> 'MZ' then
      begin
        WriteLn(#7'File ',fname,' is NOT an .EXE file');
        WriteLn('It does not start with MZ (4Dh-5Ah)');
        Halt;
      end;
    oldvalue := HRec.MaxPar;
    WriteLn('File ',fname,':');
    WriteLn;
    WriteLn('Current Memory Request: ',oldvalue:7,' paragraphs, ',
            (longint(oldvalue * 16)):8,' bytes, ',
            (oldvalue + 1) div 64:4,' KBytes');
    WriteLn;
    If oldvalue > $FFFE then ans := #255 else ans := #0;
    If ans = #0 then
    begin
      Write(
       'Do you wish to increase the request to maximum allowable [Y/N]? ');
      ReadLn(ans);
    end;
    if NOT (ans in ['Y','y']) then
      begin
        Write('Exiting...  ');
        If ans = #255 then WriteLn('Size was already at maximum')
          else
        WriteLn('At user''s request');
        WriteLn;
        Halt;
      end;
    HRec.MaxPar := $FFFF;
    FileMode := 2;
    {$I-}
    reset(exefile);
    {$I+}
    err := IOResult;
    if err <> 0 then ErrorProc(err,true);
    {$I-}
    write(exefile,HRec);
    {$I+}
    err := IOResult;
    if err <> 0 then ErrorProc(err,true);
    {$I-}
    close(exefile);
    {$I+}
    err := IOResult;
    if err <> 0 then ErrorProc(err,true);
    Writeln;
    WriteLn('File ',fname,' fixed...');
  end.