PROGRAM SeeMem;

 {$M 65520,0,655360}

 {
  Version 2.70 - February 16, 1994
  SeeMem displays a Memory Map of all resident programs,
   device drivers, environment blocks, and other resident data.

  Usage:  SEEMEM  [/l] [/n] [/c] [/?]
            to show all Memory Control Blocks (MCBs)

  Author: Tedrick A. Housh, Jr.  - "Rick" Housh
          5811 W. 85th Terrace
          Overland Park, KS 66207-1659
          Compuserve 72466,212

   Language: Turbo Pascal 7.0

   Caution!  If you wish SEEMEM to work properly on any computer which
             has more or less than 640k of conventional memory, you MUST
             manually patch the .EXE file header to force requesting
             all memory available to DOS be given to SEEMEM.EXE -
             Turbo Pascal provides no method to compile a program to
             request more than 640k -  Why not?  Who knows?  An
             alternative is to compress SEEMEM.EXE with PKLITE by
             PKWare, Inc., which automatically makes this change in the
             .EXE file, or use EXEMAX.EXE which will do the patch
             automatically to SEEMEM.EXE (or any other EXE file for
             that matter), but does not compress the .EXE file.
             EXEMAX is included in the source code package for SEEMEM,
             which also includes the source code for EXEMAX.

   SEEMEM History
   10/18/91  -  Beta version 1.00B released to public domain
   10/24/91  -  Fixed logic flaw in error detection in use of Proc
                  QueryFreeMemXMS - XMSerrors $A0 and $A1
                  are result codes, not real errors.
             -  Fixed minor bug in display where exactly one screenful
                  for Conventional and Upper memory.  Rearranged
                  output - placed "NO EMS" and "NO XMS" messages on
                  last page of display.
             -  Assigned new minor version number - 1.01B
   11/02/91  -  Added display of standard extended memory amount
                  total/used/remaining and XMS extended memory amount
                  total/used/remaining/largestblock
             -  Fixed minor problem displaying XMS error returns
             -  Fixed minor problem checking for link of UMB to
                  Conventional and DOS = UMB in CONFIG.SYS
             -  Patched executable to work with more than 640k
             -  Assigned new minor version number - 1.02B
   11/21/91  -  Added summary display of location of command shell
             -  Added support for DR-DOS 6.0 (Signs on as DOS 3.31)
             -  Changed detection of location of DOS=High to location
                  of current disk buffer where possible; If running
                  under DOS 5.xx or DR-DOS DOS furnishes DOS location
             -  Changed algorithm to detect whether UMB's are linked
                  through pointers to Conventional memory (CNV link)
                  MS-DOS and DR-DOS and QuarterDeck patch top of
                  memory one paragraph lower than before installation,
                  with the resulting MCB having a 'Z' ID byte, and
                  pointing to MCB controlling UMB's (I think).
             -  Added support for 4DOS command shell
                  (May work for Norton Utility's NDOS?)
             -  Added detection of location of command shell
                  i.e. Conventional Memory, UMB, HMA, and
                  display of command shell name, where possible
             -  Added automatic detection of output redirection, and
                  force page breaking off if redirected to anything other
                  than standard output
             -  Assigned new version number - 1.50
   12/17/91  -  Added additional support for DR-DOS 6.0 and 4DOS 4.0
             -  Detects additional DR-DOS UMB owner segments
                  8 = DOS configuration
                  7 = Reserved from UMB pool for video, etc.
                  6 = Programs which load themselves
                       through UMB Device Driver
                       (not through DOS loadhi functions)
             -  Detects and displays locality of DOS (Conventional or HMA)
                  and SHELL (Conventional or UMB)
             -  Detects and displays free XMS handles, XMS and UMB memory
                  as Total-Used-Available-Largest Available Block
             -  Detects and displays UMB usage as Reserved-HiLoaded-
                  System Loaded and Self-Loaded (Program loads itself high)
             -  Added automatic command line redirection detection, and
                  automatic shift to non-pause mode when redirected to
                  other than CON device
             -  Assigned new version number - 2.00
   12/22/91  -  Fixed bug in printing BCD strings - Added BCDtoStr Function
             -  Fixed bug in kilobyte size display - No "round down" on
                  size of exactly 1024 bytes
             -  Fixed error in display of unused XMS extended handles
             -  Fixed error in calculating size of blocks exactly 64k
             -  Assigned new version number - 2.01
    6/28/92  -  Fixed bug in length of screen - Get screen rows from 40:84
             -  Changed step to look for 1st UMB to 1024 bytes (was 16)
    8/14/92  -  Assigned new version number - 2.5
             -  Added display of header to top of each page
             -  Added page number to each header
             -  Added /L switch to allow printing of 55 line pages
             -  Added display of following:
                1 - Interrupt Vector Table (Hard Coded)
                2 - ROM BIOS Data Area (Hard Coded)
                3 - DOS Data Area (Hard Coded)
                4 - DOS device driver code area (native devices)
                5 - DOS system data table area ("List of Lists")
                6 - TSR command line where available
                7 - Nature of Load for UMB TSR's
                    a) Loaded by LoadHigh/DOS/UMB manager "TSR-LoadHi"
                    b) Loaded itself high "TSR-AutoHi" (ONLY DR-DOS 6.0)
                8 - Names of UMB device driver programs (ONLY DR-DOS 6.0)
                9 - Status of UMB's Unused but reserved
                     by UMB Manager (DR-DOS 6.0 and MS-DOS where possible)
             -  Removed display of whether Conventional Memory
                 linked to UMB's - Insufficiently generic, too unreliable
             -  Changed all BASM cbw instructions to xor
             -  Fixed bug in EMS display where EMM386.SYS in operation
             -  Added Detection of Windows and Windows Enhanced/386
             -  Fixed bug in walking MCB chain in enhanced Windows
    9/17/92  -  Removed display of size of UMB's in kilobytes and added,
                 in its place, a display of the segment of the parent
                 (loader) of the process occupying that UMB
             -  Added support of Helix Software's Netroom Memory Manager
             -  Fixed bug in reporting of UMB's in certain UMB areas
                 placed in ROM space by QEMM's Stealth function
             -  New version Number, 2.6
   11/13/92  -  Added support for Qualitas' 386Max
             -  New version Number, 2.65
   01/15/93  -  Fixed various minor bugs
   02/06/93  -  Fixed programming error which caused no detection of UMB's
                 above FF00.
             -  New version Number, 2.66
   09/14/93  -  Apparently QEMM version 7.xx changes the data block
                 pointed to by DOS function 52h (the "List of Lists")
                 to an upper memory block, causing SEEMEM much confusion.
                 Changed assumption that Lists of Lists lower than first
                 DOS MCB.
             -  New version Number, 2.67
   02/16/94  -  Fixed small bug - Last UMB displayed no owner
             -  Fixed IsTrueMCB Procedure to return False if next MCB
                 address is above Segment $FFFF, regardless of whether
                 an 'M' or 'Z' block.  Necessary for 386Max, v. 7
             -  New version Number, 2.70


 }


TYPE
  String2     = String [2];
  String3     = String [3];
  HexStr4     = String [4];
  String5     = String [5];
  TypeBlock   = String [11];
  PathStr     = String [79];
  String80    = String [80];
  String128   = String [128];
  IDChars     = SET OF Byte;
  DoubleWord  = ARRAY [0..1] of Word;
  AsciiZArray = ARRAY [1..256] of Char;
  AsciiZPtr   = ^AsciiZArray;
  NopeYep     = ARRAY [False..True] of String3;
  MCBPointer  = ^MCBStruc;

 TxtRec =
   RECORD
     Handle    : Word;              { We don't need the full DOS.TPU rec }
     Mode      : Word;              { Just these two, for raw - cooked }
   END;

  UMBSegStruc =
   RECORD
     UMBSeg    : Word;
     UMBSize   : Word
   END;

  MCBStruc =
    RECORD
      IDchar   : Byte;                 {'M' ($4D) or 'Z' ($5A)}
      OwnerSeg : Word;                 {0=available,8=DOS else real owner}
      Size     : Word;                 {16-byte pgphs, excluding this one}
      NetRoomID: ARRAY [1..3] OF Char; {NetRoom uses these reserved spots}
      ProgName : ARRAY [1..8] OF Char; {only furnished by DOS > 3}
    END;

  PSPStruc =
    RECORD
      StopCode    : Word;                     { INT 20h or 27h $CD20/$CD27}
      Misc        : ARRAY [3..$16] OF Byte;   { Unused by SeeMem }
      ParentTag   : Word;                     { Reserved by SeeMem }
      Stuff       : ARRAY [$19..$2C] OF Byte; { Unused by SeeMem }
      Environment : Word;
      MoreStuff   : ARRAY [$2F..$50] OF Byte;  { Up to Cmd Params }
      Int21       : Word;
      MoMoStuff   : ARRAY [$52..$7F] OF Byte;
      CmdString   : String128;
    END;


CONST
  PrgNameStr        = 'SeeMem';
  PrgDateStr        = 'Winter 94';
  PrgVerStr         = '2.70';
  NoOrYes           : NopeYep    = (' NO','YES');
  M_or_Z            : IDChars    = [$4D, $5A];
  DosName           : String[9]  = '[MS-DOS] ';
  OSName            : String[6]  = 'MS-DOS';
  XMSName           : String[12] = '[XMS Driver]';
  CmdPrgName        : String[9]  = '[COMMAND]';

VAR
  Ch                         : Char;
  MemSegStr                  : HexStr4;
  PreviewStr                 : String80;
  CmdStr, ThisPrgName        : PathStr;
  DosVerStr                  : String5;
  AsciiZerror,
  IOCTLmode, LineNum,
  DosMajVer, DosMinVer,
  XMSerror, DosLocus,
  _4DOSLevel, ByteCtr,
  PageNo,
  HandleCount                : Byte;
  TotalExtMem,XMSAvail,
  nonXMSExtendMem, HMAUsed,
  PageFrame, Cols, Rows,
  OurEnvSize, MasterPSP,
  FirstMCB, MaxXMSMem,
  TableOfs,
  TableSeg, TopCnvMem,
  DosLoadSeg, XMSResult,
  XMSVersion, XMSRevision,
  _4DosVer, _4DosPSP, _2EVec,
  XMSFreeHandles, StepValue,
  XMSLargest, ShellPSP        : Word;
  Segment, SecondMCB,
  LastTrueMCB,
  UMBLargest, UMBTotFree,
  UMBTotal, TempSeg,
  Lowermax, TmpLongInt        : LongInt;
  isXMS, isHMA, isUMB,
  isEMS, isUMBdriver, isAT,
  isUMBDOS,
  isDRDOS,  is4Dos, isWinStd,
  isRedirected, isWinEnh,
  isNameInMCB, LongPage,
  isNetRoom, isNetRoomTSR,
  NoCmdLineFix, is386Max,
  Finished, Upper, Paging,
  isMonoVideo                 : Boolean;
  ThisMCB,
  NextMCB                     : MCBPointer;
  UMBstruct                   : UMBSegStruc;
  XMM_Control                 : DoubleWord;
  OutputRec                   : ^TxtRec;


Function GetEMSPageFrame : Word ; assembler;
    var err : byte;
        asm
         xor     bx,bx
         mov     ah,41h             { Get Page Frame Segment }
         int     67h
         or      ah,ah              { Check for Error }
         jz      @exit              { If IS error, exit }
         xor     bx,bx              { else zero page frame }
      @exit:
         mov     ax,bx              { return page frame in ax }
      end; { asm }

Function GetEnv(Str : PathStr) : PathStr;
  VAR
    TempStr      : PathStr;
    TempNum,
    EnvSeg,
    EnvLength   : Word;
    ch, lastch  : Char;
    idx         : Byte;
  BEGIN
    GetEnv := '';
    Str := Str + '=';
    EnvSeg := MemW[PrefixSeg:$2C];
    EnvLength := MemW[EnvSeg:0005];
    ch := #1;
    lastch := #0;
    TempNum := 0;
    REPEAT
      lastch := ch;
      ch := chr(Mem[EnvSeg:TempNum]);
      inc(TempNum);
    UNTIL ((ch = #0) AND (lastch = #0)) OR (TempNum >= EnvLength);
    If TempNum < EnvLength THEN EnvLength := TempNum;
    TempNum := 0;
    REPEAT
      TempStr := '';
      idx := 0;
      REPEAT
        ch := chr(Mem[EnvSeg:TempNum + idx]);
        if ch <> #0 THEN TempStr := TempStr + ch;
        inc(idx);
      UNTIL (ch = #0);
      TempNum := TempNum + idx;
    UNTIL (TempNum >= EnvLength) OR (Pos(Str,TempStr) = 1);
    IF Pos(Str,TempStr) = 1 THEN
       TempStr := Copy(TempStr,Length(Str)+1,Length(TempStr))
        ELSE TempStr := '';
    GetEnv := TempStr;
  END;

Procedure WriteHeader(Pg:Byte);
  BEGIN
    Write(  '  MCB     Owner    Size    Parent  ');
    WriteLn('(',PrgNameStr,' v ',PrgVerStr,', ',PrgDateStr,')',
            ' - Page ',Pg);
    WriteLn('Segment  Segment  Bytes   Segment     Type       ',
          'Owner Name - Cmd Line');
    WriteLn('-------  ------- -------  ------- -------------',
          '  ----------------------');
    LineNum := Linenum + 3;
    Inc(PageNo);
  END;

Procedure WriteAsciiZ(Incoming: AsciiZPtr;MaxLen : Word);
      VAR                      { Displays a 255 char (max) string   }
        Idx : Word;            { which is terminated with a null    }
        C   : Char;            { character.  Optionally can specify }
        TmpStr : String[64];   { maximum length and filter each     }
                               { Char and display until = #0 or     }
      BEGIN                    { Length reaches MaxLen              }

        AsciiZError := 0;
        Idx := 1;
        TmpStr := '';
        WHILE (Incoming^[Idx] <> #0) AND (Idx <= MaxLen) DO
          BEGIN
            C := Incoming^[Idx];
            IF (C in [#32,':','!','@','#','$','%','^','&','(',')',
              '_','-','{','}','~','`',#39,'0'..'9','A'..'Z'])
               THEN TmpStr := TmpStr + C;
            IF TmpStr = '' THEN AsciiZerror := 255;
            Inc(Idx);
           END;
        IF (TmpStr <> '') AND (AsciiZerror <> 255) THEN Write(TmpStr);
      END; {Procedure WriteAsciiZ}


FUNCTION InEnhancedWindows : Boolean; assembler;
    asm
         xor     cx,cx              { Default to False }
         mov     ax,1600h           { Windows Install check }
         int     2Fh
         cmp     al,80h             { 80h means not enhanced }
         jz      @exit              { If not exit }
         or      al,al              { 0 also means not enhanced }
         jz      @exit              { so exit }
         mov     cx,1               { Else Return True }
    @exit:
         xchg    ax,cx
    end;
   { Function inEnhancedWindows }

FUNCTION InStandardWindows : Boolean; assembler;
    asm
         xor     cx,cx              { Default to False }
         mov     ax,4680h           { Windows Real/Std Mode Install check }
         int     2Fh
         or      ax,ax              { 0h means IS Standard Mode }
         jnz     @exit              { If not Std Mode exit }
         mov     cx,1               { Else Return True }
    @exit:
         xchg    ax,cx
    end;
   { Function inStandardWindows }

FUNCTION ExistXMS : Boolean; assembler;
    asm
         xor     cx,cx                          { Use cx for ret value }
         mov     ax,4300h                       { DOS test for XMS func }
         int     2Fh                            { Through multiplex int }
         cmp     al,80h                         { $80 means DOES exist  }
         jne     @exit                          { So, exit - cx = 0 }
         mov     ax,4310h                       { Else get Vector w/DOS }
         int     2Fh                            { Through multiplex INT }
         mov     Word Ptr [XMM_Control],bx      { Offset in BX }
         mov     Word Ptr [XMM_Control + 2],es  { Seg in ES }
         inc     cx                             { cx = 1 = True }
    @exit:
         xchg    ax,cx                          { Put cx in ax for return }
    end; { asm }
   { Function ExistXMS }


PROCEDURE UMBalloc640k; assembler;
    asm
         xor     dx,dx              { Use dx to zero out things }
         mov     XMSResult,dx       { Default Failure        }
         mov     XMSError,80h       { Default not implemented}
         cmp     isXMS,dl           { If NO XMSdriver won't work }
         jz      @exit              { so exit }
         dec     dx                 { else, attempt alloc 0FFFFh }
         mov     ax,1000h           { impossible large block of UMB's }
         Call    [XMM_Control]      { through driver }
         mov     XMSResult,ax       { set Result }
         mov     XMSError,bl        { and Error  }
    @exit:
    end; { asm }
  { Procedure UMBalloc640k }


FUNCTION ExistUMBdriver : Boolean; assembler;
    asm
         xor     ax,ax              { Default to False }
         cmp     isXMS,al           { If NO XMS driver }
         jz      @exit              { just exit }
         call    UMBalloc640k       { else test for UMB Driver }
         cmp     XMSError,80h       { Is it implemented? }
         jz      @exit              { If not just exit }
         mov     ax,1               { Else Return True }
    @exit:
    end;
   { Function ExistUMBdriver }


FUNCTION ExistUMBmem : Boolean; assembler;
{ Attempts to allocate an impossibly large UMB.  On failure ax     }
{ contains 0, bl indicates UMB's unimplemented if $80, or $bx      }
{ on other error.  No provision made for success here. Impossible  }
{ to succeed.  Note that the UMB manager doesn't necessarily depend}
{ on existence of XMS manager, but if there is no control call     }
{ vector there is no way to call this UMB function.                }
    asm
         xor     cx,cx              { Default to False }
         cmp     isXMS,cl           { If NO XMS driver }
         jz      @exit              { then exit }
         call    UMBalloc640k       { else test for UMB driver, if Driver }
         cmp     XMSError,0AEh      { BUT all UMB's used up }
         jb      @exit              { then exit, else }
         mov     cx,1               { return True }
    @exit:
         xchg    ax,cx              { Switch ax with cx for return }
    end;  { Assembler Function ExistUMBmem }


FUNCTION DOSequalUMB : Boolean; assembler;
    asm                             { DOS 5+ can detect DOS UMB ownership}
         xor     cx,cx              { Use cx for return }
         cmp     DosMajVer,5        { If not at least DOS 5 then exit }
         jb      @exit              { with return of False (0) }
         mov     ax,5802h           { Get current UMB State }
         int     21h                { AL=00 NOT linked to DOS control }
                                    { AL=01 ARE linked to DOS control }
         xor     ah,ah              { Get rid of AH }
         push    ax                 { Save Current State }
         mov     ax,5803h           { Attempt Set UMB's Linked }
         mov     bx,1               { to DOS control }
         int     21h
         pop     bx                 { Restore prior state }
         jc      @exit              { If carry, not DOS's }
         mov     ax,5803h           { UMB State }
         int     21h
         inc     cx                 { Set to True }
    @exit:
         xchg    cx,ax              { Switch cx-ax for return }
    end; { asm }
  { Function DosEqualUMB }


FUNCTION ExistEMS: Boolean; assembler;
    CONST
      EMName           : ARRAY [0..7] of CHAR = 'EMMXXXX0';
    asm
         mov     ax,3567h           { Get Vector for EMS interrupt 67h }
         int     21h
         mov     di,10              { Point to device driver name }
         mov     cx,8               { for 8 bytes }
         lea     si,EMName          { compare with constant name }
         cld                        { in forward direction }
         xor     ax,ax              { Default to False }
         repz    cmpsb              { Compare strings }
         jnz     @exit              { If strings NOT equal, exit False }
         inc     ax                 { Else set to True }
    @exit:                          { and exit }
    end; { asm }
    { Function ExistEMS }


FUNCTION isXMSok : Boolean; assembler;
{ Used by other XMS functions to make certain XMS is implemented   }
{ before making a far call to the control vector of the XMS driver }
    asm
         mov     ax,1               { Default return to True }
         mov     XMSResult,ax       { Default to Success }
         mov     XMSError,ah        { and NO Error }
         cmp     isXMS,ah           { If IS XMS Driver }
         jnz     @exit              { then just exit }
         dec     al                 { Else Return False }
         mov     XMSResult,ax       { Set Failure }
         mov     XMSError,80h       { and "unimplemented" }
    @exit:
    end;
  { Function isXMSok }


PROCEDURE GetXMSversionAndHMAstatus; assembler;
{ Sets Words XMSVersion and XMSRevision and Boolean isHMA }
{ XMSVersion and XMSRevision are in BCD }
    asm
         xor     ax,ax              { isHMA will start False }
         xor     bx,bx              { Initialize 0 version }
         xor     dx,dx              { and 0 Revision }
         cmp     isXMS,al           { If NO XMS then }
         jz      @skipcall          { Set as initialized, else }
                                    { ax=0=XMS function zero }
         call    [XMM_Control]      { Call Control vector }
    @skipcall:
         mov     isHMA,dl           { dl has HMA state }
         mov     XMSVersion,ax      { ax has version # }
         mov     XMSRevision,bx     { bx has revision # }
    end; { asm }
   { Procedure GetXMSversionAndHMAstatus }


PROCEDURE GetMemHMA(Malloc : Word); assembler;
{ Attempts to allocate HMA memory }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @exit              { Just Exit, Else }
         mov     dx,Malloc          { # of HMA bytes to request }
         mov     ax,0100h           { XMS function 1 }
         call    [XMM_Control]      { Call Control vector }
         mov     XMSResult,ax       { Result }
         cmp     bl,80h             { Any bl lower than 80h no error }
         jb      @exit
         mov     XMSError,bl        { Set error }
    @exit:
    end; { asm }
   { Procedure GetMemHMA }


PROCEDURE ReleaseMemHMA; assembler;
{ Attempts to release HMA if allocated }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @exit              { Just Exit, Else }
         mov     ax,0200h           { Release HMA Function }
         call    [XMM_Control]      { Through Driver }
         mov     XMSResult,ax       { Copy to Result }
         cmp     bl,80h             { If NO error }
         jb      @exit              { exit, else }
         mov     XMSError,bl        { Update error return first }
    @exit:                          { then exit }
    end; { asm }
   { Procedure ReleaseMemHMA }


PROCEDURE QueryA20; assembler;
{ XMSResult = 1 if A20 is physically enabled, else 0 }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @exit              { Just Exit, Else }
         mov     ax,0700h           { Query A20 line func }
         call    [XMM_Control]      { through driver }
         mov     XMSResult,ax       { Update result }
         mov     XMSError,bl        { and Error }
    @exit:                          { and exit }
    end; { asm }
   { Procedure QueryA20 }


PROCEDURE QueryFreeMemXMS; assembler;
{ XMSResult = total free Extended Memory in kilobytes }
{ XMSError = $80 if unimplemented, else allocation error code }
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @exit              { Just Exit, Else }
         mov     XMSLargest,0       { Default to zero size }
         mov     XMSResult,0        { and result too }
         mov     ax,0800h           { Function 8 }
         call    [XMM_Control]
         mov     XMSResult,dx       { dx has total free }
         mov     XMSLargest,ax      { ax has largest free block }
         cmp     bl,80h             { if No error }
         jb      @next              { get free handles }
         mov     XMSError,bl        { else set error }
         jmp     @exit              { then exit }
    @next:
         xor     bx,bx              { bx gets 0 }
         mov     XMSFreeHandles,bx  { as does result }
         mov     ax,0900h           { Function 9, allocate XMS }
         mov     dx,1               { get 1k only }
         call    [XMM_Control]
         mov     XMSError,bl        { set Error }
         cmp     ax,0               { if failure }
         jz      @exit              { exit, else }
         push    dx                 { save handle number }
         mov     ax,0E00h           { Function 14, dx has handle }
         call    [XMM_Control]
         pop     dx                 { retrieve handle number }
         mov     XMSError,bl        { set error code }
         cmp     ax,0               { if NO success, exit }
         jz      @exit              { else get free handles }
         xor     bh,bh              { zero bh }
         mov     XMSError,bh        { set error 0 }
         mov     XMSFreeHandles,bx  { save number of free handles }
         mov     ax,0A00h           { Function 10 frees handle used }
         call    [XMM_Control]      { Ignore errors - Can't help it }
    @exit:
    end; { asm }
   { Procedure QueryFreeMemXMS }


PROCEDURE RelUpperMemBlockUMB(RelUMBSeg: Word); assembler;
    asm
         call    isXMSok            { Check if all ok }
         or      al,al              { If False }
         jz      @exit              { Just Exit, Else }
         mov     ax,1100h           { Release UMB block func }
         mov     dx,RelUMBSeg       { Segment of block to release }
         call    [XMM_Control]      { Through driver }
         mov     XMSResult,ax       { Copy result from ax }
         cmp     bl,7Fh             { If error return 80h or greater }
         ja      @exit              { Is result not error so return }
         mov     XMSError,bl        { Else update error return }
    @exit:
    end; { asm }
   { Procedure RelUpperMemBlockUMB }


FUNCTION Get2EVector : Word; assembler;
    asm
         mov     ax,352Eh           { Get vector for INT 2Eh }
         int     21h
         mov     ax,es              { Return Segment in ax }
    end; { asm }
  { Function Get2EVector }


FUNCTION GetKey : Char;  assembler;
    asm
    @clrbuff:
         mov     ah,6               { First clear                }
         mov     dl,-1              { keyboard buffer            }
         int     21h
         jnz     @clrbuff           { repeat until buffer empty  }
    @getakey:
         mov     ah,7
         int     21h                { Get one key                }
         or      al,al              { If first byte is 0         }
         jz      @getakey           { get another key            }
                                    { else, return key in al     }
    end; { asm }
    { Function GetKey }


FUNCTION GetDosVersion : Word; assembler;
    asm
         mov     ax,3000h           { Get version function }
         int     21h                { Returns version in ax }
         xor     dh,dh              { Return DosLocus in dh }
         push    ax                 { Save Version }
         cmp     al,5               { If it's NOT DOS 5.0 or greater }
         jb      @exit              { return result }
         mov     ax,3306h           { else DOS 5.0+ }
         int     21h                { returns location of DOS itself }
    @exit:
         pop     ax                 { return DOS version in AX }
         mov     DosLocus,dh        { and set location through dh }
    end; { asm }
    { Function GetDosVersion }

FUNCTION Wrd2Hex(BinNum : Word):  HexStr4; assembler;
{binary word to hex string}
  CONST
  HexChars : ARRAY [0..15] of Char = '0123456789ABCDEF';
    asm
         cld                        { Set forward direction }
         mov     dx,BinNum          { dx will hold incoming parm }
         les     di,@Result         { di points to output }
         lea     si,HexChars        { si points to index of chars }
         mov     cl,4               { cl holds Shift Count }
         mov     al,cl              { Put length (4) in byte 0 }
         xor     bh,bh              { 0 to bh }
         stosb
         mov     bl,dh              { Get high byte in word in bl }
         shr     bl,cl              { and SHR 4 }
         mov     al,[si + bx]       { Put HexChar[bx] into al }
         stosb                      { and add to front of string }
         mov     bl,dh              { Get high byte to bl again }
         and     bl,15              { AND with 15 }
         mov     al,[si + bx]       { then repeat storage to string }
         stosb
         mov     bl,dl              { This time work on low byte }
         shr     bl,cl
         mov     al,[si + bx]
         stosb
         mov     bl,dl
         and     bl,15
         mov     al,[si + bx]
         stosb
    end; {asm}
    { Function Wrd2Hex }

FUNCTION BCDtoStr(BCDNum : Byte):  String2; assembler;
{bcd byte to string}
{ No check for true BCD so be careful }
    asm
         cld                        { Set forward direction }
         mov     dl,BCDNum          { dl will hold incoming parm }
         les     di,@Result         { di points to output }
         mov     al,2               { Put length (2) in byte 0 }
         stosb
         xor     ah,ah              { 0 to bh }
         mov     al,dl              { Get byte in bl }
         mov     cl,4               { move high nibble to low }
         shr     al,cl
         or      al,30h             { and make ASCII }
         stosb                      { and store in string }
         mov     al,dl              { Get byte in dl }
         and     al,0Fh             { kill high nibble }
         or      al,30h             { convert to ASCII }
         stosb                      { and store }
    end; {asm}
    { Function BCDtoStr }

FUNCTION Spaces(b : Byte) : String; assembler;
{Returns a number of spaces as a string}
    asm
         cld
         les     di,@Result         { Point es:di at Return string }
         mov     al,b               { Number of spaces to al }
         stosb                      { Store length in Result[0] }
         xor     ah,ah              { Make a Word }
         mov     cx,ax              { to count # of spaces }
         jcxz    @exit              { if cx = 0 then exit }
         mov     al,32              { put space into al }
    @looper:
         stosb                      { else store spaces }
         loop    @looper            { for cx times }
    @exit:
    end; { asm }

FUNCTION IntToStr(I : LongInt) : String;
  var
    s : String;
  BEGIN
    str(I,s);
    IntToStr := s;
  END;

PROCEDURE InsertFormFeed;
  BEGIN
    Write(#13#12);
    WriteLn;
    Inc(LineNum);
  END;

PROCEDURE NewLine;
  BEGIN
    WriteLn;
    Inc(LineNum)
  END;  { Procedure NewLine }

PROCEDURE Bottomline(str : String80);

  VAR
    Y        : Byte;
    C        : Char;

  BEGIN
    IF isRedirected THEN
    BEGIN
      While LineNum <= Rows DO NewLine;
      InsertFormFeed;
    END
      ELSE
    BEGIN
      Write(#13' - More - ',str);
      C := Getkey;
      Write(#13);
      Write(Spaces(Cols),#13);
    END;
    LineNum := 1;
  END; { Procedure BottomLine }


PROCEDURE GiveHelp;
  CONST
    BlankLine = #13#10;
  BEGIN
    WriteLn;
    WriteLn('SEEMEM by Rick Housh, Version ',PrgVerStr,', ',PrgDateStr);
    WriteLn('Memory Control Block Mapping Program, Displays status of ',
            'Conventional (CNV),');
    WriteLn('Extended (EXT), Expanded (EMM), Upper (UMB), ',
            'High (HMA) and XMS Memory');
    WriteLn('    Usage:  SEEMEM  [/L] [/N] [/?]');
    WriteLn('      /L causes 55 lines/page (e.g. for printing)');
    WriteLn('      /N defeats pausing at each screenful');
    WriteLn('      /C defeats command line character conversion');
    WriteLn('      /? displays this help',BlankLine);
    WriteLn('Redirectable, e.g. SEEMEM /L > PRN');
    WriteLn('Pausing is automatically turned off with redirection');
    WriteLn('/N is provided to force output without pauses, "just in case"');
    WriteLn;
    WriteLn('Command Line:  Where possible SEEMEM shows the 1st ',
            '12 characters of each');
    WriteLn('TSR''s command line.  Normally, in order to avoid ',
            'upsetting ASCII only');
    WriteLn('output devices (e.g. printers), ',
            'control (0..31) characters are converted');
    WriteLn('to the left caret < symbol ',
            'and high order (127..255) ones are converted');
    WriteLn('to the right caret > .  Tabs are converted ',
            'to the vertical bar | symbol.');
    WriteLn('These are illegal in real command lines, so you will ',
            'know their meaning.');
    WriteLn('Command lines over 12 characters long show an ellipsis ... ',
           'at the end.');
    Write('The /C switch defeats all these conversions except the ',
            'ellipsis.');

    IF NOT(inEnhancedWindows) AND NOT(inStandardWindows) THEN Halt(0);
    WriteLn;
    Write('Press any key to return to Windows...');
    ch := GetKey;
    WriteLn;
  END; { Procedure GiveHelp }

PROCEDURE DisplayThisMCB;  { Each Memory Control Block       }
                           { is cooked and displayed by      }
                           { this PROCEDURE, which           }
                           { contains a nested procedure:    }
                           {  WriteProgName                  }
  TYPE
    Tags      = SET OF Byte;

  CONST
    EnvironmentBlock  : TypeBlock = 'Environment';
    SystemBlock       : TypeBlock = 'System     ';
    ShellHook         : TypeBlock = 'Shell Stub ';
    SysShellBlock     : TypeBlock = 'SystemShell';
    SysEnvBlock       : TypeBlock = 'SystemEnvmt';
    SysDataBlock      : TypeBlock = 'System Data';
    MasterEnvBlock    : TypeBlock = 'MasterEnvmt';
    ProgramBlock      : TypeBlock = 'TSR        ';
    CurrentProgBlock  : TypeBlock = 'Current Pgm';
    DeviceBlock       : TypeBlock = 'Device     ';
    DataBlock         : TypeBlock = 'Data       ';
    ConfigBlock       : TypeBlock = 'ConfigSys  ';
    ReserveBlock      : TypeBlock = 'Reserved   ';
    PageFrameBlock    : TypeBlock = 'Page Frame ';
    BiosBlock         : TypeBlock = 'System ROM ';
    FreeBlock         : TypeBlock = 'Available  ';
    UnknownName       : TypeBlock = '[Unknown]  ';
    Max386DataBlock   : TypeBlock = '386Max Data';
    ResourceBlock     : TypeBlock = 'Resource   ';

  VAR
    Ch, Last        : Char;
    LastSegment,
    Bytes           : Longint;
    Envsize,
    LoopCt          : Word;
    isProg          : Boolean;
    EnvmtMCB        : ^MCBStruc;
    PspMCB          : ^PSPStruc;


  PROCEDURE ShowCmdLine(CmdLineStr : String128);
    VAR
      L, X       : Byte;
      Ch         : Char;
    BEGIN
      { If there is a Command Line then display it }
      IF (Seg(PSPMCB^) = (Seg(ThisMcb^)+ 1)) AND (CmdLineStr <> '') THEN
        BEGIN
          { Force a space at start }
          IF NOT (CmdLineStr[1] IN [#32,#9])
            THEN CmdLineStr := ' ' + CmdLineStr;
          L := Length(CmdLineStr);
          { If Command Line longer than 16 set to length of 16 }
          IF L > 13 THEN CmdLineStr[0] := #16;
          IF (L > 0) THEN
            BEGIN
              FOR X := 1 TO L DO
                BEGIN
                  Ch := CmdLineStr[X];
                  IF NOT NoCmdLineFix THEN
                    BEGIN
                      IF Ch = #9 THEN Ch := ' ';            { Tab = Space }
                      IF Ch in [#0..#31] THEN Ch := '<';    { Ctrl Chars  }
                      IF Ch in [#127..#255] THEN CH := '>'; { Hi Order }
                    END;                                 { If NOT all shown }
                  IF X in [14..16] THEN Ch := '.';       { end with 3 dots  }
                  CmdLineStr[X] := Ch;
                END;
                Write(CmdLineStr);
            END;
        END;
    END;

  FUNCTION isTrueMCB(Seg : Word): Boolean;
    VAR                               { Empirical test - Next One ALSO }
      TempBool : Boolean;             { points to valid MCB }
    BEGIN
      TempBool := False;              { Now look ahead two MCB's }
      TempBool :=  (Mem[Seg:0] IN M_or_Z)
        AND (Mem[Seg + Succ(MemW[Seg:3]):0] IN M_or_Z);
                                      { But if either points above possible}
                                      { CANNOT be a true MCB, regardless}
      IF (Seg + Succ(MemW[Seg:3]) >= $FFF0) THEN TempBool := False;
      isTrueMCB := TempBool;
    END; { Nested Function isTrueMCB }

  FUNCTION ProgNameIsUMB(MCB : MCBPointer): Boolean;
    VAR
      TempBool : Boolean;
    BEGIN
      TempBool :=   (MCB^.ProgName[1] = 'U')
                AND (MCB^.ProgName[2] = 'M')
                AND (MCB^.ProgName[3] = 'B')
                AND (MCB^.ProgName[4] = #0);
      IF NOT TempBool
      THEN
      TempBool :=   (MCB^.ProgName[1] = '3')
                AND (MCB^.ProgName[2] = '8')
                AND (MCB^.ProgName[3] = '6')
                AND (MCB^.ProgName[4] = 'M')
                AND (MCB^.ProgName[5] = '3');
      ProgNameIsUMB := TempBool;
    END; { Nested Function ProgNameIsUMB }

  PROCEDURE WriteProgName;
    TYPE
      String128 = String [128];
    VAR
      Ctr             : Byte;
      Ch1             : Char;
      ProgNameStr     : String128;
      OwnersMCB       : MCBPointer;


    BEGIN
      OwnersMCB := Ptr(ThisMCB^.OwnerSeg - 1, 0);
      NextMCB := Ptr(Segment + 1 + ThisMCB^.Size,0);
      Write('    ');
      IF (ThisMCB^.OwnerSeg = $FFFA)
         AND (NextMcb^.OwnerSeg = $FFFE) THEN is386Max := True;
      {If this MCB is owned by the XMS Manager }
      IF ThisMCB^.OwnerSeg = XMM_Control[1] THEN Write(XMSName)
        ELSE
      { Then, IF MCB is NOT an Environment }
      IF (ThisMCB^.OwnerSeg <> EnvmtMCB^.OwnerSeg) THEN
        BEGIN
          IF   (DosMajVer < 4) AND NOT(isNameInMCB)
             THEN Write(UnknownName)      { If NOT environment No name }
                                          { anywhere if DOS < 4.xx     }
          ELSE      { So, if DOS 4 ++  IF MCB Seg > 0 but less than DOS PSP }
            BEGIN   { say DOS owns it }
              IF (ThisMCB^.OwnerSeg <= MasterPSP) AND (ThisMCB^.OwnerSeg > 0)
                  THEN
                    BEGIN
                       IF Pos('SD',ThisMCB^.ProgName) = 1
                          THEN Write('[DEVICE(s)]') ELSE
                       IF (Pos('SC',ThisMCB^.ProgName) = 1)
                             OR
                          (ThisMCB^.OwnerSeg = 7)
                          THEN
                            BEGIN
                              IF (Seg(ThisMCB^) = $9FFF) OR
                                 (Seg(ThisMCB^) = $A000)
                              THEN WRITE('[EGA/VGA VIDEO]')
                              ELSE IF (Seg(ThisMCB^) = $B7FF) OR
                                     (Seg(ThisMCB^) = $B800)
                              THEN WRITE('[CGA VIDEO]')
                              ELSE IF (Seg(ThisMCB^) = $AFFF) OR
                                     (Seg(ThisMCB^) = $B000)
                              THEN WRITE('[MONO VIDEO]')
                              ELSE Write('[SYSTEM]')
                            END
                            ELSE
                       IF (NextMCB^.IDChar = Ord('D')) AND
                            (NextMCB^.OwnerSeg = MasterPSP)
                          THEN WriteAsciiZ(AsciiZPtr(@NextMCB^.Progname),8)
                        ELSE Write(DosName)
                    END
              ELSE
                BEGIN
                  WriteAsciiZ(AsciiZPtr(@ThisMCB^.Progname),8);
                  IF AsciiZerror = 255 THEN
                    WriteAsciiZ(AsciiZPtr(@OwnersMCB^.Progname),8);
                END;
                                              { Still IF DOS = 4 ++ }
          END
        END
      ELSE       { This MCB IS an environment! }
        BEGIN
          IF (DosMajVer < 3) THEN
                                   { DOS version 1.xx or 2.xx }
                                   { So say 'unknown' }
              WriteLn(UnknownName)
                                   { DOS IS 3.X  and IS environment }
          ELSE                     { So get name from Environment }
            BEGIN
              Envsize := EnvmtMCB^.Size SHL 4; {multiply by 16}
              LoopCt := 0;
              Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
              REPEAT
                Last := Ch1;       {pass through environment variables}
                Inc(LoopCt);
                Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
                    { Loop through environment to end }
                    { End of environment block = 0,0 }
              UNTIL (LoopCt > Envsize) OR ((Ch1 = #0) AND (Last = #0));
              Inc(LoopCt);
              Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
              IF (LoopCt >= Envsize) OR (Ch1 <> #1) THEN

                       { IF NO valid name follows environment THEN }
                       { IF DOS = 4 ++ still can get name from MCB }
                BEGIN                      { So, do that }
                  IF (DosMajVer > 3) OR (isDRDOS) OR (isNameInMCB) THEN
                    WriteAsciiZ(AsciiZPtr(@ThisMCB^.ProgName),8)
                END           { Otherwise, IF a valid name IS in the }
              ELSE            { Environment display it for ANY DOS > 2}
                BEGIN
                  ProgNameStr := '';
                            {skip signature 1 (Or # of Strings to follow)}
                  Inc(LoopCt,2);
                  Ch1 := Char(Mem[PspMCB^.Environment: LoopCt]);
                  REPEAT
                    ProgNameStr := ProgNameStr + Ch1;
                    Inc(LoopCt);
                    Ch1 := Char(Mem[PspMCB^.Environment: LoopCt])
                  UNTIL (LoopCt > Envsize) OR (Ch1 = #0);
                  IF Pos(#0,ProgNameStr) <> 0 THEN
                     ProgNameStr[0] := Chr(Pos(#0,ProgNameStr)-1);
                  LoopCt := 1;
                  WHILE LoopCt <> 0 DO
                    BEGIN
                      LoopCt := Pos('\',ProgNameStr);
                      Delete(ProgNameStr,1,LoopCt);
                    END;
                  Write(ProgNameStr);
                END;
            END
        END;
    END;    { Nested Procedure WriteProgName }

  BEGIN  { DisplayThisMCB }
    LastSegment := Segment;
    If isTrueMCB(Segment) THEN LastTrueMCB := Segment;
    IF Upper AND (isWinEnh OR ((Segment = $A000)
      AND  (NOT isTrueMCB(Segment)))) AND (Segment < $B000) THEN
        BEGIN
          Segment := $B000;
          IF isMonoVideo THEN Segment := $B800;
          IF NOT(isMonoVideo) AND (Segment = $B800) THEN
            Segment := $C000;
          IF NOT isTrueMCB(Segment) THEN
            REPEAT
              IF Segment < $C000 THEN Segment := Segment + $100
                ELSE Segment := Segment + $10;
            UNTIL isTrueMCB(Segment) OR (Segment >= $FFF0);
        END;
    ThisMCB := Ptr(Segment,0);
    isNetRoomTSR := False;
    IF Upper            { Test for NetRoom }
        AND ((ThisMCB^.NetRoomID[1] = 'X')
        AND (ThisMCB^.NetRoomID[2] in ['Y','W'])
        AND (ThisMCB^.NetRoomID[3] = #0)) THEN
          BEGIN
            IF NOT(isNetRoom) THEN isNetRoom := True;
            IF ThisMCB^.NetRoomID[1] = 'X' THEN isNetRoomTSR := True;
          END;

    IF (ThisMCB^.IDchar IN M_or_Z) AND isTrueMCB(Succ(Segment))
      THEN
        BEGIN
          Inc(Segment);
          ThisMCB := Ptr(Segment,0);
          IF (Segment > $FFFC) THEN
            BEGIN
              Finished := True;
              Exit;
            END;
        END;

    WHILE (SEGMENT < $FFFF) AND NOT(ThisMCB^.IDchar IN M_or_Z) DO
      BEGIN
        Segment := Segment + StepValue;
        ThisMCB := Ptr(Segment, 0);
      END ;

    IF SEGMENT > $FFFE THEN Finished := True;

    NextMCB  := Ptr(Succ(Segment),0);
    PspMCB   := Ptr(ThisMCB^.OwnerSeg, 0);
    EnvmtMCB := Ptr(PspMCB^.Environment - 1, 0);   {MCB of environment}
    isProg := (ThisMCB^.OwnerSeg > FirstMCB)
      AND ((PspMcb^.StopCode = $20CD) OR (PspMcb^.StopCode = $27CD))
      AND (PspMcb^.Int21 = $21CD);
    IF NOT isProg THEN                    { If Environment does NOT }
      BEGIN                               { Check Out then Point    }
        PspMCB := NIL;                    { Nowhere }
        EnvmtMCB := NIL;
      END;

    IF ((Upper AND Finished AND isNetRoom) AND
          (Mem[Segment + MemW[Segment:3] + 1:0] IN M_or_Z))
         THEN Finished := False;

                                                    {Safety Valve Exit}
    IF Finished OR ((Segment + MemW[Segment:3] +1) > $FFFF) THEN
       BEGIN
         Finished := True;
         Exit; { From Procedure DisplayThisMcb }
       END;

    IF (LineNum > Rows) THEN
      BEGIN
       IF Paging THEN
        BEGIN
          Bottomline('');
          WriteHeader(PageNo);
          LineNum := 4;
        END;
      END;

    Bytes := LongInt(ThisMCB^.Size) SHL 4;           {size of MCB in bytes}

    IF Upper THEN
      BEGIN
         UMBTotal := 16 + UMBTotal + Bytes;
         IF ThisMCB^.OwnerSeg = 0 THEN
           BEGIN
             UMBTotFree := 16 + UMBTotFree + Bytes;
             IF (Bytes > UMBLargest) THEN UMBLargest := 16 + Bytes;
           END;
      END;

    IF MemSegStr = '' THEN MemSegStr := Wrd2Hex(Segment);
    Write(MemSegStr: 5);
    Write(Wrd2Hex(ThisMCB^.OwnerSeg): 9,Bytes: 9);

    IF isProg THEN Write(Wrd2Hex(PSPMCB^.ParentTag ):8) ELSE Write('N/A':8);
    Write('   ');

    IF ThisMCB^.OwnerSeg = 0 THEN
      BEGIN
        Write(FreeBlock,'    ',DosName);
      END
    ELSE
      IF (Segment = PageFrame) or (Segment = Pred(PageFrame))
        THEN Write(PageFrameBlock)
      ELSE
      BEGIN
        IF ((MasterPSP = 0) OR (MasterPSP > ThisMCB^.OwnerSeg))
           AND (ThisMCB^.OwnerSeg > MasterPSP)
             THEN MasterPSP := ThisMCB^.OwnerSeg;
        IF NOT isProg THEN
          BEGIN                                     {Not a process}
             IF (Seg(ThisMCB^) = Pred(XMM_Control[1]))
                OR ((ThisMCB^.OwnerSeg) = XMM_Control[1] )
                    THEN Write(ReserveBlock)
             ELSE
             IF ThisMCB^.OwnerSeg = MasterPSP THEN
               BEGIN
                 IF isDRDOS THEN
                   BEGIN
                       IF (NextMCB^.IDChar = $44)
                       AND (NextMCB^.OwnerSeg = MasterPSP)
                       THEN Write(DeviceBlock)
                         ELSE Write(ConfigBlock);
                   END
                 ELSE
                 IF ((DosMajVer > 3) AND (ThisMCB^.ProgName[1] = 'S')) THEN
                   BEGIN
                    IF (ThisMCB^.ProgName[2] = 'C') THEN Write(ReserveBlock)
                       ELSE
                    IF (ThisMCB^.ProgName[2] = 'D') THEN Write(ConfigBlock)
                   END
                     ELSE Write(SystemBlock);
               END
             ELSE
               IF NOT isDRDOS THEN
                 BEGIN
                   IF (ThisMCB^.OwnerSeg = MemW[_2EVec:$2c]) THEN
                         Write(MasterEnvBlock)
                   ELSE IF (ThisMCB^.OwnerSeg = MemW[ShellPSP:$2c])
                         THEN Write(SysEnvBlock)
                   ELSE IF (ThisMCB^.OwnerSeg < SecondMCB)
                         THEN Write(ReserveBlock)
                   ELSE IF ProgNameIsUMB(ThisMCB)
                         THEN Write(UnknownName)
                   ELSE Write(DeviceBlock);
                 END
               ELSE
                 BEGIN
                   IF (ThisMCB^.OwnerSeg < Pred(MasterPSP)) THEN
                        BEGIN
                          IF isNetRoom AND (Segment AND $100 = $100)
                            THEN Write(FreeBlock,'    ') ELSE
                          Write(ProgramBlock,'    ');
                          WriteAsciiZ(AsciiZPtr(@ThisMCB^.ProgName),8);
                          IF Pos('DR DOS',ThisMCB^.ProgName) <> 0
                            THEN Write(' UMB Loader');
                          Exit;
                        END
                      ELSE IF ((ThisMCB^.OwnerSeg = Pred(MasterPSP))
                           OR (ThisMCB^.OwnerSeg = $FFFF) )
                        THEN Write(ReserveBlock)
                     ELSE  IF isNetRoomTSR THEN
                         Write(ProgramBlock)
                     ELSE IF (ThisMCB^.OwnerSeg = MemW[_2EVec:$2c]) THEN
                         Write(MasterEnvBlock)
                     ELSE IF (ThisMCB^.OwnerSeg = MemW[ShellPSP:$2c])
                         THEN Write(SysEnvBlock)
                     ELSE IF is386Max THEN
                       BEGIN
                          IF (ThisMCB^.OwnerSeg = $FFFD)
                                THEN Write(BiosBlock)
                          ELSE IF (ThisMCB^.OwnerSeg = $FFFA)
                                THEN Write(Max386DataBlock)
                          ELSE IF (ThisMCB^.OwnerSeg = $FFF7)
                                THEN Write(ResourceBlock)
                          ELSE IF ProgNameIsUMB(ThisMCB)
                                THEN Write(UnknownName)
                          ELSE Write(DeviceBlock);
                       END
                     ELSE IF ProgNameIsUMB(ThisMCB)
                           THEN Write(UnknownName)
                     ELSE Write(DeviceBlock);
                 END;
             IF NOT Upper THEN
               BEGIN
                 Write('    <',DosName,DosVerStr);
                 IF isDRDOS THEN Write(' (',DosMajVer,'.',DosMinVer,')')
                   ELSE Write(' kernel');
                 Write('>');
               END
             ELSE IF ThisMCB^.OwnerSeg = FirstMCB THEN
                 Write('    ',DosName)
             ELSE WriteProgName;
        END
      ELSE
        IF (ThisMCB^.OwnerSeg = Succ(Segment)) THEN
          BEGIN
              IF   (ThisMCB^.OwnerSeg = ShellPsp)
                OR (ThisMCB^.OwnerSeg = _2EVec)
              THEN
                BEGIN
                  IF (ThisMCB^.Size < 128) THEN
                    Write(ShellHook) ELSE
                  Write(SysShellBlock);
                  Write('    ',CmdPrgName);
                  IF is4DOS THEN
                    BEGIN
                       Write(' ',lo(_4DosVer):1,'.');
                       IF hi(_4DosVer) < 10 THEN Write('0');
                       Write(hi(_4DosVer));
                     END;
                END
                  ELSE
                BEGIN
                    If ThisMCB^.OwnerSeg = PrefixSeg
                      THEN Write(CurrentProgBlock)
                    ELSE Write(ProgramBlock);
                  WriteProgname;
                END;
          END
        ELSE
          BEGIN
            IF (ThisMCB^.OwnerSeg = ShellPSP) THEN
              BEGIN
                IF Succ(Segment) = MemW[ShellPSP:$2c] THEN
                   Write(SysEnvBlock,'    ')
                     ELSE
                   Write(SysDataBlock,'    ');
                Write(CmdPrgName);
              END
          ELSE
            BEGIN
              IF (ThisMCB^.OwnerSeg = EnvmtMCB^.OwnerSeg)
                THEN
                  BEGIN
                    IF is386Max AND (ThisMCB^.Size = 6)
                      THEN Write(Max386DataBlock)
                    ELSE Write(EnvironmentBlock);
                  END
                     ELSE Write(UnknownName);
              WriteProgName;
            END;
          END;

      END;
            {NetRoom requires the following Fixup for BIOS ROM }
            {blocks converted to Upper Memory.  Looks through  }
            {ROM Bios in 4k blocks until up to FFF0 (end)      }
      If isNetRoom AND Upper and Finished THEN
        BEGIN
          IF (Segment < $F000) THEN SEGMENT := $F000;
          Repeat
             Segment := Segment + $100;
             IF    (Mem[Segment:0] IN M_or_Z)
               AND (Mem[Succ(Segment):0] IN M_or_Z)
                 THEN Inc(Segment);
             ThisMCB := Ptr(Segment,0);
             NextMCB := Ptr(Succ(Segment),0);
          Until (ThisMCB^.IDchar IN M_or_Z)  OR  (Segment >= $FFF0);
          IF Segment < $FFF0 THEN Finished := False;
        END;

    IF (Succ(Segment) <> PSPMcb^.Environment)
       THEN ShowCmdLine(PSPMcb^.CmdString);
  END; { Procedure DisplayThisMCB }

PROCEDURE DisplayEMSinfo;

  TYPE
    EMShandlerecord =
      RECORD
        Handlenumber: Word;
        Numberofpages: Word;
      END;

    EMSHardware =
      RECORD
        PhysicalPageSize     : Word;
        AlternateMappingRegs : Word;
        MappingContextSize   : Word;
        DMARegSets           : Word;
        DMABehavior          : Word
      END;

  VAR
     EMMversion,
     HandleIndex,
     Index, EMSErr       : Byte;
     FreePages,
     EMSmaxhandles,
     EMSsize, EMSleft    : Word;
     NonVolatile         : Boolean;
     Hardware            : EMSHardware;
     EmsHandles          : ARRAY [1..256] OF EMShandlerecord;
     EmsHandleName       : ARRAY [1..8] OF Char;

  PROCEDURE ErrorMessage(ErrNum : Word; FuncNum : String3);
    BEGIN
      NewLine;
      Write(' EMS error ',ErrNum,' in function ',FuncNum,' -');
      IF ErrNum IN [$80,$81]  THEN
        BEGIN
          Inc(LineNum);
          CASE ErrNum of
            $80 : Write(' Software error -');
            $81 : Write(' Hardware malfunction -');
          END; { Case }
        END;
      Write(' EMS info NOT available');
      NewLine;
    END; { Nested Procedure ErrorMessage }

  BEGIN { DisplayEMSinfo }
      IF NOT Paging AND NOT(isRedirected) THEN NewLine;
      IF Paging AND isRedirected THEN
        BEGIN
          InsertFormFeed;
          LineNum := 1;
        END;
      FOR ByteCtr := 0 TO 255 DO   { Init Array of Records }
        BEGIN
          EmsHandles[ByteCtr].Handlenumber := 0;
          EmsHandles[ByteCtr].Numberofpages := 0;
        END;

      WITH Hardware DO                 { Init Hardware Record }
        BEGIN
          PhysicalPageSize     := 1024;
          AlternateMappingRegs := 0;
          MappingContextSize   := 0;
          DMARegSets           := 0;
          DMABehavior          := 0
        END;

      EMSsize := 0;                 { Set Defaults for EMS stuff }
      EMSleft := 0;
      EMMversion := 0;
      EMSmaxhandles := 255;
      asm
         mov     ah,46h             { Get EMM version ( v. 3.0 call) }
         int     67h
         mov     EMSErr,ah          { Save Result in ah }
         or      ah,ah              { <> 0 means error }
         jnz     @exit              { So exit }
         mov     EMMversion,al      { Else version is in al }
      @exit:
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'46h');
           Exit;
         END;

      asm
         mov     ah,42h             { Get total & avail pages }
         int     67h
         mov     EMSErr,ah          { Store Error }
         or      ah,ah              { Check for Error }
         jnz     @exit              { If IS error, exit }
         mov     EMSleft,bx         { Else store free pages }
         mov     EMSsize,dx         { And total pages }
      @exit:
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'42h');
           Exit;
         END;
      IF EMMversion > $3F THEN      { EMS v. 4 ++ calls }
      BEGIN
        NonVolatile := False;       { Default to volatile only }
        asm
           mov     ah,52h           { Get non-volatility support }
           mov     al,2             { Subfunction 2 }
           int     67h
           mov     EMSErr,ah        { Save error }
           or      ah,ah            { Check error }
           jz      @exit            { Exit if No Error }
           mov     NonVolatile,al   { Else move to boolean }
        @exit:
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'52h');
             Exit;
           END;
        asm
           push    ss               { Hardware rec is local, on stack }
           pop     es               { So, point es to stack }
           lea     di,Hardware      { Point di to offset Hardware record }
           mov     ax,5900h         { Put info in Hardware record }
           int     67h
           mov     EMSErr,ah        { and store error }
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'59h');
             Exit;
           END;
        asm
           mov     ax,5901h         { Get unallocated raw page count }
           int     67h
           mov     EMSErr,ah        { Store error }
           or      ah,ah            { Check for error }
           jnz     @exit            { If error, exit, else }
           mov     EMSsize,dx       { Store Total Raw Pages }
           mov     EMSleft,bx       { Store Free Raw Pages }
        @exit:
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'59h');
             Exit;
           END;
        asm
           mov      ax,5402h        { Get Handle Count }
           int      67h
           mov      EMSErr,ah       { Store error }
           or       ah,ah           { Check for error }
           jnz      @exit           { If IS error, exit, else }
           mov      EMSmaxhandles,bx { store handle count }
        @exit:
        end; { asm }
        IF (EMSErr <> 0) THEN
          BEGIN
             ErrorMessage(EMSErr,'59h');
             Exit;
           END;
      END;
      IF EMMversion > $41 THEN Write('     ');
      Write('EMS Ver. ', EMMversion SHR 4, '.', EMMversion AND 15);
      Write(' - Page Frame Seg ', Wrd2Hex(PageFrame): 4,' - EMS Size ',
            LongInt(EMSsize * (Hardware.PhysicalPageSize DIV 64)):4, 'k');
      IF EMMversion < $41 THEN
        BEGIN
           Write(  ' - Max Handles ',EMSmaxhandles: 3);
           IF Paging THEN Write(' - Page ',PageNo);
           NewLine;
         END
      ELSE
        BEGIN
          IF Paging then Write(' - Page ',PageNo);
          NewLine;
          WriteLn('       Nonvolatile Handles (Warm Boot Survival) ',
                'supported: ',NoOrYes[NonVolatile]);

          WriteLn('   Mapping Register Sets = ',
                  Hardware.AlternateMappingRegs:2,
                ' : DMA Channels = ',Hardware.DMARegSets:2,
                ' : Maximum Handles = ',EMSmaxhandles:3);
          Inc(LineNum,2);
        END;
      Inc(PageNo);
      asm
         push    ss                 { EmsHandles is on Stack }
         pop     es                 { So point es to Stack }
         lea     di,EmsHandles      { di gets offset of EmsHandles }
         mov     ah,4Dh             { Get Pages - All Handles }
         int     67h                { es:si (EmsHandles) is filled }
         mov     EMSErr,ah          { Store error }
         or      ah,ah              { If NO error }
         jz      @exit              { exit, else }
         xor     bl,bl              { Set count to 0 }
      @exit:
        mov  HandleCount,bl
      end; { asm }
      IF (EMSErr <> 0) THEN
        BEGIN
           ErrorMessage(EMSErr,'4Dh');
           Exit;
        END;

      FreePages := EMSmaxhandles - HandleCount;
      NewLine;
      Write('         Handle   Pages  Page Size-<<KB>>-',
            'Memory       Name');
      NewLine;
      FOR HandleIndex := 1 TO HandleCount DO
        BEGIN
          Write(Spaces(8), EmsHandles[HandleIndex].Handlenumber: 4,
                Spaces(6), EmsHandles[HandleIndex].Numberofpages: 4,
                Spaces(5), Hardware.PhysicalPageSize DIV 64:4,
                Spaces(8), Longint(EmsHandles[HandleIndex].
                Numberofpages * (Hardware.PhysicalPageSize DIV 64)): 8,
                '   -   ');

          IF EMMversion < $40 THEN  { EMS versions below 4.0 }
            Write('[NoName]')  ELSE
            BEGIN                   { Version 4.0 or above }
              asm
                 push    ss                    { Address ss as es }
                 pop     es                    { es:di points to record }
                 lea     di,EmsHandles         { Point to start of array }
                 xor     ax,ax                 { Clear ax }
                 mov     al,HandleIndex        { Index of handle in array }
                 dec     al                    { This is zero base }
                 shl     ax,1                  { Times 4 }
                 shl     ax,1                  { 4 Bytes for each index }
                 add     di,ax                 { Point di to next record }
                 mov     ax,es:[di]            { Get handle Number }
                 mov     dx,ax                 { into dx }
                 lea     di,EmsHandleName      { Offset of String }
                 mov     ax,5300h              { Get handle name to es:di}
                 int     67h
                 mov     EMSErr,ah             { Save any error }
              end; { asm }
              IF (EMSErr = $81) THEN
                   Write('[Error-Handle NOT Found] ')
                ELSE
                  IF (EMSErr <> 0) THEN
                  Write('[EMS Error ',Wrd2Hex(Word(EMSErr)),'h]')
                ELSE
                  IF (EmsHandles[HandleIndex].Handlenumber = 0) THEN
                  Write('[System]')
                ELSE
                  BEGIN
                    IF EmsHandleName[1] = #0 THEN Write('[No Name]')
                      ELSE WriteAsciiZ(AsciiZPtr(@EmsHandleName),8);
                  END;
            END;                             { End of EMS 4 + name stuff }
            NewLine;
            IF (LineNum > Rows) AND Paging THEN BottomLine('');
        END;

      Write('         ');
      FOR ByteCtr := 1 TO 40 DO Write('-');
      NewLine;
      IF EMMversion > $3F THEN Inc(FreePages);
      WriteLn('   Free ', FreePages: 4,Spaces(6), EMSleft: 4,
              Spaces(17),EMSleft * (Hardware.PhysicalPageSize DIV 64): 8);
      Inc(LineNum);
  END; { Procedure DisplayEMSinfo }


PROCEDURE DisplayUMBinfo;
  BEGIN
    Write('       UMB = Implemented          -      ',
       NoOrYes[isUMB]);
    NewLine;
    IF isUMB THEN
      BEGIN
        Write('       UMB = Int 2Fh Functions    -      ',
          NoOrYes[isUMBdriver]);
        NewLine;
        Write('       UMB = Int 21h Functions    -      ',
          NoOrYes[isUMBDOS]);
        NewLine;
      END;
  END;


PROCEDURE DisplayXMSinfo;
  BEGIN
    IF NOT Paging AND NOT(isRedirected) THEN NewLine;
    Write('   XMS Ver. ');
    Write(BCDtoStr(Hi(XMSversion)), '.', BCDtoStr(Lo(XMSversion)));
    Write(' - Rev. ');
    Write(BCDtoStr(Hi(XMSrevision)), '.', BCDtoStr(Lo(XMSrevision)));
    Write(' - XMM Control Vector ');
    Write(Wrd2Hex(Xmm_control[1]), ':', Wrd2Hex(Xmm_control[0]));
    If Paging THEN Write(' - Page ',PageNo);
    Inc(PageNo);
    NewLine;
    QueryFreeMemXMS;
    IF XMSerror in [$80,$8E,$8F] THEN
      BEGIN
        XMSresult := 0;
        XMSlargest := 0;
        Inc(Linenum);
      END;
    XMSavail := XMSresult;
    IF XMSerror in [$A0,$A1] THEN Inc(LineNum);
    CASE XMSerror of
       $80:  WriteLn('   XMS Memory NOT Implemented');
       $8E:  WriteLn(#7'   General XMS driver error');
       $8F:  WriteLn(#7'   Unrecoverable XMS driver error');
       $A0:  BEGIN
               Write('   All XMS Memory is allocated');
               IF isWinEnh THEN Write(' by Windows 386/Enh')
                 ELSE
               IF isWinStd THEN Write(' by Windows Std/Real');
               WriteLn;
             END;
       $A1:  WriteLn('   All XMS Handles are already allocated');
      END; {Case}
    NewLine;
    IF XMSerror <> $80 THEN
      BEGIN
        Write('       A20 = Line Enabled         -      ');
        QueryA20;
        IF XMSerror > $7F THEN WriteLn(#7'Error ',XMSerror)
          ELSE WriteLn(NoOrYes[XMSresult <> 0]);
        Inc(LineNum);
      END;
    Write('       HMA = Implemented          -      ',
              NoOrYes[isHMA]);
    NewLine;
    Write('       HMA = Memory Available     -      ');
    IF IsHMA THEN
      BEGIN
        GetMemHMA($FFFF);
        Write(NoOrYes[XMSResult = 1]);
        IF XMSResult = 1 THEN
          BEGIN
            ReleaseMemHMA;
            IF XMSresult = 0 THEN
              BEGIN
                Write(' Cannot Release HMA ');
                NewLine;
              END;
          END
        ELSE IF XMSerror = $81 THEN
          Write(' - Error VDISK Detected - ')
        ELSE IF XMSerror <> $91 THEN  Write(#7'  Unknown XMS Error');
      END;
    NewLine;
    DisplayUMBinfo;
    Write('       DOS = HIGH                 -      ',
          NoOrYes[DosLocus=16]);
    NewLine;
    NewLine;
  END; { Procedure Display XMSinfo }


PROCEDURE GetParms;  assembler;
{ Special for SeeMem }
    asm
         push    ds                 { Save Data Segment }
         cld                        { Set direction forward }
         mov     Paging,1           { Default Paging to True }
         mov     LongPage,0         { And Long Pages to False }
         mov     NoCmdLineFix,0     { And DO convert cmd line chars }
         mov     ax,PrefixSeg       { Set }
         mov     ds,ax              { Point Data Segment PSP }
         mov     es,ax              { also Extra Segment }
         mov     di,80h             { di and si point to }
         mov     si,di              { Command Line length byte }
         lodsb                      { move length to al }
         xor     ah,ah              { and convert to word }
         stosb                      { just to advance pointer }
         xchg    cx,ax              { cx gets length }
         jcxz    @exit              { if 0 then exit }
    @uploop1:
         lodsb                      { Else get next byte }
         cmp     al,'a'             { and upcase it }
         jb      @uploop2
         cmp     al,'z'
         ja      @uploop2
         sub     al,32
    @uploop2:                       { until }
         stosb                      { at end of cmd line length }
         loop    @uploop1
         xor     ax,ax              { Zero ax }
         mov     si,80h             { Start over with }
         lodsb                      { cmd line length }
         xchg    cx,ax              { into cx }
    @cloop1:                        { and continuing }
         lodsw                      { by reading word }
         dec     si                 { Back up one byte }
         xchg    ah,al              { reverse order }
         cmp     ax,'/H'            { Is it Help? }
         jz      @help              { Then give it }
         cmp     ax,'/?'            { Other help cmd? }
         jz      @help              { Then give it }
         cmp     ax,'/C'            { CmdLine Char Conversion }
         jz      @next3
         cmp     ax,'/L'            { Long Page }
         jz      @next2
         cmp     ax,'/N'            { "/N"O paging? }
         jz      @next1             { Then set boolean }
         loop    @cloop1            { else get another }
         jmp     @exit              { Until through }
    @help:
         pop     ds                 { Restore Data Segment }
         jmp     GiveHelp           { Terminate with help }
    @next1:
         pop     ds                 { Restore Data Segment }
         mov     Paging,0           { Set Paging False }
         push    ds                 { Save Data Segment }
         jmp     @cloop1
    @next2:
         pop     ds
         mov     LongPage,1         { Set Long Page True }
         push    ds
         jmp     @cloop1
    @next3:
         pop     ds
         mov     NoCmdLineFix,1     { Set No CmdLine Char Convert }
         push    ds
         jmp     @cloop1
    @exit:
         pop     ds                 { Exit, Restoring Data Segment }
    end; { end }

PROCEDURE ChkFor4Dos; assembler;
  asm
         xor     bx,bx
         mov     is4DOS,bl
         mov     _4DosLevel,bl
         mov     _4DosVer,bx
         mov     _4DosPSP,bx
         mov     ax,0D44Dh
         mov     bx,0
         int     2fh
         cmp     ax,44DDh
         jnz     @exit
         mov     is4DOS,1
         mov     _4DosVer,bx
         mov     _4DosPSP,cx
         mov     _4DosLevel,dl
  @exit:
  end; { asm }

PROCEDURE Initialize;
  VAR
    TmpStr : String[5];
    Ctr    : Byte;
  BEGIN
    StepValue       := 1024;
    XMM_Control[0]  := 0;
    XMM_Control[1]  := 0;
    XMSResult       := 1;
    XMSError        := 0;
    PageNo          := 1;
    isXMS           := ExistXMS;
    isUMBdriver     := ExistUMBdriver;
    isUMB           := ExistUMBmem;
    isWinStd        := inStandardWindows;
    isWinEnh        := inEnhancedWindows;
    GetXMSversionAndHMAStatus;
    isEMS           := ExistEMS;
    IF isEMS THEN PageFrame := GetEMSPageFrame ELSE PageFrame := 0;
    TempSeg         := 0;
    MasterPSP       := 0;
    Upper           := False;
    isAT            := False;
    isDRDOS         := False;
    is4DOS          := False;
    isNameInMCB     := False;
    is386Max        := False;
    isNetRoom       := False;
    isNetRoomTSR    := False;
    FirstMCB        := 0;
    SecondMCB       := 0;
    LastTrueMCB     := 0;
    nonXMSExtendMem := 0;
    maxXMSmem       := 0;
    XMSavail        := 0;
    XMSFreeHandles  := 0;
    TotalExtMem     := 0;
    UMBTotFree      := 0;
    UMBTotal        := -16;
    UMBLargest      := 0;
    isMonoVideo     := MemW[$0040:$0063] = $3B4;
    Cols            := MemW[$0040: $004A];
    Rows            := Mem[$0040:$0084];
    IF NOT(Rows in [24..50]) THEN
          Rows := Pred(Trunc(MemW[$0040:$004C] div (Cols * 2)));
    IF NOT(Rows in [24..59]) THEN Rows := 24;
    TopCnvMem       := MemW[PrefixSeg:2]; { Last conventional in PSP:0002 }
    ShellPSP        := Get2Evector;       { INT 2Eh in command.com }
    _2EVec          := ShellPSP;
    DosMajVer       := Lo(GetDosVersion); {major version number, e.g., 3.X}
    DosMinVer     := Hi(GetDosVersion); {minor ver. no., e.g. x.30 }
    DosVerStr := IntToStr(DosMajVer) + '.' + IntToStr(DosMinVer);
    For Ctr := 1 to Length(DosVerStr) DO IF DosVerStr[Ctr] = ' '
      THEN  DosVerStr[Ctr] := '0';
    ThisPrgName := '';
    Ctr := 7;
    REPEAT
       Inc(Ctr);
       Ch := Chr(Mem[PrefixSeg-1:Ctr]);
       IF (Ch <> #0) AND (Ch <> #32) THEN ThisPrgName := ThisPrgName + Ch;
    UNTIL (Ctr = 15) OR (Ch = #0);
    ThisPrgName := '\' + ThisPrgName + '.EXE';
    IF Pos(ThisPrgName,ParamStr(0)) > 0 THEN isNameInMCB := True;
    ChkFor4Dos;
    IF is4DOS THEN
      BEGIN
        ShellPSP := _4DosPSP;
        CmdPrgName := '[4DOS]';
        CmdStr := GetEnv('COMSPEC');
        FOR Ctr := 1 to Length(CmdStr) DO CmdStr[Ctr] := UpCase(CmdStr[Ctr]);
        IF (Pos('NDOS',CmdStr) <> 0) THEN CmdPrgName := '[NDOS]   ';
      END;

    IF (NOT is4DOS) AND (DosMajVer > 4) THEN
      BEGIN
        asm
             push    ds
             mov     ax,5500h
             int     2Fh
             jc      @exit
             mov     ax,ds
             pop     ds
             push    ds
             mov     ShellPSP,ax
        @exit:
             pop     ds
        end; { asm }
      END;

    { If ExistUMBmem does not report any UMBs, may still be some }
    { which DOS can use, but with no device driver function   }
    { Only possible with DOS 5 ++ So use DOS 5 ++ function to }
    { Attempt to change DOS UMB link state - only possible if }
    { DOS owns some UMB's, so...                                }

    isUMBDOS := DOSequalUMB;
    IF NOT isUMB THEN isUMB := isUMBDOS;

    IF NOT isUMB THEN isUMB := isUMBdriver;
                                       { If DOS has it they're there, }
                                       { even with no device driver }
    isDRDOS := GetEnv('OS') = 'DRDOS';  { Environment holds DR-DOS }
    IF isDRDOS THEN                     { Indicators }
      BEGIN
        OSName := 'DR-DOS';
        DosName := '[DR-DOS] ';
        DosVerStr := GetEnv('VER');
      END;

    asm                             { DOS function returns a pointer}
         mov     ah,52h             { to the DOS 'list of lists' }
         int     21h                { in es:bx - DOS's first MCB }
         mov     TableSeg,es        { List's Segment in es, Save it }
         mov     TableOfs,bx        { Save offset }
    end; { asm }

    FirstMCB  := MemW[TableSeg:TableOfs - 2];

    TmpLongInt := TableSeg;
                              { What is DOS = High? If DOS 3 or 4 }
                              { we'll decide based on location of }
                              { current disk buffer in HMA or not }
                              { DOS 2 has no DOS=HIGH; DOS 5 can tell us }
                              { directly, and did, from GetDosVersion}

    TmpLongInt := MemW[TableSeg:TableOfs - 6];
    IF DosMajVer = 2 THEN TmpLongInt := MemW[TableSeg:TableOfs + $15];
    IF  (DosMajVer in [3..4])
         AND  (DosLocus < 16) THEN   { Get segment of current disk buffer}
      BEGIN
        IF (NOT isDRDOS) THEN TmpLongInt := MemW[TableSeg:TableOfs - 6]
          ELSE
        TmpLongInt := MemW[TableSeg:TableOfs + $14];
      END;
    IF (DosMajVer < 5) AND (DosLocus = 16) THEN TmpLongInt := $FFFF;

    IF TmpLongInt > $FFFF THEN DosLoadSeg := $FFFF
      ELSE DosLoadSeg := TmpLongInt;
    IF DosLoadSeg = $FFFF THEN DosLocus := 16;

    asm
         mov     ax,0C000h          { Test for > PC XT }
         push    es                 { save used registers }
         push    bx
         push    bp
         int     15h                { call rom function }
         pop     bp                 { restore registers }
         pop     bx
         pop     es
         jc      @exit              { if carry XT or lower }
         mov     isAT,1             { else is an AT or later }
         mov     ax,8800h           { so get regular extended size in k's}
         int     15h                { using rom }
         jc      @exit              { if error, exit }
         mov     nonXMSExtendMem,ax { else save extended size }
    @exit:
    end; { asm }

    IF isAT THEN
      BEGIN
        IF DosMajVer > 3 THEN TotalExtMem := MemW[TableSeg:TableOfs + $45]
                                                  {Total extended memory }
                                                  {at es:bx + 45h in DOS }
                                                  {ver 4 and higher }
        ELSE
          BEGIN                                 { If Dos version < 4 }
            Port[$70] := $18;                   { then must get from ROM }
            TotalExtMem := Port[$71] shl 8;
            Port[$70] := $17;
            TotalExtMem := TotalExtMem + Port[$71];
          END;
        MaxXMSmem := TotalExtMem - nonXMSextendMem;
      END; { If isAT }
    MasterPSP := MemW[FirstMCB:0001];  { PSP of 1st MCB points to 8 }
    Segment := FirstMCB;               { Start here }
  END; { Procedure Initialize }

Function GetConMode(Hndl : Word) : Byte; assembler;
    asm
         mov     bx,Hndl            { Handle for StdOut   }
         mov     ax,4400h           { IOCTL func GetDevInfo }
         int     21h
         jc      @exit              { Carry on error }
         xor     ax,ax              { zero ax }
         mov     al,dl              { Save Mode }
    @exit:
    end; { end }
    { Procedure GetConMode }

PROCEDURE SetRawMode(Hdl : Byte;OnOff : Boolean); assembler;
    asm
         mov     bl,Hdl             { Assign File Handle }
         xor     bh,bh              { Make it a byte }
         cmp     bl,1               { If NOT StdOut }
         jnz     @setit             { Just Set It }
         mov     dl,IOCTLmode       { Else, Get old stdout cooked state }
         cmp     OnOff,0            { Get Incoming OnOff request }
         jz      @setit             { No?  Then restore old state }
         or      dl,20h             { Else, set raw mode - bit 5 }
    @setit:
         xor     dh,dh              { dh must be 0 }
         mov     ax,4401h           { with IOCTL func 1 }
         int     21h                { Set device info }
    end; { asm }
    { Procedure SetRawMode }


BEGIN {SeeMem}
  GetParms;
  Initialize;
  OutputRec := @Output;                { By setting record pointer to file }
  IOCTLmode := GetConMode(OutPutRec^.Handle);   { Get IOCTL mode of StdOut }
  IF (IOCTLmode AND 130) = 130 THEN isRedirected := False
    ELSE isRedirected := True;
  IF LongPage THEN Rows := 55;
  SetRawMode(OutputRec^.Handle,True); { Set it to Raw }
  WriteHeader(PageNo);
  LineNum := 4;
  WriteLn('  N/A     0000     1024     N/A   ',
          'Vector Table   INTERRUPTS');
  WriteLn('  N/A     0040      256     N/A   ',
          'System Data    ROM BIOS');
  WriteLn('  N/A     0050      512     N/A   ',
          'System Data    ',OSName);
  WriteLn('  N/A',Wrd2Hex($70):9,
         ((FirstMCB - $70) * 16):9,'N/A':8,
         '   Code/Data      ',OSName,'/Devices-Tables');
  LineNum := LineNum + 4;
  MemSegStr := '';
  REPEAT
    TempSeg := Segment;
    DisplayThisMCB;                         { Show each MCB in turn }
    NewLine;
    MemSegStr := '';
    Segment := Segment + ThisMCB^.Size + 1; { Next MCB is length + 1 }
    IF (SecondMCB = 0) AND (Segment > FirstMCB) THEN SecondMCB := Segment;
  UNTIL (ThisMCB^.IDchar = $5A) OR (Segment >= TopCnvMem);
          {last one is 'Z'}

  Segment  := TopCnvMem;

  MemSegStr := Wrd2Hex(Pred(Segment));
  Lowermax := 1 + Segment - Succ(TempSeg);
  Lowermax := Lowermax SHL 4;

  { END OF CONVENTIONAL MEMORY }
  Write(' ',MemSegStr);
  WriteLn('   =======Last Conventional (CNV) Memory Segment=======');
  Inc(LineNum);

  IF isUMB THEN Upper := True;

  IF Segment MOD 16 = 0 THEN MemSegStr := '' ELSE
      MemSegStr := Wrd2Hex(Succ(Segment));

  IF isUMB AND (NOT (Mem[TopCnvMem:0] IN M_or_Z))
       AND (Mem[Pred(TopCnvMem):0] IN M_or_Z) THEN
    BEGIN
      Segment := Pred(TopCnvMem);
      MemSegStr := Wrd2Hex(TopCnvMem);
      IF MemW[Segment:3] > 0 THEN
        BEGIN
          DisplayThisMCB;
          NewLine;
        END;
      Segment := TopCnvMem;
      Segment := Segment + MemW[Pred(Segment): 003];
      MemSegStr := '';
    END;

  IF IsUMB THEN
                                     { Work Upper Memory Blocks}
       WHILE  NOT(Finished) AND (Segment < $FFF0)
        AND (Segment >= TopCnvMem) DO
          BEGIN
            Finished := False;
            DisplayThisMCB;                    {Look at each MCB}
            NewLine;
            MemSegStr := '';
            Segment := Segment + ThisMCB^.Size + 1;
          END;

  IF (LineNum <= Rows) THEN NewLine;
  IF Paging AND NOT(isRedirected) THEN
    BEGIN
      PreviewStr := 'Conventional';
      IF isUMB THEN PreviewStr := PreviewStr + ' & UMB';
      PreviewStr := PreviewStr + ' Summary';
      IF IsXMS THEN PreviewStr := 'XMS Extended Memory - '+ PreviewStr;
      IF (LineNum > 1) THEN
        BEGIN
          WHILE (LineNum <= Rows) DO NewLine;
          IF isEMS THEN BottomLine('Expanded Memory - ' + PreviewStr)
            ELSE
          Bottomline(PreviewStr);
        END;
    END;

  IF IsEMS THEN
  BEGIN
    DisplayEMSinfo;
    IF Paging AND NOT(isRedirected) THEN
      BEGIN
        WHILE (LineNum <= Rows) DO NewLine;
        BottomLine(PreviewStr);
      END;
  END;

  IF NOT(isRedirected) AND Paging AND (LineNum > 1) THEN
    BEGIN
      WHILE (LineNum <= Rows) DO NewLine;
      BottomLine(PreviewStr);
    END;
  IF isRedirected THEN BottomLine('');

  IF IsXMS THEN DisplayXMSinfo ELSE
    BEGIN
      NewLine;
      Write('           CNV  -  UMB  Memory Summary Information');
      NewLine;
      NewLine;
      DisplayUMBinfo;
      NewLine;

    END;
  Write('       DOS List of Lists Location        ');
  IF TableSeg > $FFFE THEN Write('HMA')
    ELSE IF TableSeg > $EFFF THEN Write('ROM')
    ELSE IF TableSeg > TopCnvMem THEN Write('UMB')
    ELSE Write('CNV');
  Write(' - ',Wrd2Hex(TableSeg));
  NewLine;
  Write('       SHELL Location                    ');

  IF (_2EVec > ShellPSP) THEN ShellPSP := _2EVec;
  IF ShellPSP > $FFFE THEN Write('HMA')
    ELSE IF ShellPSP > $EFFF THEN Write('ROM')
    ELSE IF ShellPSP > TopCnvMem THEN Write('UMB')
    ELSE Write('CNV');
  Write(' - ',Wrd2Hex(ShellPSP));
  Write(' - ',CmdPrgName);
  NewLine;
  Write('       DOS Location  (Disk Buffers)      ');
  IF (DosMajVer > 1) OR (DosLocus > 0) THEN
    BEGIN
      IF (DosLoadSeg > TopCnvMem) AND (DosLoadSeg < $FFFF)
                     THEN  Write('UMB - ',Wrd2Hex(DosLOadSeg),' - ')
        ELSE
      IF DosLocus = 8 THEN Write('ROM')
        ELSE
      IF DosLocus = 16 THEN Write('HMA - ',Wrd2Hex(DosLoadSeg),' - ')
        ELSE Write('CNV - ',Wrd2Hex(DosLoadSeg),' - ');
      Write(DosName,' [',DosVerStr,']');
      NewLine;
      IF (DosMajVer > 4) AND (DosLocus = 16) AND (NOT isDRDOS) THEN
        BEGIN
          Write('       DOS HMA Usage               ');
          HMAUsed := $FFFF;         { Set impossible space in HMA }
          asm
            mov  ax,4A01h           { Get HMA Free Space }
            int  2Fh                { With multiplex interrupt }
            jc   @exit              { Exit if error }
            mov  HMAUsed,di         { else di points to offset of free HMA}
          @exit:
          end; { asm }
          IF HMAUsed = $FFFF THEN Write('Error in INT 2F, AX=4A01h')
            ELSE Write(HMAUsed:5,' bytes');
          NewLine;
        END;
    END
  ELSE
    BEGIN
      Write('CNV');
      NewLine;
    END;

  NewLine;

  IF isAT THEN
    BEGIN
      TotalExtMem := TotalExtMem - MaxXMSMem;

      IF isXMS THEN
        BEGIN
          Write('   XMS Free Memory Handles                ',
                 XMSFreeHandles:6);
          NewLine;
          Write('   XMS Memory  (Total-Used-Avail-Largest) ',
                MaxXMSMem:6,'k - ',
                (MaxXMSMem-XMSavail):6,'k - ',XMSavail:6,'k - ',
                XMSlargest:6,'k');
          NewLine;
        END;
    END;

  IF isUMB THEN
    BEGIN
      Write('   UMB Memory  (Total-Used-Avail-Largest) ',
               UMBTotal:6,'  - ',
               (UMBTotal - UMBTotFree):6,'  - ',
               UMBTotFree:6, '  - ',
               UMBLargest:6);
      NewLine;
      Write('   Std Extended Memory (Total-Used-Avail) ',
               TotalExtMem:6,'k - ',
               TotalExtMem-nonXMSExtendMem:6,'k - ',
               nonXMSExtendMem:6, 'k');
      NewLine;
    END;
  NewLine;
  WriteLn('   Available Conventional (CNV) Memory ',
    Lowermax - 16: 7, ' bytes');
  Inc(LineNum);
  OurEnvSize := (MemW[(MemW[Prefixseg: $2C]) - 1: 3]) SHL 4;
  WriteLn('           + Current Environment       ',
    OurEnvSize: 7, ' bytes');
  Inc(LineNum);
  Write(Spaces(27),'Total       ',
    (Lowermax + OurEnvSize):7, ' bytes  (',
     (Lowermax + OurEnvSize) DIV 1024,'.',
     ((Lowermax + OurEnvSize) MOD 1024) DIV 100,'k)');
  IF NOT(isEMS) OR NOT(isXMS) THEN NewLine;
  IF NOT isEMS THEN
    BEGIN
      Write('  NO EMS driver found');
      IF NOT IsXMS THEN NewLine;
    END;
  IF  NOT IsXMS THEN
    BEGIN
      Write('  NO XMS driver found');
    END;
  IF Paging AND NOT(isRedirected) THEN
    BEGIN
       WHILE (LineNum < Pred(Rows)) DO NewLine;
       NewLine;
       Write(' - Press any key to return to Operating System -');
       Ch := GetKey;
       Write(#13'                                                '#13);
    END;
    Write(#13);
    IF isRedirected THEN Write(#12);
    SetRawMode(OutputRec^.Handle,False);
END. { Program SeeMem }
