\ LEAVE Program, Copyright (C) 1987 by Dave Angel  All Rights Reserved
\     Dave Angel   Compuserve 71046,1567
\
\  Written in CFORTH 1.10
\      (from Laboratory Microsystems, PO 10430  Marina Del Rey, CA 90295)
\      (  Order hotline  213-306-7412)
\
\  Version 1.0  Released  7/6/87
\  Version 1.0a  modified  7/10/87
\      to fix bug:  The second and subsequent runs didn't work properly
\      if LEAVE was the last TSR to be loaded.
\  This program is dedicated to Barbara Wagreich,
\     who cannot see the Capslock or Numlock LED's.
\
\  The purpose of the program is to temporarily disable the use of
\    the capslock and/or the numlock keys on an IBMPC, PC/AT or equivalent
\    keyboard.  This is particularly important for a blind person who
\    cannot readily tell what state the key is in.  By turning the
\    capslock off we can avoid the problem of accidentally having several
\    sentences with the wrong case.  The program has been kept general
\    so that other similar uses may be imagined and used.
\
\  When the program is first run, it installs a small (208 byte) piece
\    in memory (a TSR).  On subsequent execution, it finds and changes
\    the initial values of the flags stored in that resident portion.
\    The command line parameters are the same whether it's being run for
\    the first or subsequent times.  The first time it should be run
\    directly from DOS, or in a batch file, to avoid fragmenting memory.
\    Subsequent runs may be from shells within other programs.  For most
\    purposes it will be run once or twice in the autoexec.bat file, and
\    not changed.
\
\ There are 4 flags kept in the BIOS at  40:17h that are of interest
\    to us here.  They are CAPS NUM INSERT and SCROLL.  The latter two
\    may not be used by very many programs, but they're here for
\    completeness.  For each of these flags there are 3 things our
\    resident program can do:  leave it alone, force it on, or force it off.
\    Of course with the program not loaded, it will leave all 4 alone.
\    The commmandline syntax is adequate to change the behavior of one of
\    these flags.  If more than one needs to be affected, run it more than
\    once.
\
\ The program is run as follows:      LEAVE  <flag>  <attrib>
\                [CAPS  ]   [OFF]
\        LEAVE   [NUM   ]   [ON]
\                [SCROLL]   [ALONE]
\                [INSERT]
\    where the flag is mandatory, but the attrib is optional.  (The default
\    is 'ALONE')
\
\ Most people would use one of the following 2 line sequences:
\
\       LEAVE CAPS OFF             ]
\       LEAVE NUM ON               ]   for an extended keyboard
\
\       LEAVE CAPS OFF             ]
\       LEAVE NUM OFF              ]   for an 83 key keyboard
\
\
\  The program has no known incompatibilities with IBM type hardware and
\     software, including TSR's, but I'd be suspicious of the PCJr
\     differences.  It is in use by only 3 people, so until this version
\     gets wider distribution, I won't know if there are other problems.
\
\  Technical details.  The resident portion works by hooking Int09, the
\     keyboard interrupt.  It modifies the byte at 40:17, then jumps to
\     the previous interrupt handler.  It makes no DOS calls, no BIOS
\     calls, and has no other side effects.  It uses less stack than any
\     keyboard handler I know of, and should therefore be completely safe.
\
\  You are free to use this program, and to give it away unmodified, as
\     long as you include both this source and executable in any copies.
\     You may make changes for your own use, and I welcome comments and
\     suggestions.  I make no warranties, and expect no remuneration.
\
\  Dave Angel    Compuserve 71046,1567      Delphi  DaveA
\
\  CFORTH details.  The library file  FORTHLIB.SCR supplied in CFORTH 1.10
\     needs to be modified to correctly compile this program.  Copy the
\     file  FORTHLIB.SCR to FORTHL.SCR and on line 10 delete the word
\     NOT  in      ?DEFINE EMIT NOT #IF  ...
\     This may have been a typo in the library.  Anyway, my stuff runs
\     much better after the change.
\
100 MSDOS               \ small model, .COM file, CS=DS=SS
HEX
REQUIRE CS:TYPE
REQUIRE TYPE
 9 CONSTANT INT#
90 CONSTANT SIGNATURE  \ offset in resident code for signature  "SHIFTLESS:"
9A CONSTANT ANDBYTE    \ offsets in resident    where Andbyte and Orbyte
9B CONSTANT ORBYTE     \      are to be found
9C CONSTANT SAVEVECT
A0 CONSTANT CODEBEGIN  \ offset where code begins

CODE INTENTRY
  AX PUSH  ES PUSHSEG  40 # AX MOV AX ES >SEG  \ point ES at 40:0
  ES: 17 [] AL MOV   AL NOT
  CS: ANDBYTE [] AL OR   AL NOT   \ turn off specified bits
  CS: ORBYTE [] AL OR            \ turn on  specified bits
  ES: AL 17 [] MOV
  ES POPSEG   AX POP
   2E C, 0FF C, 2E C, SAVEVECT ,   \ JMP  CS:[SAVEVECT]
  END-CODE
HERE ' INTENTRY - CONSTANT  CODESIZE
DECIMAL
VARIABLE  #TIB        \ size of the TIB
VARIABLE  >IN         \ offset in the TIB
129  CONSTANT TIB     \ the commandtail is the "terminal input buffer"

0 CONSTANT FALSE
-1 CONSTANT TRUE
CREATE  <signature> 10 C,  ," SHIFTLESS:"
VARIABLE  CAPSSEG      \  segment of resident portion of the program
0 1 IN/OUT
CODE  SEG:   ( -- seg#  ;  return segment # we're running in, CS)
   CS PUSHSEG  AX POP RET  END-CODE

HEX

0 1 IN/OUT
CODE Getarena   ( -- seg ;   This is the only undocumented DOS call I made)
     52 # AH MOV   21 INT   ES: -2 +[BX] AX MOV  RET
CREATE (arena-scratch)  10 ALLOT

: FINDSHIFTLESS  ( -- flag; true if already loaded)
                           ( side effect, CAPSSEG is set to its segment)
     CAPSSEG 0 <-
     Getarena
     BEGIN
         DUP 0  SEG: (arena-scratch) 10 CMOVEL   ( move to local copy)
         DUP 1+ TESTCAPS  IF DUP 1+ CAPSSEG !   THEN
         (arena-scratch) 3 + @ +  1+
    (arena-scratch) C@  ASCII M <>
    UNTIL
    DROP  CAPSSEG @ 0<> ;


: TESTCAPS     ( seg -- flag ; true if this segment points to resident code)
                              \ notice it uses my own command tail as a
                              \ working area.  So I'd better be done parsing
     DUP SEG: <>
     IF     80        SEG: 80  20  CMOVEL
            SIGNATURE  <signature> COUNT S=      \ check signature
     ELSE  FALSE     \ return false if we're looking at my own segment!
     THEN
     ;

DECIMAL


: S=  ( addr1 addr2 len -- flag ; compare two strings, true if equal)
   >R  TRUE  -ROT  R> 0
   ?DO
      OVER I + C@   OVER I + C@
    <> IF ROT DROP 0 -ROT  LEAVE THEN
    LOOP
    2DROP ;

: UPC-STRING   ( addr cnt -- addr cnt;  force the string to uppercase)
      2DUP  0 DO   DUP DUP C@
                       DUP ASCII a >= IF DUP ASCII z <=
                                      IF 32 - THEN THEN
                   C<-  1+
              LOOP DROP ;

VARIABLE  bit-mask     \ bit mask from first argument
VARIABLE  flag2        \ derived from 2nd argument
: PARSE-CMD  ( -- ;  process the command tail, leaving bit-mask & flag2)
   128 C@ #TIB !
   >IN OFF

   BL WORD COUNT DUP 0= IF HELP.ME THEN ( NO ARGUMENTS )
   UPC-STRING 2 MAX TEST1 bit-mask C!
   flag2 0 C<-
   BL WORD COUNT DUP 0<>
   IF    UPC-STRING 2 MAX   TEST2 flag2 C!   THEN   ;

(            IZZIT?    check if first string is a substring of second )
: IZZIT?  ( addr cnt addr2 -- addr cnt flag ; addr2 is of a counted string)
        COUNT
        SWAP >R >R  2DUP DUP R> <=  (  see if first string is no longer)
        IF R>  SWAP S=       ( If so, compare the strings)
        ELSE 2DROP R> DROP FALSE THEN  ( if not, strings are considered different)
;
CREATE "CAPSLOCK"  8 C, ," CAPSLOCK"
CREATE "NUMLOCK"   7 C,    ," NUMLOCK"
CREATE "SCROLLLOCK" 10 C,   ," SCROLLLOCK"
CREATE "INSERT"     6 C,   ," INSERT"
CREATE "OFF"       3 C, ," OFF"
CREATE "ON"         2 C,  ," ON"
CREATE "ALONE"      5 C,  ," ALONE"
(   parse first argument, to build a bit mask )
: TEST1       ( addr cnt -- bit-mask )
             "CAPSLOCK"      IZZIT?  IF  2DROP 64
        ELSE "NUMLOCK"       IZZIT?  IF  2DROP 32
        ELSE "SCROLLLOCK"    IZZIT?  IF  2DROP 16
        ELSE "INSERT"        IZZIT?  IF  2DROP 128
        ELSE  " Keyword '" COUNT ERRORdisp  THEN THEN THEN THEN ;
(  parse second argument, to save a flag )
: TEST2       ( addr cnt -- 0 | 1 | 2 )
             "OFF"    IZZIT?  IF  2DROP 1
        ELSE "ON"     IZZIT?  IF  2DROP 2
        ELSE "ALONE"  IZZIT?  IF  2DROP 0
        ELSE  " Attribute '" COUNT ERRORdisp THEN THEN THEN  ;
: ERRORdisp
     7 EMIT    ." Invalid "  TYPE
     DUP DROP  TYPE    ASCII ' EMIT  CR
      HELP.ME  ;
: HELP.ME      ( -- ;   Show the user the correct syntax, then exit)
      CR  ." Syntax:" CR
      ." LEAVE <keyword> <attrib>" CR
      ."    where  <keyword>  is  CAPS, NUM, INSERT or SCROLL" CR
      ."    and    <attrib>   is  ON,  OFF,  or ALONE"  CR     BYE ;

: CHANGEBYTES   ( -- ; change ANDBYTE and ORBYTE of resident code)
                        ( this is real work of transient portion)
       CAPSSEG @ ANDBYTE 2DUP  C@L  bit-mask C@ NOT AND  -ROT C!L
       CAPSSEG @ ORBYTE  2DUP  C@L  bit-mask C@ NOT AND  -ROT C!L
       flag2 C@ DUP 1 =
       IF CAPSSEG @ ANDBYTE 2DUP  C@L  bit-mask C@ OR  -ROT C!L THEN
       2 =
       IF CAPSSEG @ ORBYTE 2DUP  C@L  bit-mask C@ OR  -ROT C!L THEN ;
HEX
0 2 IN/OUT
CODE (getvect)   ( -- seg offset ;   get current Int vector)
   3500 INT# + # AX MOV    21 INT  ES AX <SEG  RET END-CODE
1 0 IN/OUT
CODE (setvect)   ( offset -- ;  set Int vector)
   AX DX MOV  2500 INT# + # AX MOV    21 INT   RET END-CODE
1 0 IN/OUT
CODE releasemem
    AX ES >SEG 49 # AH MOV   21 INT  RET
1 0 IN/OUT
CODE TSR  ( n -- ;  Terminate and stay resident, keep n paragraphs of mem)
   AX DX MOV   3100 # AX MOV  21 INT  END-CODE
DECIMAL

: INSTALL    ( -- ;  install resident code/data into my PSP )
      128 127 0  FILL      128 16 13 FILL
     "  LEAVE Ver 1.0" DUP C@  128 SWAP 1+ CMOVE
      <signature>  COUNT SIGNATURE SWAP CMOVE
     ['] INTENTRY CODEBEGIN CODESIZE CMOVE
     (getvect)   SAVEVECT  2+ !     SAVEVECT  !
     SEG: CAPSSEG !
     CHANGEBYTES
     CODEBEGIN (setvect)
     44 @ releasemem              \ release the environment space
 ;
: MAIN   ." LEAVE Version 1.0a Copyright (c) 1987 by Dave Angel" CR
      PARSE-CMD
      FINDSHIFTLESS  IF ." Resident flags modified"  CHANGEBYTES
                ELSE  ." Installing resident flags" INSTALL
                      13 TSR     ( note, size is hardcoded to 13 paragraphs)
                THEN

      BYE
      ;
INCLUDE FORTHL              \ standard libraries
: "TYPE"    ASCII " EMIT  TYPE   ASCII " EMIT ;
      ( for some reason, "TYPE must be defined after the INCLUDE.  Dunno why)
END

