	name	bioscksm
	page	55,132
	title	'BIOSCKSM - checksum ROM BIOS, by Charlie Stampf, N2CJ'

	dosseg					;use Microsoft segment order
	.model	small				;create small model program

	.code					;open code segment

main	proc
	mov	ax,@data
	mov	ds,ax
	mov	dx,offset msg5			;sign on
	call	prtmsg
	mov	ax,0F000H			;point to ROM		
	mov	ds,ax				;set up DATA segment
	mov	ax,19eh				;offset to original HALT inst.
	mov	si,ax				;point to it
	mov	al,[si]				;go get it
	cmp	al,90h				;has it been changed to NOP ?
	jz	count				;yep, continue
	mov	ax,@data			;NO, it's not a NOP
	mov	ds,ax
	mov	dx,offset msg4
	call	prtmsg				;print error message and quit
	call	crlf
	jmp	done
count:
	xor	si,si				;segment pointer to 0
	xor	bx,bx				;clear place for additions
	mov	cx,8000h			;number of bytes to check
lp1:	lodsw					;fetch ROM word
	add	bl,ah				;add hi byte to sub-total
	add	bl,al				; add low byte
	loop	lp1				; for 32768 words

;the following two instructions adjusts for a previously included NOP
;that might have been inserted into ROM.  A HALT instruction was
;there originally.  Used if POST checksum error occured.

	sub	bl,90h				;correct for NOP
	add	bl,0f4h				; include HALT instruction

;this routine displays our computed checksum and the value to be inserted
;as the last byte in ROM so that the BIOS cksum equals zero.

	mov	ax,@data			;restore DATA pointer
	mov	ds,ax
	push	bx				;save ROM checksum
	call	crlf				;advance screen one line
	mov	dx,offset msg1			;point to 1st message
	call	prtmsg				;print it to screen
	call	binihex				;convert cksum to ASCII hex
	call	crlf				;advance screen 1 line
	pop	bx				;retreive computed cksum
	mov	ax,0100h			;compute offset to add for
	sub	ax,bx				; 0 result
	xchg	ax,bx				;prepare it for display
	push	bx				; save it for now
	mov	dx,offset msg2			; display message 2
	call	prtmsg
	pop	bx				;retreive offset value
	call	binihex				;convert it to ASCII hex
	mov	dx,offset msg3			;display message 3
	call	prtmsg	
done:	mov	ax,4c00h			;the main routine terminates
	int	21h				;and passes a return code
main	endp

;this routine converts the computed binary value to ASCII hex and displays
;it on the screen using DOS interrupt 21H

binihex	proc	near
	mov	ch,4				;number of digits
rotate:	mov	cl,4				;set count to 4 bits
	rol	bx,cl				;left digit to right
	mov	al,bl				;move to AL
	and	al,0fh				;mask of left digit
	add	al,30h				;convert hex to ASCII
	cmp	al,3ah				;is it > 9d ?
	jl	printit				;jump if digit = 0 to 9
	add	al,7h				;digit is A to F
printit:
	mov	dl,al				;put ASCII char in DL
	mov	ah,2				;Display Output funct
	int	21h				;call DOS
	dec	ch				;done 4 digits ?
	jnz	rotate				;not yet
	ret					;return
binihex	endp

;this routine simply outputs a lf/cr to the screen
;
crlf	proc	near
	mov	dl,0dh				;carriage return
	mov	ah,2				;display function
	int	21h				;call DOS

	mov	dl,0ah				;linefeed
	mov	ah,2				;display function
	int	21h				;call DOS
	ret					;return
crlf	endp


prtmsg	proc	near
	mov	ah,09h				;use DOS to print messages
	int	21h
	ret
prtmsg	endp

	.data					;data segment

msg1	db 'BIOS ROM checksum = ','$'		
msg2	db 'Add the value ','$'
msg3	db 'H to ROM ADJUSTMENT BYTE for 0000H checksum result.',10,13
	db 'This is the last byte in the ODD module, U47.',10,13,'$'
msg4	db 'BIOS must have NOP at 019EH to run this program !$'
msg5	db 10,13,'BIOSCKSM v1.2',10,13,'$'

	.stack 256				

	end	main				;defines the entry point
