; FONTLOAD.COM
; Kurt Pettersen 1990
; Program to load a font file into the
; EGA or VGA user font area.

.radix  16

lf  equ 0A                   ;Set lf (Line Feed) = chr$(10)
cr  equ 0Dh                  ;Set cr (Carriage Return) = chr$(13)
term  equ '$'                ;ASCIIZ to Terminate Message Strings

code  segment
  org 100
  assume  cs:code, ds:code, es:code  

Begin:

  jmp Start   ;Jump over data storage
  
SMsg      db  'Fontload Ver.1.0 Kurt Pettersen 1990',cr,lf,term
NoFileMsg db  'Please specify a filename',cr,lf,term
NoLoadMsg db  'Can''t LOAD '
FileName  db  90d dup (?)
FontBuff  db  1000  dup (?)

Start:

  push  cs    ; Make sure that all segments are the same
  push  cs    ; I am being kinda redundant after the above assume
  pop ds      ; But it works, so I won't complain if you don't!
  pop es

  lea dx, SMsg       ; Print my header to the screen!
  mov ah, 9
  int 21
  mov si, 0080       ; Look at command line count
  lodsb
  cmp al, 0          ; If no command line, then Exit
  je  NoFile
  xor cx, cx         ; Otherwise get command line count
  mov cl, al

SkipSpaces:
  lodsb              ; Get a command line character
  cmp al, ' '        ; Skip over any spaces
  jne CopyFileName
  dec cx
  jmp SkipSpaces

CopyFileName:
  dec si              ; We've found the start of the filename
  lea di, FileName    ; Copy it to our FileName buffer
  rep movsb
  mov al, 0           ; ASCIIZ terminator
  stosb

  lea dx, FileName    ; Try to OPEN the font file
  mov ax, 3D00
  int 21
  jc  NoLoad          ; If carry is set, then there's trouble
  mov bx, ax          ; Otherwise save the handle

  lea dx, FontBuff    ; Point to our font buffer
  mov cx, 1000        ; 4K to LOAD
  mov ah, 3F          ; LOAD it
  int 21

  mov ah, 3E          ; CLOSE the font file
  int 21

  mov ax, 1100        ; Load user font area 0
  mov bx, 1000        ; Sixteen bytes per character
  mov cx, 256d        ; All 256 characters to load
  mov dx, 0           ; Starting at offset 0
  lea bp, FontBuff    ; Point to the font buffer
  int 10              ; Do it

GetOut:
  mov ax, 4C00        ; Exit to DOS with no errors
  int 21

NoFile:
  mov ax, 0003        ; Reset VGA card
  int 10              ; Do it

  lea dx, SMsg
  mov ah, 9
  int 21
  lea dx, NoFileMsg   ; Give our condolances
  mov ah, 9
  int 21
  jmp GetOut

NoLoad:
  mov ax, 0003        ; Reset VGA card
  int 10              ; Do it
  lea dx, SMsg
  mov ah, 9
  int 21
  dec di              ; Fix the COPIED filename
  mov al, cr          ; so that DOS will print it
  stosb
  mov al, lf
  stosb
  mov al, term
  stosb
  lea dx, NoLoadMsg   ; More condolences
  mov ah, 9
  int 21
  jmp GetOut

code  ends

End Begin
