VERSION 2.00
Begin Form frmFilter 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Filter Record Set"
   ClientHeight    =   3810
   ClientLeft      =   750
   ClientTop       =   1275
   ClientWidth     =   8400
   Height          =   4215
   Left            =   690
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3810
   ScaleWidth      =   8400
   Top             =   930
   Width           =   8520
   Begin VideoSoftElastic vseBackground 
      Align           =   5  'Fill Container
      BackColor       =   &H00C0C0C0&
      BevelChildren   =   3  'No Graphical or Elastics
      BevelOuter      =   1  'Raised
      Height          =   3810
      IntBkg          =   &H00C0C0C0&
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   8400
      Begin VideoSoftElastic vseNewFilter 
         BackColor       =   &H00C0C0C0&
         BevelOuter      =   6  'Groove
         Caption         =   "Create a New Filter Where"
         Height          =   1095
         IntBkg          =   &H00C0C0C0&
         Left            =   150
         Style           =   1  'Frame Top
         TabIndex        =   6
         Top             =   1830
         Width           =   8055
         Begin ComboBox cboFilter 
            Height          =   300
            Left            =   2430
            Style           =   2  'Dropdown List
            TabIndex        =   9
            Top             =   540
            Width           =   1185
         End
         Begin ComboBox cboField 
            Height          =   300
            Left            =   150
            Style           =   2  'Dropdown List
            TabIndex        =   8
            Top             =   540
            Width           =   2205
         End
         Begin TextBox txtCriteria 
            Height          =   315
            Left            =   3690
            TabIndex        =   1
            Top             =   540
            Width           =   4215
         End
      End
      Begin VideoSoftElastic vseCurFilters 
         AutoSizeChildren=   1  'Even Horizontal
         BackColor       =   &H00C0C0C0&
         BevelOuter      =   6  'Groove
         Caption         =   "Current Filters"
         Height          =   1695
         IntBkg          =   &H00C0C0C0&
         Left            =   150
         Style           =   1  'Frame Top
         TabIndex        =   5
         Top             =   120
         Width           =   8055
         Begin ListBox lstFilters 
            Height          =   1200
            Left            =   90
            TabIndex        =   7
            Top             =   330
            Width           =   7875
         End
      End
      Begin CommandButton cmdClear 
         Caption         =   "Clear &All Filters"
         Height          =   435
         Left            =   3000
         TabIndex        =   4
         Top             =   3150
         Width           =   2325
      End
      Begin CommandButton cmdCancel 
         Caption         =   "&Cancel"
         Height          =   435
         Left            =   5880
         TabIndex        =   3
         Top             =   3150
         Width           =   2325
      End
      Begin CommandButton cmdExecute 
         Caption         =   "&Set New Filter"
         Height          =   435
         Left            =   180
         TabIndex        =   2
         Top             =   3150
         Width           =   2325
      End
   End
   Begin VideoSoftAwk awkData 
      FS              =   "|"
      Left            =   3600
      Top             =   990
   End
End
Option Explicit

Sub cmdCancel_Click ()
  Unload Me
End Sub

Sub cmdClear_Click ()
  '
  ' Clear Filter Arrays, Reset RecordSource, Exit Form
  '
  Dim iCnt As Integer
  Dim sSQL As String
  gsFilter = ""
  For iCnt = 1 To 20
    gsFilters(iCnt) = ""
  Next
  sSQL = gsCurQuery & gsFilter & gsSort
  frmMain.dtaNames.RecordSource = sSQL
  frmMain.dtaNames.Refresh
  frmMain.tblNames.Refresh
  Unload Me
End Sub

Sub cmdExecute_Click ()
  On Error GoTo cmdExecute_ClickErr
  Dim sTmp As String, sSQL As String, sAdd As String
  Dim sTmpFilter As String, sOp As String, sItem As String
  Dim iCnt As Integer, iPos As Integer
  If Trim$(cboField.Text) <> "" Then
    sTmp = cboField.Text
    '
    ' If specified field has a space in it, place it in brackets
    '
    If InStr(sTmp, " ") Then
      sTmp = "[" & sTmp & "]"
    End If
    '
    ' Create correct syntax for Between operator
    '
    sOp = " AND "
    If cboFilter.Text = "Between" Then
      iPos = InStr(txtCriteria.Text, sOp)
      If iPos <> 0 Then
        sTmpFilter = Mid$(txtCriteria.Text, 1, iPos - 1) & Chr$(34)
        sTmpFilter = sTmpFilter & sOp & Chr$(34) & Mid$(txtCriteria.Text, iPos + 5)
      End If
    Else
      sTmpFilter = txtCriteria.Text
    End If
    '
    ' Build new filter string
    '
    sAdd = sOp & sTmp & " " & cboFilter.Text & " " & Chr$(34) & sTmpFilter & Chr$(34)
  Else
    sAdd = ""
  End If
  '
  ' Add new filter to list and rebuild default filter
  '
  lstFilters.AddItem sAdd
  gsFilter = ""
  For iCnt = 0 To lstFilters.ListCount - 1
    gsFilter = gsFilter & lstFilters.List(iCnt)
    gsFilters(iCnt + 1) = lstFilters.List(iCnt)
  Next
  '
  ' Update and Unload
  '
  sSQL = gsCurQuery & gsFilter & gsSort
  frmMain.dtaNames.RecordSource = sSQL
  frmMain.dtaNames.Refresh
  frmMain.tblNames.Refresh
  Unload Me
Exit Sub

cmdExecute_ClickErr:
  '
  ' Error occured when trying to build or execute filter.
  ' This section could be expanded to include more detail.
  '
  MsgBox "Invalid Filter.  Please Correct and try again.  (" & Err & ")", 48
Exit Sub

End Sub

Sub Form_Load ()
  Dim iCnt As Integer
  Dim iPos As Integer
  Dim sTmp As String
  Dim sItem As String
  SetupDialogMenu Me
  '
  ' Using VBVBX AWK control to simulate old BASIC DATA statement.  Values
  ' are separated by a '|' character
  '
  awkData.F(0) = "=|>|<|>=|<=|Like|Not Like|Between"
  For iCnt = 1 To awkData.NF
    cboFilter.AddItem awkData.F(iCnt)
  Next
  For iCnt = 0 To frmMain.dtaNames.Recordset.Fields.Count - 1
    If frmMain.dtaNames.Recordset.Fields(iCnt).Name = "Company Name" Or frmMain.dtaNames.Recordset.Fields(iCnt).Name = "count" Then
      '
      ' Don't use these fields because they're the primary and main secondary keys
      '
    Else
      '
      ' Add field to combobox list
      '
      If InStr(gsFilter, frmMain.dtaNames.Recordset.Fields(iCnt).Name) = 0 Then
        cboField.AddItem frmMain.dtaNames.Recordset.Fields(iCnt).Name
      End If
    End If
  Next
  '
  ' Load current filters
  '
  For iCnt = 1 To 20
    If gsFilters(iCnt) = "" Then
      Exit For
    Else
      lstFilters.AddItem gsFilters(iCnt)
    End If
  Next
End Sub

Sub lstFilters_KeyUp (KeyCode As Integer, Shift As Integer)
  Dim sTmp As String
  Dim iPos As Integer
  '
  ' If Delete key is pressed, then remove that filter from the list
  '
  If KeyCode = KEY_DELETE Then
    sTmp = lstFilters.List(lstFilters.ListIndex)
    lstFilters.RemoveItem (lstFilters.ListIndex)
    sTmp = Trim$(Mid$(sTmp, 6))
    iPos = InStr(sTmp, " ")
    sTmp = Mid$(sTmp, 1, iPos - 1)
    cboField.AddItem sTmp
  End If
End Sub

