VERSION 2.00
Begin Form frmSQL 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Enter Selection Criteria"
   ClientHeight    =   5145
   ClientLeft      =   765
   ClientTop       =   1320
   ClientWidth     =   7950
   Height          =   5550
   Icon            =   FRMSQL.FRX:0000
   Left            =   705
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5145
   ScaleWidth      =   7950
   Top             =   975
   Width           =   8070
   Begin VideoSoftElastic vseBack 
      Align           =   5  'Fill Container
      AutoSizeChildren=   2  'Uneven Horizontal
      BackColor       =   &H00C0C0C0&
      BevelChildren   =   2  'No Elastics
      BevelOuter      =   1  'Raised
      Height          =   5145
      IntBkg          =   &H00C0C0C0&
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7950
      Begin VideoSoftElastic VSElastic1 
         AutoSizeChildren=   1  'Even Horizontal
         BackColor       =   &H00C0C0C0&
         Height          =   4965
         IntBkg          =   &H00C0C0C0&
         Left            =   90
         TabIndex        =   6
         Top             =   90
         Width           =   5475
         Begin VideoSoftElastic vseSQL 
            AutoSizeChildren=   4  'Uneven Vertical
            BackColor       =   &H00000000&
            BevelInner      =   1  'Raised
            BevelInnerWidth =   0
            BorderWidth     =   0
            ChildSpacing    =   8
            Height          =   4785
            Left            =   90
            Splitter        =   1  'Yes (with uneven spacing)
            TabIndex        =   7
            TagPosition     =   1  'Above Control
            Top             =   90
            Width           =   5295
            Begin VideoSoftElastic vsePrevQ 
               AutoSizeChildren=   1  'Even Horizontal
               BackColor       =   &H00C0C0C0&
               Caption         =   "Previously Executed Queries"
               Height          =   1515
               IntBkg          =   &H00C0C0C0&
               Left            =   0
               Style           =   1  'Frame Top
               TabIndex        =   12
               Top             =   1635
               Width           =   5295
               Begin ListBox lstPreviousQ 
                  Height          =   1005
                  Left            =   90
                  TabIndex        =   13
                  Top             =   330
                  Width           =   5115
               End
            End
            Begin VideoSoftElastic vseCurrent 
               AutoSizeChildren=   1  'Even Horizontal
               BackColor       =   &H00C0C0C0&
               Caption         =   "Current Query"
               Height          =   1515
               IntBkg          =   &H00C0C0C0&
               Left            =   0
               Style           =   1  'Frame Top
               TabIndex        =   10
               Top             =   0
               Width           =   5295
               Begin TextBox txtSQL 
                  Height          =   1095
                  Left            =   90
                  MultiLine       =   -1  'True
                  ScrollBars      =   2  'Vertical
                  TabIndex        =   11
                  Top             =   330
                  Width           =   5115
               End
            End
            Begin VideoSoftElastic vseDefine 
               AutoSizeChildren=   3  'Even Vertical
               BackColor       =   &H00C0C0C0&
               Caption         =   "Available Query Definitions"
               Height          =   1515
               IntBkg          =   &H00C0C0C0&
               Left            =   0
               Style           =   1  'Frame Top
               TabIndex        =   8
               TagPosition     =   1  'Above Control
               Top             =   3270
               Width           =   5295
               Begin ListBox lstQueries 
                  Height          =   1005
                  Left            =   90
                  TabIndex        =   9
                  Top             =   330
                  Width           =   5115
               End
            End
         End
      End
      Begin VideoSoftElastic vseButtons 
         AutoSizeChildren=   3  'Even Vertical
         BackColor       =   &H00C0C0C0&
         Height          =   4965
         IntBkg          =   &H00C0C0C0&
         Left            =   5655
         TabIndex        =   1
         Top             =   90
         Width           =   2205
         Begin CommandButton cmdBuild 
            Caption         =   "&Build Query..."
            Height          =   885
            Left            =   90
            TabIndex        =   14
            Top             =   1065
            Width           =   2025
         End
         Begin CommandButton cmdDelete 
            Caption         =   "&Delete Query"
            Height          =   885
            Left            =   90
            TabIndex        =   5
            Top             =   2040
            Width           =   2025
         End
         Begin CommandButton cmdCancel 
            Caption         =   "&Cancel"
            Height          =   885
            Left            =   90
            TabIndex        =   4
            Top             =   3990
            Width           =   2025
         End
         Begin CommandButton cmdSaveQuery 
            Caption         =   "&Save Query"
            Height          =   885
            Left            =   90
            TabIndex        =   3
            Top             =   3015
            Width           =   2025
         End
         Begin CommandButton cmdExecute 
            Caption         =   "E&xecute"
            Height          =   885
            Left            =   90
            TabIndex        =   2
            Top             =   90
            Width           =   2025
         End
      End
   End
End
Option Explicit
'
' Form Level Variables
'
  Dim fsPrevSQL(255) As String    'Previously executed SQL statements
  Dim fiPSQLCnt As Integer        'Number of Previously executed SQL statements

Sub cmdBuild_Click ()
  NotImplemented "Build Query"
End Sub

Sub cmdCancel_Click ()
  Unload Me
End Sub

Sub cmdDelete_Click ()
  '
  ' If a pre-defined query is selected, delete it on user's request
  '
  If lstQueries.ListIndex = -1 Then Exit Sub
  If MsgBox("Are you sure you want to delete query definition '" & lstQueries.List(lstQueries.ListIndex) & "'.", MB_YESNO + MB_ICONEXCLAMATION) = IDYES Then
    gdbAccess.DeleteQueryDef lstQueries.List(lstQueries.ListIndex)
    lstQueries.RemoveItem lstQueries.ListIndex
  End If
End Sub

Sub cmdExecute_Click ()
  On Error GoTo cmdExecute_Click_Err
  Dim iCnt As Integer, iUpdate As Integer
  '
  ' Try to execute current SQL Statement
  '
  frmMain.dtaNames.RecordSource = txtSQL
  frmMain.dtaNames.Refresh
  '
  ' Save SQL statement info, if it is new or non-duplicate
  ' Program only saves last 255 SQL statements
  ' Enhancement could include saving to .INI
  '
  gsCurQuery = txtSQL
  iUpdate = True
  For iCnt = 1 To fiPSQLCnt
    If fsPrevSQL(fiPSQLCnt) = txtSQL Then
      iUpdate = False
      Exit For
    End If
  Next
  If iUpdate Then
    fiPSQLCnt = fiPSQLCnt + 1
    If fiPSQLCnt <= 255 Then
      fsPrevSQL(fiPSQLCnt) = txtSQL
    End If
  End If
  Unload Me
Exit Sub

cmdExecute_Click_Err:
  Select Case Err
    Case 3001 To 3218, 3220 To 3299, 600 To 646, 2420 To 2477
      '
      ' Incorrect syntax when entering a SQL statement
      '
      MsgBox "A Syntax or Data access error occured when executing SQL Statement." & Chr$(13) & Chr$(13) & Error$, 48
    Case 3219
      '
      ' Indicates an non-SELECT SQL statement was attempted.
      ' Possible Enhancement would include a 'pass-through' option
      '
      MsgBox "This SQL statement cannot be processed by the Data Grid.", 48
    Case Else
      '
      ' Some other error occured
      '
      MsgBox Error$ & " (#" & Err & ") occured in cmdExecute."
  End Select
  Exit Sub
End Sub

Sub cmdSaveQuery_Click ()
  On Error GoTo cmdSaveQuery_ClickErr
  Dim qdSave As QueryDef, sQname As String, iExists As Integer
  '
  ' Enter the name for the query, if it's blank, quit
  '
  sQname = InputBox$("Enter Query Name for this expression", "Enter Query Name", "")
  If sQname = "" Then Exit Sub
  '
  ' See if query is already defined, if so, ask user if they want to
  ' overwrite it.
  '
  iExists = True
  Set qdSave = gdbAccess.OpenQueryDef(sQname)
  If iExists Then
    If MsgBox("Query Definition ( " & sQname & " ) already exists.  Do you want to overwrite it?", MB_YESNO + MB_ICONQUESTION) = IDYES Then
      gdbAccess.DeleteQueryDef sQname
    Else
      Exit Sub
    End If
  End If
  Set qdSave = gdbAccess.CreateQueryDef(sQname, txtSQL)
  lstQueries.AddItem sQname
Exit Sub

cmdSaveQuery_ClickErr:
  Select Case Err
    Case 3011:
      '
      ' This error indicates that the query definition already exists
      '
      iExists = False
      Resume Next
    Case Else:
      '
      ' Some other error occured
      '
      MsgBox Error$ & " (#" & Err & ") occured in cmdSaveQuery_Click", 48
   Exit Sub
 End Select
End Sub

Sub Form_Load ()
  Dim snListSet As Snapshot
  Dim iCnt As Integer
  SetupDialogMenu Me
  '
  ' Get pre-defined queries from database
  '
  Set snListSet = gdbAccess.ListTables() ' Copy Table info to ListSet.
  Do While Not snListSet.EOF
    If snListSet("TableType") = DB_QUERYDEF Then
      lstQueries.AddItem snListSet("Name")
    End If
    snListSet.MoveNext  ' Move to next record.
  Loop
  '
  ' Load previous queries
  '
  For iCnt = 1 To fiPSQLCnt
    lstPreviousQ.AddItem fsPrevSQL(iCnt)
  Next
  txtSQL = gsCurQuery & gsFilter & gsSort
End Sub

Sub lstPreviousQ_Click ()
  txtSQL = lstPreviousQ.Text
End Sub

Sub lstQueries_Click ()
  '
  ' Retrieve query from database
  '
  Dim qdActive As QueryDef
  Set qdActive = gdbAccess.OpenQueryDef(lstQueries.Text)
  txtSQL = qdActive.SQL
  qdActive.Close
End Sub

Sub lstQueries_DblClick ()
  Dim qdActive As QueryDef
  Set qdActive = gdbAccess.OpenQueryDef(lstQueries.Text)
  txtSQL = qdActive.SQL
  gsCurQuery = txtSQL
  frmMain.dtaNames.RecordSource = qdActive
  frmMain.dtaNames.Refresh
  Unload Me
End Sub

