Option Explicit
  '
  ' User Defined Type Declarations
  '
  '
  ' CONSTANTS
  '
    '
    ' System Menu Constants
    '
      Global Const MF_SEPARATOR = &H800
      Global Const MF_STRING = &H0
      Global Const MF_ENABLED = 0
      Global Const MF_BYCOMMAND = &H0
      Global Const MF_UNCHECKED = &H0
      Global Const MF_CHECKED = &H8
      Global Const MF_BYPOSITION = &H400
    '
    ' MsgBox parameters
    '
      Global Const MB_OK = 0                 ' OK button only
      Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
      Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
      Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
      Global Const MB_YESNO = 4              ' Yes and No buttons
      Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

      Global Const MB_ICONSTOP = 16          ' Critical message
      Global Const MB_ICONQUESTION = 32      ' Warning query
      Global Const MB_ICONEXCLAMATION = 48   ' Warning message
      Global Const MB_ICONINFORMATION = 64   ' Information message

      Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
      Global Const MB_DEFBUTTON1 = 0         ' First button is default
      Global Const MB_DEFBUTTON2 = 256       ' Second button is default
      Global Const MB_DEFBUTTON3 = 512       ' Third button is default
      Global Const MB_SYSTEMMODAL = 4096      'System Modal
    '
    ' MsgBox return values
    '
      Global Const IDOK = 1                  ' OK button pressed
      Global Const IDCANCEL = 2              ' Cancel button pressed
      Global Const IDABORT = 3               ' Abort button pressed
      Global Const IDRETRY = 4               ' Retry button pressed
      Global Const IDIGNORE = 5              ' Ignore button pressed
      Global Const IDYES = 6                 ' Yes button pressed
      Global Const IDNO = 7                  ' No button pressed
    '
    ' ListTables TableType
    '
      Global Const DB_TABLE = 1
      Global Const DB_QUERYDEF = 5
    '
    ' Key Up/Down Constants
    '
      Global Const KEY_DELETE = &H2E
      Global Const KEY_INSERT = &H2D
  '
  ' API Declarations
  '
    '
    ' System Menu API Declarations
    '
      '
      ' Append or Remove menu items
      '
        Declare Function AppendMenu Lib "USER" (ByVal hMenu As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpNewItem As Any) As Integer
        Declare Function RemoveMenu Lib "USER" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
      '
      ' Get System Menu handle
      '
        Declare Function GetSystemMenu Lib "USER" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
  '
  ' Application Globals
  '
    Global gdbAccess As database       'Current Access Database
    Global gsAccess As String          'Current Access Database File
    Global gsCurQuery As String        'Current Query
    Global gsFilter As String          'Default Filter definition
    Global gsSort As String            'User defined sort parameters
    Global gsFilters(20) As String     'User defined data filters

Sub Main ()
  '
  ' Get database name and set matching global vars
  '
  Dim sSetupDir As String
  sSetupDir = InputBox$("Enter Location for Database and Help File", "File Location", "C:\VB\DB_PROTO\")
  If sSetupDir = "" Then End
  gsAccess = sSetupDir & "DB_PROTO.MDB"
  Set gdbAccess = OpenDatabase(gsAccess)
  frmMain.Show
End Sub

Sub NotImplemented (sMsg As String)
  MsgBox "This feature ( " & sMsg & " ) is not implemented in this prototype application.", MB_ICONINFORMATION
End Sub

Sub SetupDialogMenu (frm As Form)
  Dim hMenu As Integer, iResult As Integer
  hMenu = GetSystemMenu(frm.hWnd, 0)
  '
  ' Remove all but the MOVE and CLOSE options. Note that
  ' the min and max buttons are assumed to be set to
  ' false and the form's BorderStyle is assumed to be
  ' fixed double.
  '
  iResult = RemoveMenu(hMenu, 8, MF_BYPOSITION) 'Switch to
  iResult = RemoveMenu(hMenu, 7, MF_BYPOSITION) 'Separator
  iResult = RemoveMenu(hMenu, 5, MF_BYPOSITION) 'Separator
End Sub

