//-------------------------------------------------------------------
//
//	Program:		Simple state machine simulation
//	Filename:		TERMITE.H
//	Description:
//
//		This program uses state machine theory to generate
//		'termites'.  These termites move within the window
//		using their individual state tables.
//
//	Author:			Hans D. Kellner
//	Version:		1.0
//	Notes:			none
//
//-------------------------------------------------------------------

#define	IDM_OPEN		100
#define	IDM_EXIT		101
#define	IDM_ABOUT		102

#define	IDM_RESTART		200
#define	IDM_PAUSE		201
#define	IDM_INS			202
#define	IDM_DEL			203

#define	MAX_MITES	25

#define	MAX_COLORS	14

#define	MAX_STATES	(int)25

#define	FORWARD		0
#define	LEFT		1
#define	RIGHT		2

#define	NORTH		0
#define	SOUTH		1
#define	EAST		2
#define	WEST		3

	// Prototypes for TERMITE.C

int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL InitApplication(HANDLE);
long FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL AboutDlgWndProc(HWND, unsigned, WORD, LONG);

	// Prototypes for TERMTOOL.C

void HandleTermites(HWND);
int InitTermiteData(void);
int LoadTermiteTables(char *);
int InsertTermite(void);
int DeleteTermite(void);
int ClipTermites(void);

	// Prototypes for OPENDLG.C

HANDLE FAR PASCAL OpenDlgWndProc(HWND, unsigned, WORD, LONG);

	// Globals from TERMITE.C

extern	short	xClient, yClient;

	// Globals from TERMTOOL.C

extern	int pauseFlag;

