'======================================================================
' FUNGUS - FUNCTIONS (GLOBAL, UNIVERSAL & SIMPLE)
' Presented By The Not Ready For Wide Release Programmers
'
' FGB002.BAS - STRING FUNCTIONS - Version 1.01
' Compiled and Gathered From the Four Corners of Planet Earth
' By Mike DeBacker
'
' Most of these routines were written and tested in QBX PDS 7.1 and then
' tested in VB 3.0 to ensure compatibility
'
' PURPOSE: I get a little tired of doing the same things over and over
' and over again.
'
' OTHER FILES: For use with QBasic be sure and include the include
' FUNGUS_B.BI
' ------------------------------------------------------------------
'-------------------------------------------------------------
'Never fear VB users... VBWIN treats the following line as a comment, but
'a must for QBasic PDS and VB-DOS...
'$INCLUDE: 'FUNGUS_B.BI'

'****************************STRING FUNCTIONS******************************
' Ver. 1.00
' StrTok - This one came with QBX PDS 7.1 and is used to parse a string of
'       text and return string tokens. Works like the C strtok function.
'       See example in function header.
' SQLFmtStr - Found this one in a CIS message on the MBASIC forum.
'
' Ver. 1.01
' RanString -  Returns a string of random numbers of a length specified
'              between 4 and 10 digits
' XorCrypt$
' XorGenKey$

'-------------------------------------------------------------------
'                       C E N T E R
'Purpose: Provided a string and number of cols to be centered on
'   this function returns a centered string
'Input: String to be centered, Num of cols (chars) to be centered on
'Returns: Centered String
'-------------------------------------------------------------------
FUNCTION Center$ (text$, NumCol%)
	Ls% = LEN(text$)
	IF NumCol% < Ls% THEN NumCol% = Ls% + 2
	Ns% = INT((NumCol% - Ls%) / 2)
	Banner$ = SPACE$(Ns%) + text$ + SPACE$(Ns%)
	IF LEN(Banner$) > NumCol% THEN Banner$ = LEFT$(Banner$, LEN(Banner$) - 1)
	Center$ = Banner$
END FUNCTION

'--------------------------------------
' RanString - String of random digits from 4 to 10 characters
' Input: Number of digits (characters)
' Returns: A string of random numbers of a length specified between 4 and
' 10 digits
'--------------------------------------
FUNCTION RanString$ (nDigits AS INTEGER)
DIM nStart AS LONG
DIM nStop AS LONG
DIM nRanNum AS LONG
DIM nRanNum2 AS LONG
DIM RetStr AS STRING

	RANDOMIZE TIMER
	IF nDigits < 4 OR nDigits > 10 THEN
		RanString$ = "0"
		EXIT FUNCTION
	END IF
	SELECT CASE nDigits
		CASE 4:
			nStart = 1111
			nStop = 9999
		CASE 5:
			nStart = 11111
			nStop = 99999
		CASE 6:
			nStart = 111111
			nStop = 999999
		CASE 7:
			nStart = 1111111
			nStop = 9999999
		CASE 8:
			nStart = 11111111
			nStop = 99999999
		CASE 9:
			nStart = 111111111
			nStop = 999999999
		CASE 10:
			nStart = 11111
			nStop = 99999
	END SELECT
	nRanNum = ((nStop - nStart + 1) * RND) + nStart
	IF nDigits = 10 THEN
		nRanNum2 = ((nStop - nStart + 1) * RND) + nStart
	END IF
	RetStr = LTRIM$(RTRIM$(STR$(nRanNum)))
	IF nDigits = 10 THEN
		RetStr = RetStr + LTRIM$(RTRIM$(STR$(nRanNum2)))
	END IF
	RanString$ = RetStr
END FUNCTION

'--------------------------------------
'SQLFmtStr - Re-format String for Use in SQL statement
'Purpose:
'Input: String to be re-formatted
'Returns: formatted string
'--------------------------------------
FUNCTION SQLFmtStr$ (s AS STRING)
DIM n AS INTEGER
DIM nPos AS INTEGER
DIM s1 AS STRING

s1 = s
'
' This is to handle the case of embedded '
'
nPos = 1
n = 1
DO WHILE n <> 0
	n = INSTR(nPos, s1, "'")
	IF (n > 0) THEN
	s1 = MID$(s1, 1, n) + MID$(s1, n)
	nPos = n + 2
	END IF
LOOP
	

	IF LEN(s1) > 0 THEN
	SQLFmtStr$ = "'" + s1 + "'"
	ELSE
	SQLFmtStr$ = "NULL"
	END IF
END FUNCTION

'===================================================
' FUNCTION: STRTOK - STRING TOKENIZER
' PARAMETERS: Srce as String, Delim as string
' RETURNS: String Token
'
' PURPOSE: Example of usage is as follows
'LINE INPUT "Enter string: ", P$
' Set up the characters that separate tokens.
'Delimiters$ = " ,;:().?" + CHR$(9) + CHR$(34)
' Invoke StrTok$ with the string to tokenize.
'Token$ = StrTok$(P$, Delimiters$)
'WHILE Token$ <> ""
'   PRINT Token$
'   ' Call StrTok$ with a null string so it knows this
'   ' isn't the first call.
'   Token$ = StrTok$("", Delimiters$)
'WEND
'
'===================================================
FUNCTION StrTok$ (Srce AS STRING, Delim AS STRING)
STATIC Start AS INTEGER, SaveStr AS STRING
DIM BegPos, Ln, EndPos AS INTEGER

   ' If first call, make a copy of the string.
   IF Srce <> "" THEN
	  Start = 1: SaveStr = Srce
   END IF

   BegPos = Start: Ln = LEN(SaveStr)
   ' Look for start of a token (character that isn't delimiter).
   WHILE BegPos <= Ln AND INSTR(Delim, MID$(SaveStr, BegPos, 1)) <> 0
	  BegPos = BegPos + 1
   WEND
   ' Test for token start found.
   IF BegPos > Ln THEN
	  StrTok$ = "": EXIT FUNCTION
   END IF
   ' Find the end of the token.
   EndPos = BegPos
   WHILE EndPos <= Ln AND INSTR(Delim, MID$(SaveStr, EndPos, 1)) = 0
	  EndPos = EndPos + 1
   WEND
   StrTok$ = MID$(SaveStr, BegPos, EndPos - BegPos)
   ' Set starting point for search for next token.
   Start = EndPos

END FUNCTION

'======================================================================
' Ed.- The following function is a welcomed import from a "cousin" of
' mine.
'
' CRYPT10.BAS - Version 1.0
'       XorCrypt$
'       XorGenKey$
'
' Written by    De Backer Wouter
'               Groenstraat 33
'               B-2547 LINT
'               Belgium
'               CIS: 100270,2625
'======================================================================
FUNCTION XorCrypt$ (enctext AS STRING, enckey AS STRING)

	'----------------------------------------------------------------------
	' NAME:     XorCrypt$
	'
	' PURPOSE:  Encrypt or decrypt a given text using the XOR method
	'
	' INPUT:    enctext : the text to be encrypted/decrypted
	'           enckey  : the key for the encryption/decryption
	'
	' OUTPUT:   none
	'
	' RETURNS:  the encrypted/decrypted text
	'
	' NOTES:    This is one of the simpliest encryption/decryption methods.
	'           It is relatively easy to break it.  Nevertheless it helps
	'           against the prying eyes of those that have no idea how
	'           encryption works.
	'
	' USAGE:    - Create a key with XorGenKey$.
	'           - Feed that key and a legable text to XorCrypt$.
	'             The result is the encrypted text.
	'           - Feed the same key and the encrypted text to XorCrypt$.
	'             The result is the decrypted text.
	'           - The key and the text don't have to be of equal length.
	'             If the text is longer than the key, then the key is used
	'             over and over again until the text is fully encrypted/
	'             decrypted.
	'----------------------------------------------------------------------

	text$ = ""
	textlength% = LEN(enctext)
	keylength% = LEN(enckey)

	encpos% = 1
	FOR i% = 1 TO textlength%
		text$ = text$ + CHR$(ASC(MID$(enctext, i%, 1)) XOR ASC(MID$(enckey, encpos%, 1)))
		encpos% = encpos% + 1
		IF encpos% > keylength% THEN encpos% = 1
	NEXT
	
	XorCrypt$ = text$

END FUNCTION

'======================================================================
' Ed.- The following function is a welcomed import from a "cousin" of
' mine.
'
' CRYPT10.BAS - Version 1.0
'       XorCrypt$
'       XorGenKey$
'
' Written by    De Backer Wouter
'               Groenstraat 33
'               B-2547 LINT
'               Belgium
'               CIS: 100270,2625
'======================================================================
FUNCTION XorGenKey$ (genlength AS INTEGER)

	'----------------------------------------------------------------------
	' NAME:     XorGenKey$
	'
	' PURPOSE:  Generate a key for the XOR encryption/decryption method.
	'
	' INPUT:    genlength : the desired length of the resulting key
	'
	' OUTPUT:   None
	'
	' RETURNS:  The generated key as a string.
	'
	' NOTES:    Make sure you generate exactly the same key in each program
	'           that manipulates the same data.
	'----------------------------------------------------------------------
	
	RANDOMIZE 24031954      'Use any long or short integer that suits you.
							'This one 'happens' to be my birthday.

	'The longer the generated key, the better.
	'However, a key of length 1 is useless.
	'On the other hand, some Basic versions won't accept strings longer
	'than 255 characters.  So, ...

	IF genlength < 1 OR genlength > 255 THEN genlength = 100
	
	key$ = ""
	FOR i% = 1 TO genlength
		key$ = key$ + CHR$(INT(256 * RND))
	NEXT
	
	XorGenKey$ = key$

END FUNCTION

