'======================================================================
' FUNGUS - FUNCTIONS (GLOBAL, UNIVERSAL & SIMPLE)
' Presented By The Not Ready For Wide Release Programmers
'
' FGB002a.BAS - STRING FUNCTIONS - Version 1.0
' Compiled and Gathered From the Four Corners of Planet Earth
' By Mike DeBacker
'
' Most of these routines were written and tested in QBX PDS 7.1 and then
' tested in VB 3.0 to ensure compatibility
'
' PURPOSE: I get a little tired of doing the same things over and over
' and over again.
'
' OTHER FILES: For use with QBasic be sure and include the include
' FUNGUS_B.BI
' ------------------------------------------------------------------
'-------------------------------------------------------------
'Never fear VB users... VB treats the following line as a comment, but
'a must for QBasic PDS and VB-DOS...
'$INCLUDE: 'FUNGUS_B.BI'

'----------------------------------------------------------------------
' NAME:     StripCRLF$(..)
' PURPOSE:  Strips CR (ASCII 13) and LF (ASCII 10) from string
'           and replaces them with 1 space each
' INPUT:    sChars - String of chars as string
' OUPUT:    None
' RETURNS:  New String
' NOTES:
'----------------------------------------------------------------------
FUNCTION StripCRLF$ (sChars AS STRING)
DIM numChar AS INTEGER
DIM tmpStr AS STRING

	tmpStr = sChars
	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, CHR$(13)) <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, CHR$(13)), 1) = " "
	WEND

	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, CHR$(10)) <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, CHR$(10)), 1) = " "
	WEND

	StripCRLF$ = tmpStr

END FUNCTION

'----------------------------------------------------------------------
' NAME:     StripCurrency$(..)
' PURPOSE:  Strips as standard currency string, such as "$(30,000.25)".
'           Removes commas and replaces with a space
'           Removes $ and replaces with a space
'           Removes ( and replaces with -
'           Removes ) and replaces with a space
'           The resultant string, such as " -30 000.25 "
'           would translate with the VAL(..) function to -30000.25
'           This is useful when translating text files of mainframe reports.
' INPUT:    sChars - String of chars as string
' OUPUT:    None
' RETURNS:  New String
' NOTES:
'----------------------------------------------------------------------
FUNCTION StripCurrency$ (sChars AS STRING)
DIM numChar AS INTEGER
DIM tmpStr AS STRING

	tmpStr = sChars

	'strip off commas
	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, ",") <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, ","), 1) = " "
	WEND

	'strip off $
	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, "$") <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, "$"), 1) = " "
	WEND
	
	'strip off ( and replace w/ -
	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, "(") <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, "("), 1) = "-"
	WEND

	'strip off )
	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, ")") <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, ")"), 1) = " "
	WEND

	StripCurrency$ = tmpStr

END FUNCTION

'----------------------------------------------------------------------
' NAME:     StripNull$(..)
' PURPOSE:  Strips NULL (ASCII 0)
'           and replaces them with 1 space each
' INPUT:    sChars - String of chars as string
' OUPUT:    None
' RETURNS:  New String
' NOTES:
'----------------------------------------------------------------------
FUNCTION StripNull$ (sChars AS STRING)
DIM numChar AS INTEGER
DIM tmpStr AS STRING

	tmpStr = sChars

	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, CHR$(0)) <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, CHR$(9)), 1) = " "
	WEND

	StripNull$ = tmpStr

END FUNCTION

'----------------------------------------------------------------------
' NAME:     StripTab$(..)
' PURPOSE:  Strips TAB (ASCII 9)
'           and replaces them with 1 space each
' INPUT:    sChars - String of chars as string
' OUPUT:    None
' RETURNS:  New String
' NOTES:
'----------------------------------------------------------------------
FUNCTION StripTab$ (sChars AS STRING)
DIM numChar AS INTEGER
DIM tmpStr AS STRING

	tmpStr = sChars

	numChar = LEN(tmpStr)
	WHILE (INSTR(1, tmpStr, CHR$(9)) <> 0)
		MID$(tmpStr, INSTR(1, tmpStr, CHR$(9)), 1) = " "
	WEND

	StripTab$ = tmpStr

END FUNCTION

