'======================================================================
' FUNGUS - FUNCTIONS (GLOBAL, UNIVERSAL & SIMPLE)
' Presented By The Not Ready For Wide Release Programmers
'
' FGB004.BAS - Mathematical Functions - Version 2.00
' Compiled and Gathered From the Four Corners of Planet Earth
' By Mike DeBacker
'
' Most of these routines were written and tested in QBX PDS 7.1 and then
' tested in VB 3.0 to ensure compatibility
'
' PURPOSE: I get a little tired of doing the same things over and over
' and over again. ("Hey, I need a new battery")
'
' OTHER FILES: For use with QBasic be sure and include the include
' FUNGUS_B.BI
' ------------------------------------------------------------------
'-------------------------------------------------------------
'Never fear VB users... VB treats the following line as a comment, but
'a must for QBasic PDS and VB-DOS...
'$INCLUDE: 'FUNGUS_B.BI'


'LIST OF DERIVED TRIGNOMETRIC FUNCTIONS INCLUDED IN THIS FILE
'Secant  Sec(snx) = 1 / Cos(snx)
'Cosecant    Cosec(snx) = 1 / Sin(snx)
'Cotangent   Cotan((snx) = 1 / Tan(snx)
'Inverse Sine    Arcsin(snx) = Atn(snx / Sqr(-snx * snx + 1))
'Inverse Cosine  Arccos(snx) = Atn(-snx / Sqr(-snx * snx + 1)) + 1.5708
'Inverse Secant  Arcsec(snx) = Atn(snx / Sqr(snx * snx - 1)) + Sgn(Sgn(snx) -1) * 1.5708
'Inverse Cosecant    Arccosec(snx) = Atn(snx/Sqr(snx * snx - 1)) + (Sgn(snx) - 1) * 1.5708
'Inverse Cotangent   Arccotan(snx) = Atn(snx) + 1.5708
'Hyperbolic Sine HSin(snx) = (Exp(snx) - Exp(-snx)) / 2
'Hyperbolic Cosine   HCos(snx) = (Exp(snx) + Exp(-snx)) / 2
'Hyperbolic Tangent  HTan(snx) = (Exp(snx) - Exp(-snx)) / (Exp(snx) + Exp(-snx))
'Hyperbolic Secant   HSec(snx) = 2 / (Exp(snx) + Exp(-snx))
'Hyperbolic Cosecant HCosec(snx) = 2 / (Exp(snx) - Exp(-snx))
'Hyperbolic Cotangent    HCotan(snx) = (Exp(snx) + Exp(-snx)) / (Exp(snx) - Exp(-snx))
'Inverse Hyperbolic Sine HArcsin(snx) = Log(snx + Sqr(snx * snx + 1))
'Inverse Hyperbolic Cosine   HArccos(snx) = Log(snx + Sqr(snx * snx - 1))
'Inverse Hyperbolic Tangent  HArctan(snx) = Log((1 + snx) / (1 - snx)) / 2
'Inverse Hyperbolic Secant   HArcsec(snx) = Log((Sqr(-snx * snx + 1) + 1) / snx)
'Inverse Hyperbolic Cosecant HArccosec(snx) = Log((Sgn(snx) * Sqr(snx * snx + 1) +1) / snx)
'Inverse Hyperbolic Cotangent    HArccotan(snx) = Log((snx + 1) / (snx - 1)) / 2
'Logarithm   LogN(snx) = Log(snx) / Log(N)

FUNCTION Arccos! (snx AS SINGLE)
	Arccos! = ATN(-snx / SQR(-snx * snx + 1)) + 1.5708
END FUNCTION

FUNCTION Arccosec! (snx AS SINGLE)
	Arccosec! = ATN(snx / SQR(snx * snx - 1)) + (SGN(snx) - 1) * 1.5708
END FUNCTION

FUNCTION Arccotan! (snx AS SINGLE)
	Arccotan! = ATN(snx) + 1.5708
END FUNCTION

FUNCTION Arcsec! (snx AS SINGLE)
	Arcsec! = ATN(snx / SQR(snx * snx - 1)) + SGN(SGN(snx) - 1) * 1.5708
END FUNCTION

FUNCTION ArcSin! (snx AS SINGLE)
	ArcSin! = ATN(snx / SQR(-snx * snx + 1))
END FUNCTION

'--------------------------------------
'CalcFactor - Calculate Margin Factor
'Purpose: Given the margin percent as integer value
'       calculates the margin factor
'Input: margin as single
'Returns: Factor as single
'--------------------------------------
FUNCTION CalcFactor! (margin AS SINGLE)
	IF margin > 100 THEN
	BEEP
	CalcFactor! = 0
	END IF
	IF margin = 100 THEN margin = 99
	IF margin <> 0 THEN
	CalcFactor! = 100 / (100 - margin)
	ELSE
	CalcFactor! = 0
	END IF
END FUNCTION

'--------------------------------------
'CalcMargin - Calculate Margin Percent
'Purpose: Given the margin factor
'       calculates the margin percent
'Input: Factor as single
'Returns: percent as single
'--------------------------------------
FUNCTION CalcMargin! (factor AS SINGLE)
	IF factor >= 100 THEN factor = 99

	CalcMargin! = (100 - (100 / factor)) / 100
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CalcRadToDec!(..)
' PURPOSE:  Converts Radians to decimal degrees
' INPUT:    Radians as singles
' OUPUT:    None
' RETURNS:  Radians as single
' NOTES:    To convert a radian value to degrees, multiply it by 180/PI
'           (or 57.2957795130824) where PI = 3.141593.
'----------------------------------------------------------------------
FUNCTION CalcRadToDec! (snRadians AS SINGLE)
DIM snPI AS SINGLE
	snPI = 3.141593
	CalcRadToDec! = snRadians * (180 / snPI)
END FUNCTION

FUNCTION Combinations# (nElements AS LONG, rTimes AS LONG)
DIM k&, i&, t&
DIM result#
	result# = 1#
	k& = nElements - rTimes
	IF (rTimes > k&) THEN
		t& = rTimes
		rTimes = k&
		k& = t&
	END IF
	FOR i& = 1 TO rTimes
		result# = result# * nElements
		nElements = nElements - 1
		result# = result# / i&
	NEXT i&
	Combinations# = result#
END FUNCTION

'----------------------------------------------------------------------
' NAME:     CompInt
' PURPOSE:  Calculates Compound Interest S = P * (1 + i)^n
' INPUT:    snPrin = Principle as single
'           snRate = Rate as single (enter as percent; e.g. .12 not 12%)
'           nComp = Number of times per year that the interest is compounded as integer.
'           nPeriod = Number of interest periods as integer
' OUPUT:    None
' RETURNS:  Final Amount of money (principle plus interest).
'           Or returns 0 if error occurs.
' CALLS:    None
' NOTES:    The variable i used in the formula above is the periodic
'           interest rate. But the function expects the "quoted" interest
'           rate and then will calculate the periodic rate. Given the number
'           of compounding periods (i.e if it is to compounded monthly, the
'           number of periods would be 12)
'----------------------------------------------------------------------
FUNCTION CompInt! (BYVAL snPrin AS SINGLE, BYVAL snRate AS SINGLE, BYVAL nComp AS INTEGER, BYVAL nPeriod AS INTEGER)
DIM snI AS SINGLE
DIM snCI AS SINGLE
DIM nPers AS INTEGER

	IF (snPrin = 0) OR (snRate = 0) OR (nComp = 0) OR (nPeriod = 0) THEN
		CompInt! = 0
		EXIT FUNCTION
	END IF

	'calculate the periodic interest rate
	snI = 1 + (snRate / nComp)

	'calculate the compounded interest rate
	snCI = snI
	FOR nPers = 2 TO nPeriod
		snCI = snCI * snI
	NEXT nPers

	CompInt! = snPrin * snCI

END FUNCTION

FUNCTION Cosecant! (snx AS SINGLE)
	Cosecant! = 1 / SIN(snx)
END FUNCTION

FUNCTION Cotan! (snx AS SINGLE)
	Cotan! = 1 / TAN(snx)
END FUNCTION

FUNCTION Factorial# (nElements AS LONG)
	IF (nElements > 1) THEN
		Factorial# = nElements * Factorial(nElements - 1)
	ELSE
		Factorial# = 1#
	END IF
END FUNCTION

FUNCTION HArccos! (snx AS SINGLE)
	HArccos! = LOG(snx + SQR(snx * snx - 1))
END FUNCTION

FUNCTION HArccosec! (snx AS SINGLE)
	HArccosec! = LOG((SGN(snx) * SQR(snx * snx + 1) + 1) / snx)
END FUNCTION

FUNCTION HArccotan! (snx AS SINGLE)
	HArccotan! = LOG((snx + 1) / (snx - 1)) / 2
END FUNCTION

FUNCTION HArcsec! (snx AS SINGLE)
	HArcsec! = LOG((SQR(-snx * snx + 1) + 1) / snx)
END FUNCTION

FUNCTION HArcsin! (snx AS SINGLE)
	HArcsin! = LOG(snx + SQR(snx * snx + 1))
END FUNCTION

FUNCTION HArctan! (snx AS SINGLE)
	HArctan! = LOG((1 + snx) / (1 - snx)) / 2
END FUNCTION

FUNCTION HCos! (snx AS SINGLE)
	HCos! = (EXP(snx) + EXP(-snx)) / 2
END FUNCTION

FUNCTION HCosec! (snx AS SINGLE)
	HCosec! = 2 / (EXP(snx) - EXP(-snx))
END FUNCTION

FUNCTION HCotan! (snx AS SINGLE)
	HCotan! = (EXP(snx) + EXP(-snx)) / (EXP(snx) - EXP(-snx))
END FUNCTION

FUNCTION HSec! (snx AS SINGLE)
	HSec! = 2 / (EXP(snx) + EXP(-snx))
END FUNCTION

FUNCTION HSin! (snx AS SINGLE)
	HSin! = (EXP(snx) - EXP(-snx)) / 2
END FUNCTION

FUNCTION HTan! (snx AS SINGLE)
	HTan! = (EXP(snx) - EXP(-snx)) / (EXP(snx) + EXP(-snx))
END FUNCTION

FUNCTION LogTen! (X)
	LogTen! = LOG(X) / LOG(10#)
END FUNCTION

FUNCTION Permutations# (nElements AS LONG, rTimes AS LONG)
DIM i&
DIM result#

	result# = 1#
	FOR i& = (nElements - rTimes + 1) TO nElements
		result# = result# * CDBL(i&)
	NEXT i&
	Permutations# = result#
END FUNCTION

FUNCTION Secant! (snx AS SINGLE)
	Secant! = 1 / COS(snx)
END FUNCTION

'----------------------------------------------------------------------
' NAME:     SimpInt
' PURPOSE:  Calculates simple interest (I=PRT)
' INPUT:    Principle, Rate and Time as single
' OUPUT:    None
' RETURNS:  Interest
' CALLS:    None
' NOTES:    None
'----------------------------------------------------------------------
FUNCTION SimpInt! (BYVAL snPrin AS SINGLE, BYVAL snRate AS SINGLE, BYVAL snTime AS SINGLE)
	SimpInt! = snPrin * snRate * snTime
END FUNCTION

'----------------------------------------------------------------------
' NAME:     TimeToDouble
' PURPOSE:  To find how long it will take to double your money. Using the
'           the formula n=.30103 / LOG(1 + i)
' INPUT:    snRate = Rate as single (enter as percent; e.g. .12 not 12%)
'           nComp = Number of times per year that the interest is compounded as integer.
' OUPUT:    None
' RETURNS:  The number of interest periods required as an integer
'           Or returns 0 if error occurs.
' CALLS:    None
' NOTES:    The variable 'i' used in the formula above is the periodic
'           interest rate. But the function expects the "quoted" interest
'           rate and then will calculate the periodic rate. Given the number
'           of compounding periods (i.e if it is to compounded monthly, the
'           number of periods would be 12)
'----------------------------------------------------------------------
FUNCTION TimeToDouble% (BYVAL snRate AS SINGLE, BYVAL nComp AS SINGLE)
DIM snI AS SINGLE

	'calculate the periodic interest rate
	snI = 1 + (snRate / nComp)
	
	TimeToDouble% = INT(.30103 / (LogTen(snI)))
	'this is nothing
END FUNCTION

