//
//	(c) Bill Carter 1990
//
//	Demonstration of capturing DOS output in a window
//
//	Note:  puts() & printf() respect this window.
//
//      Although this routine will not window everything
//	it will place *most* DOS output in a window.
//
//	This code is provide AS IS, USE AT YOUR OWN RISK!
//
//	Written using QC/QAsm 2.51
//
//	Usable with Small,Compact,Medium,Large, and Huge memory models
//
//	Incompatible with Tiny memory model
//
//	Add DWin.Obj to your make list
//

#include <stdio.h>
#include <stdlib.h>
#include <graph.h>
#include <conio.h>

#define CLEARWIN        1
#define LEAVEWIN	0

//	DosWinInit returns 0 if it fails
//			   1 if it succeeds
//
//	It can fail for the following reasons
//
//		#1.  DosWinInit is already active
//		#2.  Window dimensions are incorrect
//			(assumes screen is 25 X 80)
//

extern _far DosWinInit(char UpperRow,char LeftColumn, char LowerRow,
	char RightColumn,int ClearWindowFlag) ;

//      DosWinRel returns 0 if it fails
//			  1 if it succeeds
//
//	Fails only if DosWinInit is not active.
//

extern _far DosWinRel(void);

void SetWindow( char tr, char lc, char br, char rc );
void prepare(void);

void main( void )
	{
	int cnt;
	_clearscreen( _GCLEARSCREEN ) ;

	_settextposition( 8,20);
	puts( "DOS DIR in a window");
	SetWindow( 9,4,21,51);
	system( "Dir" ) ;
	DosWinRel();
	prepare();

	_settextposition(3,20);
	puts( "DOS TYPE in a larger window");
	SetWindow(4,4,21,71);
	system( "TYPE testwin.c");
	DosWinRel();
	prepare();

	_settextposition(3,7);
	puts( "COMMAND.COM in a window.  Type EXIT to return to this demo." ) ;
	SetWindow(10,1,20,79);
	system( "COMMAND");
	DosWinRel();
	prepare();
	exit(0);
	}

// Setup window

void SetWindow( char tr, char lc, char br, char rc )
	{
	int cnt;
	_settextposition( tr, lc);
	putch( '' ) ;
	_settextposition( tr, rc);
	putch( '' ) ;
	_settextposition( br, lc);
	putch( '' ) ;
	_settextposition( br, rc);
	putch( '' );
	for ( cnt = tr+1; cnt < br; cnt++)
		{
		_settextposition( cnt,lc);
		putch( '' );
		_settextposition( cnt,rc);
                putch( '' );
		}
	for ( cnt = lc+1; cnt < rc ; cnt++)
		{
		_settextposition( tr,cnt);
		putch( '');
		_settextposition( br,cnt);
                putch( '');
		}
	if ( !DosWinInit( ++tr, ++lc, --br, --rc, CLEARWIN))
		{
		puts( "Error initializing window." ) ;
		exit(-1);
		}
	}

void prepare(void)
	{
	_settextposition( 24,1);
	printf( "press any key.");
	getch();
	_clearscreen( _GCLEARSCREEN);
	}
