{***************************************************************************}
{                                                                           }
{                Borland Pascal 7.0 Toolbar Demo enhancements               }
{                  Enhancements by R N Kelly. (100517,1106)                 }
{                              (c) 1993, 94                                 }
{                                                                           }
{                                Version 1.2                                }
{                                                                           }
{                                                                           }
{START OF MODIFICATIONS                                                     }
{                                                                           }
{ Mods:0.10 9th September, 1993                                             }
{      This modification provides tool bar buttons with different status    }
{      indications. A collection of buttons performing similar tasks are    }
{      known by their button group. Their particular action is defined by   }
{      their status or class.                                               }
{                                                                           }
{      ToolbarData in the TOOLBAR resource file needs to be modified to take}
{      into account the button class and button group status. The various   }
{      button classes are defined as follows:-                              }
{                                                                           }
{                                                                           }
{      ButtonClass_00: Used only with ToolSpacer. See below for info.       }
{                                                                           }
{      ButtonClass_01: This is a momentary push button as per the original  }
{                      design of the Toolbar Unit. When this button is      }
{                      pushed it appears to pop in then pop back out again  }
{                      when the mouse button is released.                   }
{                                                                           }
{      ButtonClass_02: When this button is pressed it stays pressed so as to}
{                      indicate a state such as selecting a line style for  }
{                      use in a CAD program. Only one button in the button  }
{                      group may be pressed in at any one time. If another  }
{                      button of this class in the same group is pressed    }
{                      in, the currently selected button will drop out. A   }
{                      Button of this class in any one group will always    }
{                      be pressed in. When the toolbar is instantiated,     }
{                      the first button in the group is selected            }
{                      automatically.                                       }
{                                                                           }
{      ButtonClass_03: This button class is similar to class 2 except that  }
{                      any number of buttons may be pressed in for the same }
{                      group yet it is not compulsary that any buttons are  }
{                      selected. Clicking on a button that is already down  }
{                      releases the button. This can be used for picking    }
{                      text styles such as BOLD or UNDERLINE in a word      }
{                      processor program.                                   }
{                                                                           }
{                *******************************************                }
{                                                                           }
{                                                                           }
{      Function:       ButtonIsDown(BtnCommand: word): boolean; virtual;    }
{                                                                           }
{                      Because of the different classes now associated with }
{                      ButtonClass_02 and _03, it is a necessary to know the}
{                      state of the button after it has been pressed. This  }
{                      function returns TRUE if the button has been pressed }
{                      in and FALSE if it has been released. This function  }
{                      is only used for ButtonClass_03 buttons.             }
{                                                                           }
{                                                                           }
{      Function:       LastButtonSet(Group: byte): word; virtual;           }
{                                                                           }
{                      This function returns the Command ID associated with }
{                      the last button pressed of a ButtonClass_02 button.  }
{                                                                           }
{      If a number of groups of buttons are created and each group is       }
{      separated by a TOOLSPACER, the spacer should be assigned the button  }
{      class and group values to the following group and class.             }
{                                                                           }
{---------------------------------------------------------------------------}
{                                                                           }
{ Mods:0.20 05th December, 1994                                             }
{      This modification provides tool bar buttons with popup help boxes. It}
{      provides similar help hints as those in Microsoft Word for Windows.  }
{                                                                           }
{      The modification have been based from the coding released by         }
{      Mr.(assumed) M. J. Bower, however there are quite a number of changes}
{      from the original coding.                                            }
{                                                                           }
{      DESCRIPTION:    If the mouse cursor is placed over any one of the    }
{                      tool buttons for 1 second, a hint box is displayed   }
{                      informing the user of the buttons action. When the   }
{                      mouse moves off the button, the hint box disappears. }
{                                                                           }
{                      In the original coding, the hint box would be        }
{                      removed if the mouse was moved, even if it stayed    }
{                      over the button, the mouse would also flicker on and }
{                      off twice because of the way the WMTIMER was invoked.}
{                      The new coding leaves the hint box in view at all    }
{                      times while the mouse is over the button and no      }
{                      flickering will occur except when the hint window is }
{                      displayed over the cursor.                           }
{                                                                           }
{                      Another glitch in the original coding did not take   }
{                      into account the relationship between the hint and   }
{                      the maximum boundaries of the windows screen. For    }
{                      example if the display resolution was 640 x 480 and  }
{                      the button was located at 635 x 200 (screen co-ords) }
{                      the hint box would not be fully visible, this would  }
{                      also occur if the button was located at 300 x 475.   }
{                      The revised coding checks the HORZRES and VERTRES of }
{                      the display and adjusts the position of the hint box }
{                      accordingly so that it is always in full view.       }
{                                                                           }
{                      Other minor changes include using stock fonts such as}
{                      ANSI_VAR_FONT rather than creating and selecting a   }
{                      logical font into the device context. The routines to}
{                      display the text in the hint box use the LOADSTRING  }
{                      function rather than reading the entire hint strings.}
{                                                                           }
{                      There is however, a small problem with this revised  }
{                      coding in that is uses SETCAPTURE for two purposes.  }
{                      The first is used as per the original TOOLBAR demo,  }
{                      the second, because of various coding changes, uses  }
{                      it when the hint box is displayed to monitor when the}
{                      mouse moves away from the button.                    }
{                                                                           }
{                      If a hint box is currently being displayed and the   }
{                      SETCAPTURE call has been made, the user cannot press }
{                      the ALT key on it's own since the hint box holds the }
{                      current input focus. This problem has not yet been   }
{                      resolved.                                            }
{                                                                           }
{                                                                           }
{---------------------------------------------------------------------------}
{                                                                           }
{ Resource file setup                                                       }
{                                                                           }
{      The format of the TOOLBARDATA in the host programs resource file     }
{      should be as follows:-                                               }
{                                                                           }
{      HTOOLBAR_1 TOOLBARDATA LOADONCALL MOVEABLE DISCARDABLE IMPURE        }
{      BEGIN                                                                }
{       'nn nn'                                                             }
{         'bb bb ww ww cc gg ss ss'                                         }
{         'bb bb ww ww cc gg ss ss'                                         }
{         'bb bb ww ww cc gg ss ss'                                         }
{      END                                                                  }
{                                                                           }
{      where                                                                }
{            nn nn = number of buttons in resource, low byte first          }
{            bb bb = bitmap ID in resource, low byte first                  }
{            ww ww = function or procedure command ID, low byte first       }
{            cc    = button class                                           }
{            gg    = button group                                           }
{            ss ss = resource string ID                                     }
{                                                                           }
{                                                                           }
{      The following is an extract taken from NEWMFILE.RES                  }
{                                                                           }
{            HTOOLBAR_1 TOOLBARDATA LOADONCALL MOVEABLE DISCARDABLE IMPURE  }
{            BEGIN                                                          }
{              '10 00'                   /* nnnn */                         }
{              'F5 01 E6 03 01 01 01 00' /* bbbb wwww cc gg ssss */         }
{              '00 00 08 00 00 01 00 00'                                    }
{              .....                                                        }
{              '02 02 6E 00 03 03 0E 00'                                    }
{            END                                                            }
{                                                                           }
{                                                                           }
{---------------------------------------------------------------------------}
{                                                                           }
{ Mods:0.30 17th December, 1994                                             }
{      This modification changes the TIME_DELAY from when the mouse is first}
{      over the button. The initial delay setting is 1 second, however this }
{      is subsequently reduced to 175 milliseconds once a hint is displayed.}
{      This allows the user to scan across the tool buttons to checked their}
{      function without having to wait 1 second each time the mouse cursor  }
{      is moved over a button. This timer change is carried out in the      }
{      WMMouseMove method. If the mouse is not located over a tool button,  }
{      the timer delay reverts back to a 1 second wait.                     }
{                                                                           }
{                                                                           }
{---------------------------------------------------------------------------}
{                                                                           }
{ Mods:0.40 7th January, 1995                                               }
{      This modification adds a test in THelpToolBar.WMMouseMove to see if  }
{      the current application has the focus, if it does, then hints are    }
{      displayed, if not, hints are ignored.                                }
{                                                                           }
{      Original code was,                                                   }
{          if not HelpEnabled then                                          }
{            exit;                                                          }
{                                                                           }
{      New code is                                                          }
{          if not HelpEnabled or (GetActiveWindow <> Parent^.HWindow) then  }
{            exit;                                                          }
{                                                                           }
{      Thanks to Phil Corely for finding this bug.                          }
{                                                                           }
{                                                                           }
{END OF CURRENT MODIFICATIONS                                               }
{                                                                           }
{***************************************************************************}

unit HTOOLBAR;

interface

uses
      Owindows, Wintypes, objects,
      TOOLBAR {BP7 demo unit};

const
       TIMER_1      = $03E8;             { 1000 milliseconds                              }
       TIMER_2      = $00AF;             { 175 milliseconds                               }
       SPACER       = $04;               { window width & height spacer                   }
       TIMER_DELAY  : integer = TIMER_1; { delay in milliseconds before hint is displayed }
       TIMER_ID     = $01;               { timer identifier                               }
       MAX_CHARSIZE = $3C;               { Maximum of 60 chars in the help string         }
       XOFFSET      = $05;               { offset from mouse position when over button    }
       YOFFSET      = $23;               { ditto                                          }

       ButtonClass_00 = $00;
       ButtonClass_01 = $01;
       ButtonClass_02 = $02;
       ButtonClass_03 = $03;

type
      PHelpToolWindow = ^THelpToolWindow;
      THelpToolWindow = object(TWindow)
                          public
                            constructor Init(AParent: PWindowsObject; AStrResID: word);
                            destructor Done; virtual;
                            procedure Show; virtual;
                            procedure Hide; virtual;
                          private
                            StrResID : word;
                            procedure SetupWindow; virtual;
                            procedure GetWindowClass(var WndClass: TWndClass); virtual;
                            procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
                            function GetClassName: PChar; virtual;
                        end;

      PHelpToolBar   = ^THelpToolBar;
      THelpToolBar   = object(TToolbar)
                         public
                           constructor Init(AParent: PWindowsObject; AName: PChar; Orient: word; ActivateHelp: boolean);
                           destructor Done; virtual;
                           procedure EnableHelpWindows;
                           procedure DisableHelpWindows;
                           function ButtonIsDown(BtnCommand: word): boolean;
                           function LastButtonSet(Group: byte): word; virtual;
                         private
                           HelpEnabled  : boolean;
                           CurrentHelp  : PTool;
                           { NOTE: 'CreateTool' must not be decarled a virtual function in BP7 }
                           { demo unit                                                         }
                           function CreateTool(Num: integer; Origin: TPoint; Command: word; BitmapName: PChar;
                                    Class, Group: byte): PTool;
                           procedure ReadResource; virtual;
                           procedure WMMouseMove(var Msg: TMessage); virtual wm_First +wm_MouseMove;
                           procedure WMLButtonUp(var Msg: TMessage); virtual wm_First +wm_LButtonUp;
                           procedure WMLButtonDown(var Msg: TMessage); virtual wm_First +wm_LButtonDown;
                           procedure WMTimer(var Msg: TMessage); virtual wm_First +wm_Timer;
                       end;

      PHelpToolBtn   = ^THelpToolBtn;
      THelpToolBtn   = object(TToolButton)
                         public
                           ToolsList : PCollection;
                           constructor Init(APArent: PWindowsObject; var Tools: TCollection; X, Y: integer; ACommand: word;
                                            BitmapName: PChar; Class, Group: byte);
                           procedure ShowHelpWindow; virtual;
                           procedure HideHelpWindow; virtual;
                         private
                           HelpCaptured : boolean;
                           ButtonClass : byte;
                           CommandID   : word;
                           ButtonGroup : byte;
                           ButtonDown  : boolean;
                           ButtonSet   : boolean;
                           HelpTool    : PHelpToolWindow;
                           procedure BeginCapture(p: TPoint); virtual;
                           procedure ContinueCapture(p: TPoint); virtual;
                           function EndCapture(SendTo: HWND; p: TPoint): boolean; virtual;
                       end;


procedure RegisterHelpTools;

implementation

uses
      Win31, Winprocs, Strings, Windos; {BP7 RTL}

const
       RHelpToolBar : TStreamRec = (ObjTYpe : 12302;
                                    VmtLink : Ofs(TypeOf(THelpToolBar)^);
                                    Load    : @THelpToolBar.Load;
                                    Store   : @THelpToolBar.Store);

       RHelpToolWindow : TStreamRec = (ObjTYpe : 12303;
                                       VmtLink : Ofs(TYpeOf(THelpToolWindow)^);
                                       Load    : @THelpToolWindow.Load;
                                       Store   : @THelpToolWindow.Store);

procedure RegisterHelpTools;
  begin
    RegisterType(RHelpToolBar);
    RegisterTYpe(RHelpToolWindow)
  end;

{***************************************************************************}
{*                    THelpToolWindow object methods                       *}
{***************************************************************************}
constructor THelpToolWindow.Init(AParent: PWindowsObject; AStrResID: word);
  begin
    inherited Init(AParent, 'ToolHelp');
    Attr.Style := ws_Popup or ws_Border;
    Attr.ExStyle := Attr.ExStyle or ws_Ex_Topmost;
    StrResId := AStrResID
  end;

destructor THelpToolWindow.Done;
  begin
    inherited Done
  end;

procedure THelpToolWindow.Show;
  var
       Buf      : array[0..MAX_CHARSIZE +1] of char;
       OldFont  : HFont;
       dc       : HDC;
       Extent   : longint;
       CursorPos: TPoint;
       DCx, DCy : integer;
       r        : TRect;

  begin
    LoadString(hInstance, StrResID, Buf, MAX_CHARSIZE);
    dc := GetDC(hWindow);
    Oldfont := SelectObject(dc, GetStockObject(ANSI_VAR_FONT));
    Extent := GetTextExtent(dc, Buf, StrLen(Buf));
    SelectObject(dc, OldFont);
    DCx := GetDeviceCaps(dc, HORZRES);
    DCy := GetDeviceCaps(dc, VERTRES);
    ReleaseDC(hWindow, dc);
    GetCursorPos(CursorPos);
    GetWindowRect(Parent^.hWindow, r);
    Attr.W := LOWORD(Extent) +Spacer +1;
    Attr.H := HIWORD(Extent) +Spacer +1;
    if CursorPos.X +Attr.W +XOffset > DCx -1 then
      Attr.X := DCx -Attr.W -XOffset
    else
      Attr.X := CursorPos.X +XOffset;
    if CursorPos.Y +YOffset +Attr.H > DCy -1 then
      Attr.Y := R.Top -(Attr.H *3) div 2
    else
      Attr.Y := CursorPos.Y +YOffset -Attr.H;
    MoveWindow(hWindow, Attr.X, Attr.Y, Attr.W, Attr.H, false);
    ShowWindow(hWindow, SW_SHOWNA)
  end;

procedure THelpToolWindow.Hide;
  begin
    ShowWindow(hWindow, SW_HIDE)
  end;

procedure THelpToolWindow.SetupWindow;
  begin
    inherited SetupWindow
  end;

procedure THelpToolWindow.GetWindowClass(var WndClass: TWndClass);
  begin
    inherited GetWindowClass(WndClass);
    WndClass.HBrBackground := CreateSolidBrush(RGB($FF, $FF, $00))
  end;

procedure THelpToolWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
  var
       OldFont : HFont;
       OffSet  : integer;
       Buf     : array[0..MAX_CHARSIZE +1] of char;

  begin
    Offset := SPACER div 4;
    LoadString(hInstance, StrResID, Buf, MAX_CHARSIZE);
    Oldfont := SelectObject(PaintDC, GetStockObject(ANSI_VAR_FONT));
    SetBkMode(PaintDC, TRANSPARENT);
    TextOut(PaintDC, Offset, Offset, Buf, StrLen(Buf));
    SelectObject(PaintDC, OldFont)
  end;

function THelpToolWindow.GetClassName: PChar;
  begin
    GetClassName := 'ToolHelp'
  end;

{***************************************************************************}
{*                       THelpToolBar object methods                       *}
{***************************************************************************}
constructor THelpToolBar.Init(AParent: PWindowsObject; AName: PChar; Orient: word; ActivateHelp: boolean);
  begin
    inherited Init(AParent, AName, Orient);
    HelpEnabled := ActivateHelp;
    CurrentHelp := nil
  end;

destructor THelpToolBar.Done;
  begin
    inherited Done
  end;

procedure THelpToolBar.EnableHelpWindows;
  begin
    HelpEnabled := TRUE
  end;

procedure THelpToolBar.DisableHelpWindows;
  begin
    HelpEnabled := FALSE
  end;

function THelpToolBar.ButtonIsDown(BtnCommand: word): boolean;
  var
       Button : PHelpToolBtn;

  function FindCommandID(Item: PHelpToolBtn): boolean; far;
    begin
      FindCommandID := Item^.CommandID = BtnCommand
    end;

  begin
    Button := Tools.FirstThat(@FindCommandID);
    ButtonIsDown := Button^.ButtonDown
  end;

function THelpToolBar.LastButtonSet(Group: byte): word;
  var
       Button : PHelpToolBtn;

  function FindButton(Item: PHelpToolBtn): boolean; far;
    begin
      FindButton:= (Item^.ButtonGroup = Group) and Item^.ButtonSet
    end;

  begin
    LastButtonSet := 0;
    Button := Tools.FirstThat(@FindButton);
    if Button = nil then
      exit;
    LastButtonSet := Button^.CommandID;
    Button^.ButtonSet := FALSE
  end;

function THelpToolBar.CreateTool(Num: integer; Origin: TPoint; Command: word; BitmapName: PChar;
                                 Class, Group: byte): PTool;
  begin
    if word(BitmapName) = 0 then
      CreateTool := new(PToolSpacer, Init(@Self, Command))
    else
      CreateTool := new(PHelpToolBtn, Init(@Self, Tools, Origin.X, Origin.Y, Command, BitmapName, Class, Group));
  end;

procedure THelpToolBar.ReadResource;
  type
        ResRec    = record
                      Bitmap  : word;
                      Command : word;
                      Class   : byte;
                      Group   : byte;
                      HelpID  : word
                    end;

        PResArray = ^TResArray;
        TResArray = array[$0001..$FFF0 div sizeof(ResRec)] of ResRec;

  var
       ResIdHandle   : THandle;
       ResDataHandle : THandle;
       ResDataPtr    : PResArray;
       Count         : word;
       x             : word;
       Origin        : TPoint;
       BitInfo       : TBitmap;
       p             : PTool;
       j, TheGroup   : byte;

  begin
    ResIdHandle   := FindResource(hInstance, ResName, 'TOOLBARDATA');
    ResDataHandle := LoadResource(hInstance, ResIdHandle);
    ResDataPtr    := LockResource(ResDataHandle);
    if (ResIdHandle = 0) or (ResDataHandle = 0) or (ResDataPtr = nil) then
    begin
      Status := em_InvalidChild;
      exit
    end;
    Origin.X := 2;
    Origin.Y := 2;
    Count := PWord(ResDataPtr)^;
    inc(longint(ResDataPtr), sizeof(Count));
    for x := 1 to Count do
      with ResDataPtr^[x] do
      begin
        p := CreateTool(x, Origin, Command, PChar(Bitmap), Class, Group);
        if p <> nil then
        begin
          if TypeOf(p^) = TypeOf(THelpToolBtn) then
            PHelpToolBtn(P)^.HelpTool := new(PHelpToolWindow, init(@self, HelpID));
          NextToolOrigin(x, Origin, p);
          Tools.Insert(p)
        end
      end;
    UnlockResource(ResDataHandle);
    FreeResource(ResDataHandle);

    {Button class 02 must be checked since the first button of this group  }
    {must be pressed in by default. Button class 00 is a spacer & therefore}
    {is treated as though it is part of the current group. The following IF}
    {statement ensures buton segregation and defaults                      }

    j := 0;
    repeat
      P := Tools.At(j);
      if PHelpToolBtn(P)^.ButtonClass in [ButtonClass_00, ButtonClass_02] then
        begin
          if PHelpToolBtn(P)^.ButtonClass = ButtonClass_02 then
            begin
              TheGroup := PHelpToolBtn(P)^.ButtonGroup;
              PHelpToolBtn(P)^.IsPressed := TRUE;
              repeat
                inc(j);
                if j < Tools.Count then
                  P := Tools.At(j)
                else
                  P := nil
              until (P = nil) or (PHelpToolBtn(P)^.ButtonGroup <> TheGroup) or
                    not(PHelpToolBtn(P)^.ButtonClass in[ButtonClass_00, ButtonClass_02])
            end
          else
            inc(j)
        end
      else
        inc(j)
    until (P = nil) or (j >= Tools.Count)
  end;

procedure THelpToolBar.WMMouseMove(var Msg: TMessage);
  var
       OldHelp : PTool;

  function IsHit(Item: PTool): boolean; far;
    begin
      IsHit := Item^.HitTest(TPoint(Msg.lParam))
    end;

  begin
    inherited WMMouseMove(Msg);
    if not HelpEnabled or (GetActiveWindow <> Parent^.HWindow) then
      exit;
    OldHelp := Tools.FirstThat(@IsHit);
    if OldHelp = CurrentHelp then
    begin
      if OldHelp <> nil then
        TIMER_DELAY := TIMER_2;
      exit;
    end;
    KillTimer(hWindow, TIMER_ID);
    if CurrentHelp <> nil then
      PHelpToolBtn(CurrentHelp)^.HideHelpWindow;
    CurrentHelp := OldHelp;
    if CurrentHelp <> nil then
      SetTimer(hWindow, TIMER_ID, TIMER_DELAY, nil)
    else
      TIMER_DELAY := TIMER_1
  end;

procedure THelpToolBar.WMLButtonUp(var Msg: TMessage);
  begin
    if CurrentHelp <> nil then
      PHelpToolBtn(CurrentHelp)^.HideHelpWindow;
    KillTimer(hWindow, TIMER_ID);
    CurrentHelp := nil;
    TIMER_DELAY := TIMER_1;
    inherited WMLButtonUp(Msg)
  end;

procedure THelpToolBar.WMLButtonDown(var Msg: TMessage);
  var
       Ok        : boolean;
       TheButton : PHelpToolBtn;

  function IsHit(Item: PTool): boolean; far;
    begin
      IsHit := Item^.HitTest(TPoint(Msg.lParam))
    end;

  begin
    Capture := Tools.FirstThat(@IsHit);
    if Capture <> nil then
    begin
      TheButton := PHelpToolBtn(Capture);
      if TheButton^.ButtonClass = ButtonClass_02 then
      begin
        Ok := (TheButton^.HitTest(TPoint(Msg.lParam)) and (not TheButton^.IsPressed));
        if not Ok then
        begin
          Capture := nil;
          exit
        end
      end;
      Capture^.BeginCapture(TPoint(Msg.lParam))
    end
  end;

procedure THelpToolBar.WMTimer(var Msg: TMessage);
  var
       OldHelp : PTool;
       Mouse   : TPoint;

  function IsHit(Item: PTool): boolean; far;
    begin
      IsHit := Item^.HitTest(Mouse)
    end;

  begin
    if Msg.wParam = TIMER_ID then
    begin
      KillTimer(hWindow, TIMER_ID);
      GetCursorPos(Mouse);
      ScreenToClient(hWindow, Mouse);
      OldHelp := Tools.FirstThat(@IsHit);
      if OldHelp = CurrentHelp then
        PHelpToolBtn(CurrentHelp)^.ShowHelpWindow
    end
  end;


{***************************************************************************}
{*                      THelpToolBtn object methods                        *}
{***************************************************************************}
constructor THelpToolBtn.Init(APArent: PWindowsObject; var Tools: TCollection; X, Y: integer; ACommand: word;
                              BitmapName: PChar; Class, Group: byte);
  begin
    inherited Init(AParent, X, Y, ACommand, BitmapName);
    CommandID := Command;
    ButtonClass := Class;
    ButtonGroup := Group;
    ButtonDown := FALSE;
    ToolsList := @Tools;
    HelpCaptured := FALSE;
    ButtonSet := FALSE
  end;

procedure THelpToolBtn.ShowHelpWindow;
  begin
    HelpTool^.Show;
    if not Capturing then
    begin
      SetCapture(Parent^.HWindow);
      HelpCaptured := TRUE
    end
  end;

procedure THelpToolBtn.HideHelpWindow;
  begin
    HelpTool^.Hide;
    if HelpCaptured then
      ReleaseCapture;
    HelpCaptured := FALSE
  end;

procedure THelpToolBtn.BeginCapture(P: TPoint);
begin
  CapDC := GetDC(Parent^.HWindow);
  MemDC := CreateCompatibleDC(CapDC);
  if ButtonClass <> ButtonClass_03 then
    IsPressed := False;
  Capturing := True;
  if HelpCaptured then
  begin
    ReleaseCapture;
    HelpCaptured := FALSE
  end;
  SetCapture(Parent^.HWindow);
  IsPressed := ButtonDown;
  case ButtonClass of
    ButtonClass_01 : if HitTest(P) then
                       PressIn;
    ButtonClass_02 : if HitTest(P) and (not IsPressed) then
                       PressIn;
    ButtonClass_03 : If HitTest(P) then
                     begin
                       case IsPressed of
                         TRUE  : PressOut;
                         FALSE : PressIn
                       end;
                     end
  end
end;

procedure THelpToolBtn.ContinueCapture(P: TPoint);
  begin
    case ButtonClass of
      ButtonClass_01 : begin
                         if HitTest(P) then
                           PressIn
                         else
                           PressOut
                       end;
      ButtonClass_02 : case HitTest(P) of
                         FALSE: if IsPressed and (not ButtonDown) then
                                  PressOut;
                         TRUE : if not IsPressed then
                                  PressIn
                       end;
      ButtonClass_03 : case HitTest(P) of
                         FALSE: case ButtonDown of
                                  FALSE: PressOut;
                                  TRUE : PressIn
                                end;
                         TRUE : case ButtonDown of
                                  FALSE : PressIn;
                                  TRUE  : PressOut
                                end
                       end
    end
  end;

function THelpToolBtn.EndCapture(SendTo: HWND; p: TPoint): boolean;
  var
       tb : PHelpToolBtn;
       j  : integer;

  function FoundIt(Tool: PHelpToolBtn): Boolean; far;
    begin
      FoundIt := Tool^.ButtonGroup = ButtonGroup
    end;

  begin
    if HitTest(P) then
    begin
      case ButtonClass of
        ButtonClass_01 : begin
                           PressOut;
                           PostMessage(SendTo, wm_Command, Command, 0)
                         end;
        ButtonClass_02 : Begin
                           PostMessage(SendTo, wm_Command, Command, 0);
                           tb := ToolsList^.FirstThat(@FoundIt);
                           j := ToolsList^.IndexOf(tb);
                           repeat
                             tb := ToolsList^.At(j);
                             if (tb^.IsPressed) and (tb^.Command <> Command) then
                               j := ToolsList^.Count
                             else
                               inc(j)
                           until (j = ToolsList^.Count) or (tb^.ButtonClass <> ButtonClass_02);
                           tb^.CapDC := CapDC;
                           tb^.MemDC := MemDC;
                           tb^.PressOut;
                           tb^.ButtonSet := TRUE
                         end;
        ButtonClass_03 : begin
                           case ButtonDown of
                             FALSE: begin
                                      PressIn;
                                      PostMessage(SendTo, wm_Command, Command, 0)
                                    end;
                             TRUE : begin
                                      PressOut;
                                      PostMessage(SendTo, wm_Command, Command, 0)
                                    end;
                           end;
                           ButtonDown := not ButtonDown
                         end
      end
    end;

    EndCapture := True;
    ReleaseCapture;
    Capturing := False;
    DeleteDC(MemDC);
    ReleaseDC(Parent^.HWindow, CapDC);
    MemDC := 0;
    CapDC := 0;
  end;

end.