
 ' Program Name: demo.bas
 '      Version: 1.0
 '         Date: February, 1995
 '       Author: Steven H. Fisk
 '     Language: Power BASIC
 ' Requirements: Color display
 ' Distribution: This source code and it's compiled version are distributed
 '               as Freeware and are subject to the same warranties and
 '               distribution policies as outlined for DosView and Viewset
 '               on page 1 of the DosView User's Guide (see the file:
 '               DOSVIEW.DOC for details).
 '  Description: This source code was meant to be a somewhat useful
 '               demonstration of DosView V1.0. The program acts as a fancy
 '               front-end interface to the DOS prompt (COMMAND.COM). Instead
 '               of the standard scrolling screen, the user is presented with
 '               an input window from lines 21 to 23. DOS commands are
 '               entered in this window and output from those commands appear
 '               between lines 2 and 19. Line 1 acts as a time and date
 '               status bar while line 25 acts as a sub-directory status bar.
 '               Being only a demonstration, this program wasn't made to be
 '               very sophisticated, but with a little work, it could be made
 '               to employ a mouse, icons, etc.



 initialize:                            ' INITIALIZATION PROCEDURES.

     foreground=15                      ' Foreground color for screen.
     background=1                       ' Background color for screen.
     border=5                           ' Border color.
     sforeground=14                     ' Foreground color for status bars.
     sbackground=4                      ' Background color for status bars.
     service=&HFF                       ' Service code to access DosView.

     declare sub settop(topline)        ' Procedure declarations.
     declare sub setbottom(bottomline)
     declare sub pause()
     declare sub unpause()
     declare sub remove()
     declare sub clearwindow()
     declare function checkinstall()    ' Function declarations.
     declare function ikey$()
     declare function linput$(prompt$)

 main:

     setup:                             ' PROGRAM SETUP.
          open "cons:" as #1            ' Open console device for output.
          a=checkinstall                ' Was DosView installed?
          if a=0 then goto not.installed
          call pause                    ' Make sure DosView is paused.
          color foreground,background,border
          cls

     init.screen:                       ' SETUP STATUS BARS, ETC.
          def seg=&HB800                ' Point data segment towards screen.
          color sforeground,sbackground
          locate 1,1
          for x=0 to 159 step 2         ' Set color for top status bar.
               poke x,32
               poke x+1,(&H10*sbackground)+sforeground
               next x
          print " Date:                                                           Time:";
          for x=3840 to 3999 step 2     ' Set color for bottom status bar.
               poke x,32
               poke x+1,(&H10*sbackground)+sforeground
               next x
          locate 25,1
          print " Current Directory:";
          color sforeground,background
          locate 20,1
          print string$(80,220);
          def seg
          gosub update.dir
          gosub update.time

     welcome.message:
     ' This routine displays a welcome message on the screen when the
     ' demonstration is first started. Notice the four lines below that set
     ' the top and bottom lines of the DosView window. The first two lines to
     ' set the top line to 1 and the bottom line to 2 are highly recomended
     ' any time you wish to set the window's position. After doing this, you
     ' should then set the bottom line before the top. The reason being is
     ' that DosView has a built-in safety feature to make sure that the top
     ' and bottom lines are not specified backwards (eg. top line = 10,
     ' bottom line = 5 would not work). Using this method will insure that no
     ' errors occur due to the previous window position settings.

          if welcome=1 then goto dos.prompt
          call settop(1)                ' Initialize DosView window position.
          call setbottom(2)
          call setbottom(19)
          call settop(2)
          locate 19,1
          call unpause
          print#1," Welcome to the DosView Demonstration."
          print#1,""
          print#1," Type any command you wish to execute in the window below."
          print#1," Use the ";chr$(34);"EXIT";chr$(34);" command to exit this demonstration."
          print#1,""
          call pause
          welcome=1

     dos.prompt:                        ' COMMAND PROMPT.
          gosub clear.input
          locate 23,1
          call unpause
          on timer(1) gosub update.time
          timer on
          print#1,""
          if b$<>"" then print#1,b$:print#1,""
          a$=linput$(" Command: ")
          timer off
          b$=" Command: "+a$
          if a$="" then goto dos.prompt
          if ucase$(a$)="CLS" then goto clear.output
          if ucase$(a$)="EXIT" then goto demo.exit
          call pause
          call settop(1)                ' Initialize DosView window position.
          call setbottom(2)
          call setbottom(19)
          call settop(2)
          locate 19,1
          call unpause
          shell a$
          locate 19,1
          print#1,""
          call pause
          goto init.screen

     clear.input:                       ' CLEAR INPUT WINDOW.
          call pause
          call settop(1)                ' Initialize DosView window position.
          call setbottom(2)
          call setbottom(24)
          call settop(21)
          call clearwindow
          call setbottom(23)
          return

     clear.output:                      ' CLEAR OUTPUT WINDOW.
          call pause
          call settop(1)                ' Initialize DosView window position.
          call setbottom(2)
          call setbottom(19)
          call settop(2)
          call clearwindow
          goto init.screen

     demo.exit:                         ' EXIT DEMONSTRATION.
          call pause
          call remove
          cls
          print#1,""
          print#1," Goodbye!"
          close 1
          end

 not.installed:                         ' DOSVIEW NOT INSTALLED ERROR MESSAGE.
     print#1,""
     print#1,"  ERROR - DOSVIEW IS NOT INSTALLED. TYPE THE ";chr$(34);"DOSVIEW";chr$(34);" COMMAND AND THEN"
     print#1,"          RESTART THIS DEMONSTRATION."
     close 1
     end

 update.dir:                            ' SUBROUTINE TO UPDATE DIRECTORY.
     def seg=&HB800
     cd$=curdir$
     y=1
     for x=3880 to 3880+(len(cd$)*2)-1 step 2
          poke x,(asc(mid$(cd$,y,1)))
          y=y+1
          next x
     def seg
     return

 update.time:                           ' UPDATE TIME AND DATE.
     def seg=&HB800
     d$=date$
     y=1
     for x=14 to 14+(len(d$)*2)-1 step 2
          poke x,(asc(mid$(d$,y,1)))
          y=y+1
          next x
     t$=time$
     y=1
     for x=142 to 142+(len(t$)*2)-1 step 2
          poke x,(asc(mid$(t$,y,1)))
          y=y+1
          next x
     def seg
     return


 rem  IKEY$ - Return a keypress from the console using DOS Int 21h, Service 6.
 function ikey$
     reg 1,&H0600
     reg 4,&H00FF
     call interrupt &H21
     ik=reg(1)
     ik=ik-&H0600
     ik$=chr$(ik)
     if ik$=chr$(0) then ik$=""
     ikey$=ik$
     end function

 rem  LINPUT$ - Input a line of text from the console.
 function linput$(prompt$)
 l$=""
 locate ,,1

     lprompt:
          if prompt$="" then goto lloop:
          print#1,prompt$;

     lloop:
          a$=ikey$
          if a$="" then goto lloop:
          a=asc(a$)
          if a=8 or a=127 then goto backspace:
          if a=13 or a=10 then goto enter:
          if a<32 or a>126 then goto lloop:
          print#1,a$;
          l$=l$+a$
          goto lloop:

     backspace:
          if len(l$)=0 then goto lloop:
          print#1,chr$(8);" ";chr$(8);
          l$=left$(l$,len(l$)-1)
          goto lloop:

     enter:
          linput$=l$
          locate ,,0
          print#1,""
          end function


 ' DOSVIEW.BAS - A collection of procedures and functions to access the
 '               DosView TSR from Power Basic.

 ' NOTE: Some of the functions available in the DOSVIEW.BAS file were not
 '       needed in DEMO.BAS and have been removed to save space.

 sub settop(topline)                    ' SET TOP LINE OF DOSVIEW WINDOW.
 '
 ' USAGE: CALL SETTOP(LINE#)
 '
 ' Where LINE# = the top line of the window.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+1              ' DosView function 1.
     reg 1,ax
     reg 2,topline                      ' Specify top line.
     call interrupt &H21
     end sub

 sub setbottom(bottomline)              ' SET BOTTOM LINE OF DOSVIEW WINDOW.
 '
 ' USAGE: CALL SETBOTTOM(LINE#)
 '
 ' Where LINE# = the bottom line of the window.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+2              ' DosView function 2.
     reg 1,ax
     reg 2,bottomline                   ' Specify bottom line.
     call interrupt &H21
     end sub

 sub pause                              ' ACTIVATE PAUSE MODE.
 '
 ' USAGE: CALL PAUSE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+3              ' DosView function 3.
     reg 1,ax
     call interrupt &H21
     end sub

 sub unpause                            ' DEACTIVATE PAUSE MODE.
 '
 ' USAGE: CALL UNPAUSE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+4              ' DosView function 4.
     reg 1,ax
     call interrupt &H21
     end sub

 sub remove                             ' REMOVE DOSVIEW TSR FROM MEMORY.
 '
 ' USAGE: CALL REMOVE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+6              ' DosView function 6.
     reg 1,ax
     call interrupt &H21
     end sub

 sub clearwindow                        ' CLEAR DOSVIEW WINDOW.
 '
 ' USAGE: CALL CLEARWINDOW

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+8              ' DosView function 8.
     reg 1,ax
     call interrupt &H21
     end sub

 function checkinstall                  ' FIND OUT IF TSR IS INSTALLED.
 '
 ' USAGE X=CHECKINSTALL
 '
 ' X will equal 1 if TSR is installed and 0 if not.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+7              ' DosView function 7.
     reg 1,ax
     call interrupt &H21
     checkinstall=0
     bx=reg(2)
     if bx=&HABCD then checkinstall=1
     end function

