
 ' Program Name: dosview.bas
 '      Version: 1.0
 '         Date: February, 1995
 '       Author: Steven H. Fisk
 '     Language: Power BASIC
 ' Distribution: This source code and it's compiled version are distributed
 '               as Freeware and are subject to the same warranties and
 '               distribution policies as outlined for DosView and Viewset
 '               on page 1 of the DosView User's Guide (see the file:
 '               DOSVIEW.DOC for details).

 initialize:                            ' INITIALIZATION PROCEDURES.
     service=&HFF                       ' Service code to access DosView.
     declare sub settop(topline)        ' Procedure declarations.
     declare sub setbottom(bottomline)
     declare sub pause()
     declare sub unpause()
     declare sub remove()
     declare sub clearwindow()
     declare function topln()           ' Function declarations.
     declare function bottomln()
     declare function getservice()
     declare function getpause()
     declare function checkinstall()

 main:
     ' * PUT YOUR PROGRAM HERE *


 ' DOSVIEW.BAS - A collection of procedures and functions to access the
 '               DosView TSR from Power Basic.

 sub settop(topline)                    ' SET TOP LINE OF DOSVIEW WINDOW.
 '
 ' USAGE: CALL SETTOP(LINE#)
 '
 ' Where LINE# = the top line of the window.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+1              ' DosView function 1.
     reg 1,ax
     reg 2,topline                      ' Specify top line.
     call interrupt &H21
     end sub

 sub setbottom(bottomline)              ' SET BOTTOM LINE OF DOSVIEW WINDOW.
 '
 ' USAGE: CALL SETBOTTOM(LINE#)
 '
 ' Where LINE# = the bottom line of the window.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+2              ' DosView function 2.
     reg 1,ax
     reg 2,bottomline                   ' Specify bottom line.
     call interrupt &H21
     end sub

 sub pause                              ' ACTIVATE PAUSE MODE.
 '
 ' USAGE: CALL PAUSE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+3              ' DosView function 3.
     reg 1,ax
     call interrupt &H21
     end sub

 sub unpause                            ' DEACTIVATE PAUSE MODE.
 '
 ' USAGE: CALL UNPAUSE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+4              ' DosView function 4.
     reg 1,ax
     call interrupt &H21
     end sub

 sub remove                             ' REMOVE DOSVIEW TSR FROM MEMORY.
 '
 ' USAGE: CALL REMOVE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+6              ' DosView function 6.
     reg 1,ax
     call interrupt &H21
     end sub

 sub clearwindow                        ' CLEAR DOSVIEW WINDOW.
 '
 ' USAGE: CALL CLEARWINDOW

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+8              ' DosView function 8.
     reg 1,ax
     call interrupt &H21
     end sub

 function topln                         ' GET TOP LINE OF WINDOW.
 '
 ' USAGE: X=TOPLN

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+5              ' DosView function 5.
     reg 1,ax
     call interrupt &H21
     ax=reg(1)                          ' Get register AX.
     ah=ax or &H00FF                    ' Get register AH.
     ah=ah-&H00FF
     ah=ah/&H0100
     topln=ah
     end function

 function bottomln                      ' GET BOTTOM LINE OF WINDOW.
 '
 ' USAGE: X=BOTTOMLN

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+5              ' DosView function 5.
     reg 1,ax
     call interrupt &H21
     ax=reg(1)                          ' Get register AX.
     al=ax or &HFF00                    ' Get register AL.
     al=al-&HFF00
     bottomln=al
     end function

 function getservice                    ' GET INTERRUPT SERVICE FUNCTION.
 '
 ' USAGE: X=GETSERVICE

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+5              ' DosView function 5.
     reg 1,ax
     call interrupt &H21
     bx=reg(2)                          ' Get register BX.
     bl=bx or &HFF00                    ' Get register BL.
     bl=bl-&HFF00
     getservice=bl
     end function

 function getpause                      ' GET PAUSE STATUS.
 '
 ' USAGE: X=GETPAUSE
 '
 ' X will equal 0 if paused and 1 if not.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+5              ' DosView function 5.
     reg 1,ax
     call interrupt &H21
     cx=reg(3)                          ' Get register CX.
     cl=cx or &HFF00                    ' Get register CL.
     cl=cl-&HFF00
     getpause=cl
     end function

 function checkinstall                  ' FIND OUT IF TSR IS INSTALLED.
 '
 ' USAGE X=CHECKINSTALL
 '
 ' X will equal 1 if TSR is installed and 0 if not.

     shared service                     ' Declare service variable shared.
     ax=(&H0100*service)+7              ' DosView function 7.
     reg 1,ax
     call interrupt &H21
     checkinstall=0
     bx=reg(2)
     if bx=&HABCD then checkinstall=1
     end function

