
 ; Program Name: ViewSet
 ;      Version: 1.0
 ;         Date: January, 1995
 ;       Author: Steven H. Fisk
 ; Distribution: See page 1 of the DOSVIEW.DOC file for warranty and
 ;               distribution policies.
 ;  Description: A utility to alter the interrupt service code of DosView.


 ; Initialize.

        .MODEL  TINY
        ORG     100h


 ; Code Segment.

        .CODE

 ; Macros

        print   macro                   ; PRINT - Print string (CR).
                mov     ah,9h
                mov     dx,offset #1
                int     21h
                #em

        cr      macro                   ; CR - Move cursor down a line.
                mov     ah,6h
                mov     dl,0dh
                int     21h
                mov     ah,6h
                mov     dl,0ah
                int     21h
                #em

        bye     macro                   ; BYE - Exit program.
                mov     ah,4ch
                mov     al,0h
                int     21h
                #em


 ; Main Program

 start:

 display_header:                        ; DISPLAY WELCOME MESSAGE.
        cr
        print   welcome
        cr

 get_params:                            ; GET COMMAND LINE PARAMETERS.
        mov     si,82h                  ; Source first byte of params.
        mov     di,offset params        ; Destination variable.
        mov     cx,0                    ; Clear length register.
        mov     cl,[80h]                ; Put param length into CL.
        rep     movsb                   ; Move parameters to variable.
        dec     di                      ; Remove garbage character.

 exist_params:                          ; WERE PARAMETERS GIVEN?
        cmp     b[offset params],0      ; Do params exist?
        jne     remove_space
        jmp     usage

 remove_space:                          ; REMOVE SPACES ON END OF PARAM.
        dec     di                      ; Decrement parameter size.
        cmp     b[di],20h               ; Is the last character a space?
        je      remove_space
        inc     di                      ; Get ready for end-of-variable.
        mov     al,0                    ; Select end-of-variable char.
        stosb                           ; Append end-of-variable char.

 hextobyte:                             ; CONVERT HEX STRING TO BYTE.

 hextobyte_1:
        mov     al,[params]             ; Get first byte of string address.
        sub     al,30h                  ; Subtract 48 to get true value.
        cmp     al,9h                   ; Is the value less than/equal to 9?
        jle     hextobyte_2
        sub     al,7h                   ; Subtract 7 to get true value.
        cmp     al,0fh                  ; Is the value less than/equal to 15?
        jle     hextobyte_2
        sub     al,20h                  ; Subtract 32 to get true value.

 hextobyte_2:
        mov     bl,10h                  ; BL = 10h.
        mul     bl                      ; Multiply first byte by 10h.
        mov     ah,[params+1]           ; Get second byte of string address.
        sub     ah,30h                  ; Subtract 48 to get true value.
        cmp     ah,9h                   ; Is the value less than/equal to 9?
        jle     hextobyte_3
        sub     ah,7h                   ; Subtract 7 to get true value.
        cmp     ah,0fh                  ; Is the value less than/equal to 15?
        jle     hextobyte_3
        sub     al,20h                  ; Subtract 32 to get true value.

 hextobyte_3:
        add     al,ah                   ; Add the first and second bytes.
        mov     [service_code],al       ; Save converted address.

 rename_file:                           ; RENAME DOSVIEW.COM TO DOSVIEW.OLD.
        mov     ah,56h                  ; Choose DOS service 56h (rename file).
        mov     ds,cs                   ; Segment of old file name.
        mov     dx,offset new_file      ; Offset of old file name.
        mov     es,cs                   ; Segment of new file name.
        mov     di,offset old_file      ; Offset of new file name.
        int     21h
        jc      rename_error            ; Jump if an error occurred.
        jmp     open_files

 rename_error:                          ; ERROR MESSAGE USED IF RENAME FAILS.
        print   rename_msg
        cr
        jmp     end_program

 open_files:                            ; OPEN FILES FOR READ/WRITE.
        mov     ah,3dh                  ; Choose DOS service 3Dh (open file).
        mov     al,11000000b            ; Open for read access.
        mov     ds,cs                   ; Set segment of old file name.
        mov     dx,offset old_file      ; Set offset of old file name.
        int     21h
        mov     old_handle,ax           ; Save handle of old file.
        mov     ah,3ch                  ; Choose DOS service 3Ch (create file).
        mov     cx,0                    ; File attribute is normal.
        mov     ds,cs                   ; Segment of new file name.
        mov     dx,offset new_file      ; Offset of new file name.
        int     21h
        mov     new_handle,ax           ; Save handle of new file.
        print   working_msg             ; Display working message.
        cr

 initialize_search:                     ; INITIALIZE SEARCH INDEX.
        mov     di,offset search_string ; Set DI to beginning of search string.
        push    di                      ; Save search index.

 read_file:                             ; READ OLD FILE.
        mov     ah,3fh                  ; Choose DOS service 3Fh (read file).
        mov     bx,old_handle           ; Specify handle for old file.
        mov     cx,1                    ; Read 1 byte.
        mov     ds,cs                   ; Segment for variable to hold data.
        mov     dx,offset file_data     ; Offset for variable to hold data.
        int     21h
        cmp     ax,1                    ; Was the byte read?
        jne     end_of_filej            ; If not, the EOF has been reached.
        jmp     search_data

 end_of_filej:
        jmp     end_of_file

 search_data:                           ; SEARCH FOR SERVICE CODE.
        pop     di                      ; Restore search index.
        mov     al,[file_data]          ; Get character input from file.
        cmp     [di],al                 ; Does char match up with search?
        je      increment_search
        mov     di,offset search_string ; Reset search index if no match.
        push    di                      ; Save search index.

 write_file:                            ; WRITE NEW FILE.
        mov     ah,40h                  ; Choose DOS service 40h (write file).
        mov     bx,new_handle           ; Specify handle for new file.
        mov     cx,1                    ; Write 1 byte.
        mov     ds,cs                   ; Segment for variable holding data.
        mov     dx,offset file_data     ; Offset for variable holding data.
        int     21h
        jc      write_error             ; Jump if an error occurred.
        jmp     read_file               ; Read next byte.

 write_error:                           ; ERROR MESSAGE USED IF WRITE FAILS.
        print   write_msg
        cr
        jmp     end_program

 increment_search:                      ; UPDATE THE SEARCH INDEX.
        inc     di                      ; Increment search index by 1.
        push    di                      ; Save search index.
        cmp     b[di],0                 ; Has the end of string been reached?
        je      alter_code
        jmp     write_file

 alter_code:                            ; ALTER THE INTERRUPT SERVICE CODE.
        mov     ah,40h                  ; Choose DOS service 40h (write file).
        mov     bx,new_handle           ; Specify handle for new file.
        mov     cx,1                    ; Write 1 byte.
        mov     ds,cs                   ; Segment for variable holding data.
        mov     dx,offset file_data     ; Offset for variable holding data.
        int     21h
        jc      write_error             ; Jump if an error occurred.
        mov     ah,3fh                  ; Choose DOS service 3Fh (read file).
        mov     bx,old_handle           ; Specify handle for old file.
        mov     cx,1                    ; Read 1 byte.
        mov     ds,cs                   ; Segment for variable to hold data.
        mov     dx,offset file_data     ; Offset for variable to hold data.
        int     21h
        jc      end_of_file             ; Jump if end-of-file.
        mov     al,[service_code]       ; Get the new service code.
        mov     [file_data],al          ; Replace old service code.
        pop     di                      ; Restore search index.
        mov     di,offset search_string ; Reset search index.
        push    di                      ; Save search index.
        jmp     write_file

 end_of_file:                           ; CLOSE FILES.
        mov     ah,3eh                  ; Choose DOS service 3Eh (close file).
        mov     bx,old_handle           ; Specify handle for old file.
        int     21h
        mov     ah,3eh                  ; Choose DOS service 3Eh (close file).
        mov     bx,new_handle           ; Specify handle for new file.
        int     21h
        print   done_msg                ; Print completion message.
        cr
        jmp     end_program

 usage:
        print   usage_1
        cr
        print   usage_2
        print   usage_3
        print   usage_4
        cr
        jmp     end_program

 end_program:
        bye                             ;END PROGRAM.


 ; Data Segment.

        .DATA


 ; Begin Variables.

 params         db      255 dup(0)      ; Command line parameters.
 service_string db      '00'            ; Replacement service code string.
 service_code   db      00              ; Replacement service code.
 old_file       db      'dosview.old',0 ; Old file name.
 old_handle     dw      0000            ; Old file handle.
 new_file       db      'dosview.com',0 ; New file name.
 new_handle     dw      0000            ; New file handle.
 file_data      db      0               ; Variable to hold data from file.
 search_string  db      '(SERVICE>',0   ; String used to find service code.
 welcome        db      ' ViewSet V1.0 - by Steven H. Fisk - January, 1995',13,10,'$'
 usage_1        db      ' USAGE: viewset <SERVICE-CODE>',13,10,'$'
 usage_2        db      ' The <SERVICE-CODE> should be specified as a hexadecimal value within the',13,10,'$'
 usage_3        db      ' range of 00 - FF. Be warned that most of these service codes are used by',13,10,'$'
 usage_4        db      ' DOS. It is recomended only to use service codes with values between F0 - FF.',13,10,'$'
 working_msg    db      ' Working, please wait...',13,10,'$'
 done_msg       db      ' Job Complete - Original copy of DosView was saved in the file "DOSVIEW.OLD".',13,10,'$'
 rename_msg     db      ' ERROR - COULDN',39,'T FIND DOSVIEW.COM OR DOSVIEW.OLD EXISTS.',13,10,'$'
 write_msg      db      ' ERROR - WRITE FAILURE OCCURRED.',13,10,'$'

 ; End Variables.

 end

