/* formdefs.h c1989 Mark Gardner,
|                   EEmergent Consulting,
|                   Acton, CA
|                   805-269-1433
*/

/* definitions to assist formatting the C source code with a more uniform
|  approach to structure and indentation.  See the file FORMRULES.TXT for
|  examples of how these marks should be applied.  They are nul definitions
|  providing visible indent termination, primarily, and allow for structure
|  commenting.
*/

#define function     /* flags function definition statements           */
#define end_if       /* flags end of 'if' structures                   */
#define ___          /* marks line that continues a previous line      */
#define end_for      /* flags end of 'for' structures                  */
#define end_while    /* flags end of 'while' structures                */
#define end_switch   /* flags end of 'switch' structures               */
#define end_struct   /* flags end of structure definition              */
#define end_union    /* flags end of union definition                  */
#define end_enum     /* flags end of enum list                         */
#define end_case     /* flags end of 'case' structures                 */
#define con_case     /* flags end of 'case' structures                 */
#define end_function /* flags end of functions                         */
#define end_file     /* flags end of source, include, or other file    */
#define end_call     /* flags end of function call for clarity when
                           argument list is long and marginated        */

/* The uses of most of these are obvious.  For the two that aren't:
|
|  con_case is used to terminate a case structure that falls through
|  to a subsequent case, instead of end_case, which implies a 'break'.
|
|  ___ (three underbars) is used principally to show continuation of 'if'
|  and 'while' conditions, to maintain indentation of the 'if' or 'while'
|  at its own level for the several consecutive lines required to clearly
|  show the structure of the conditions themselves, e.g,
|
|		if  (      (char_loop_ptr <= LOOPEND)
|		___     && (loop_err_flag != TRUE)
|		___  ||	 
|		___        (err_overide == TRUE)
|		___     && (override_enabled == TRUE)
|		___ ) {
|			draft_doc2() ;
|			show_end() ;
|		end_if }
|
*/

end_file

