# ZAPCHK makefile for Borland C v3.1 using COMPACT model


# -------------
# PATH Settings
# -------------
# BCC, TLINK, TASM all must be present in PATH statement


# -------------------
# TURBOC.CFG Settings
# -------------------
# -C
# -Ic:\borlandc\include;c:\TEMP;c:\topaz\include;c:\borlandc\owl\include;c:\borlandc\classlib\include;.
# -Lc:\borlandc\lib;c:\topaz\sulib;c:\topaz\mulib;.
# -K
# -d
# -mc
# -w


# ------------------
# TLINK.CFG Settings
# ------------------
# /Lc:\borlandc\lib;c:\topaz\sulib;c:\topaz\mulib;


# ------------------------------
# Case Sensitive Compiler Macros
# ------------------------------
.SILENT                                         # do not display commands
.AUTODEPEND                                     # enable auto-dependencies
MODE      = 'E'                                 # (A)sm  (D)ebug  (E)xe
SKIP_LINK = 'N'                                 # 'Y' or 'N', single quotes
MODEL     = c                                   # t,s,m,c,l,h
COMPILER  = bcc                                 # Borland C 3.1 in path
ASSEMBLER = tasm                                # Turbo Assembler 3.2 in path
LINKER    = tlink                               # TLink 5.1 in path
STARTUP   = c0c.obj                             # startup object
LINKLIBS  = cc                                  # linklibs in specific order
INCS      = c:\borlandc\include;


# ---------------------
# Compile To ASM Source
# ---------------------
!if $(MODE)=='A'
BCC_FLAGS = -c -f- -m$(MODEL) -G -Ox -S
SKIP_LINK = 'Y'                                 # 'Y' or 'N', single quotes
!endif


# -----------------------
# Standalone EXE Switches
# -----------------------
!if $(MODE)=='E'
BCC_FLAGS = -c -f- -m$(MODEL) -G -Ox
LNK_FLAGS = /c /x /Tde
ASM_FLAGS = /s /mx /os /t /w2 /iC:\TEMP
!endif


# --------------------
# Turbo Debug Switches
# --------------------
!if $(MODE)=='D'
BCC_FLAGS = -c -f- -m$(MODEL) -DRTC -DTDB -v -y -N
LNK_FLAGS = /c /l /m /v /Tde
ASM_FLAGS = /s /la /mx /os /t /w2 /zi /iC:\TEMP/DDEBUG
!endif


!if $(SKIP_LINK)=='N'
zapchk.exe:  zapchk.obj

              $(LINKER)  $(LNK_FLAGS)  $(STARTUP)      \
                                       zapchk.obj,     \
                                       zapchk.exe,,    \
                                       $(LINKLIBS)
!endif

zapchk.obj:  zapchk.c

             $(COMPILER)  $(BCC_FLAGS)  zapchk.c


