;Public Domain 1993 by Eric Johnson

P8086
MODEL TINY

DATASEG
        filename        db      '         1ST-BOOT.COM',0

UDATASEG
        lastdate        db      ?       ;remembers last date run
        handle          dw      ?       ;file handle

                DW 100H DUP (?)
MyStack  LABEL WORD

CODESEG
   STARTUPCODE
   MOV SP,OFFSET MyStack

                mov     ah, 2Ah         ;get day into al
                int     21h

                mov     bl, [lastdate]    ;see if first time today
                cmp     al, bl
                jnz     firsttime
                mov     ax, 4C00h       ;end program, return(0)
                int     21h


firsttime:      ; al still has date

                mov     [lastdate],al     ;save todays date
                
                mov     dx, OFFSET filename
                mov     ax, 3D02h       ;open file r/w
                int     21h

                mov     [handle], ax      ;save the file handle

                mov     bx, ax          ;handle in bx
                mov     cx, 0
                mov     dx, (OFFSET lastdate)-100h  
                mov     ax, 4200h       ;seek to flag position
                int     21h

                mov     cx, 1           ;write new date
                mov     bx, [handle]    
                mov     ah, 40h
                int     21h

                mov     ah, 3Eh         ;close file
                mov     bx, [handle]
                int     21h

                mov     ax, 4C01h       ;end program, return(1)
                int     21h

   
                END
