;
; CPUTEST.ASM - Copyright (C) 1993 - Tony Doimeadios - All Rights Reserved
;
;         Made-----------: 09/30/93
;         Last Modified--: 10/01/93
;         Last Modified--: 10/11/93 Added file i/o to record info & comments
;         Last Modified--: 10/15/93 Added 80386-specific code to test routines

    
    DOSSEG
    .MODEL LARGE
    .STACK
    .DATA?
Buffer1 db  25000 DUP (?)       ;buffer to copy from
Buffer2 db  25000 DUP (?)       ;buffer to copy to

    .DATA
StartLow    dw  0               ;variable to store the low word of start ticks
FinishLow   dw  0               ;variable to store the low word of stop ticks
Counter     dw  0               ;variable to store loop counter
Dummy       dw  0               ;dummy word variable for variable-2-reg proc
BigDummy    dd  0               ;dummy word variable for variable-2-ex reg
CRLF        db  13,10,'$'
UserInput   db  71 DUP (' ')
            db  13,10
Prompt      db  'Please enter a brief description of system',13,10
            db  '(ex. 80386DX-33MHz, 64K Cache, 4 Meg Ram, CoProcessor, DOS 5.0)',13,10
            db  '         1         2         3         4         5         6         7   ',13,10
            db  '1234567890123456789012345678901234567890123456789012345678901234567890123',13,10,'$'
FileName    db  'CPUTEST.TXT',0
Handle      dw  0
BadCreate   db  13,10,7,7,'An error occured while trying to create the report file...',13,10,'$'

            ;         1         2         3         4         5         6         7         8
            ;12345678901234567890123456789012345678901234567890123456789012345678901234567890    len=74 (includes $)
Output1  db 'It took       timer ticks to move 8 million bytes...                   ',13,10,'$'
Output2  db 'It took       timer ticks to do 8 million register-to-register moves...',13,10,'$'
Output3  db 'It took       timer ticks to do 8 million variable-to-register moves...',13,10,'$'
Output4  db 'It took       timer ticks to move 100 million bytes...                 ',13,10,'$'
Output5  db 'It took  N/A  timer ticks to do 8 million ext reg-to-ext reg moves...  ',13,10,'$'
Output6  db 'It took  N/A  timer ticks to do 8 million variable-to-ext reg moves... ',13,10,'$'
Msg386   db 13,10
         db '                   80386 Specific Instructions                       ',13,10,'$'
Delimit  db 71 DUP ('*')    ;this is a string of *'s, to mark off visually
         db 13,10
    
    .CODE
    .386
    mov ax,@Data
    mov ds,ax                   ;set DS to point to the data segment

    jmp Start                   ;jmp over procs


;   PROCS (put at beginning)
;---------------------------------------------------------------------
;---------------------------------------------------------------------
;---------------------------------------------------------------------
; Subroutine to convert a binary number to a text string.
;
; Input:
;       ax = number to convert
;       DS:BX = pointer to end of string to store text in
;       CX = number of digits to convert
;
; Output: None
;
; Registers destroyed: ax, BX, CX, DX, SI
;
Num2Str   PROC NEAR
        mov     si,10           ;used to divide by 10
ConvertLoop:
        sub     dx,dx           ;convert ax to doubleword in DX:ax
        div     si              ;divide number by 10. Remainder is in
                                ; DX--this is a one-digit decimal
                                ; number. Number/10 is in ax
        add     dl,'0'          ;convert remainder to a text character
        mov     [bx],dl         ;put this digit in the string
        dec     bx              ;point to the location for the
                                ; next most-significant digit
        loop    ConvertLoop     ;do the next digit, if any
        ret
Num2Str   ENDP
;---------------------------------------------------------------------


;---------------------------------------------------------------------
; Subroutine to print a string on the display.
;
; Input:
;       DS:BX = pointer to string to print
;
; Output: None
;
; Registers destroyed: None
;
PrintString     PROC NEAR
        push    ax
        push    dx              ;preserve registers in this sub
        mov     ah,9            ;DOS print string function #
        mov     dx,bx           ;point DS:DX to the string to print
        int     21h             ;invoke DOS to print the string
        pop     dx              ;restore registers we changed
        pop     ax              ;restore registers we changed
        ret                     ;bail out
PrintString     ENDP
;---------------------------------------------------------------------




;---------------------------------------------------------------------
MemoryMove PROC NEAR
    
    mov ax,SEG Buffer1          ;get segment of ROM BIOS
    mov es,ax                   ;put it in ds
    mov di,OFFSET Buffer1       ;get offset of buffer

    mov ax,SEG Buffer2          ;get segment of Buffer2
    mov ds,ax                   ;put it in es
    mov si,0                    ;get offset of buffer

    mov cx,25000                ;gonna move 25000 bytes
    rep movsb                   ;do it until cx=0

    ret                         ;done - bail out

MemoryMove ENDP
;---------------------------------------------------------------------




;---------------------------------------------------------------------
RegToReg PROC NEAR
    mov cx,25000                ;setup for 25000 times
    
MoveLoop:
    mov es,ax                   ;do register to register move
    loop MoveLoop               ;do it 25000 times

    ret                         ;done - bail out

RegToReg ENDP
;---------------------------------------------------------------------




;---------------------------------------------------------------------
MemToReg PROC NEAR
    mov cx,25000                ;setup for 25000 times
    
MemLoop:
    mov dx,Dummy                ;do variable to register move
    loop MemLoop                ;do it 25000 times

    ret                         ;done - bail out

MemToReg ENDP
;---------------------------------------------------------------------





;                   80386-Specific Procs

;---------------------------------------------------------------------
ERegToEReg PROC NEAR
    mov cx,25000                ;setup for 25000 times
    
MoveELoop:
    mov eax,ebx                 ;do register to register move
    loop MoveELoop              ;do it 25000 times

    ret                         ;done - bail out

ERegToEReg ENDP
;---------------------------------------------------------------------




;---------------------------------------------------------------------
MemToEReg PROC NEAR
    mov cx,25000                ;setup for 25000 times
    
MemELoop:
    mov edx,BigDummy            ;do variable to register move
    loop MemELoop               ;do it 25000 times

    ret                         ;done - bail out

MemToEReg ENDP
;---------------------------------------------------------------------



;---------------------------------------------------------------------
MoveEBytes PROC NEAR
    
    ;I don't know the instruction to do a memory move with 32-bit regs
    ret                         ;done - bail out

MoveEBytes ENDP
;---------------------------------------------------------------------


;---------------------------------------------------------------------
WhichCPU PROC NEAR
    
    ;Determine whether the CPU in use is an 8086/88, an 80286,
    ;an 80386 or an 80486.  Returns the CPU type in the ax register.

    ;The first step is to determine whether the chip is an 8086/8088.
    ;The key difference is based on what the CPU does when it executes
    ;the PUSH instruction.  The 8086/8088 decrements the stack pointer
    ;first, then writes the saved value to the stack, then decrement
    ;the stack pointer.  Thus, when SP is pushed, and the pushed value
    ;is popped off, the value popped off will equal the current stack 
    ;pointer, unless the chip is an 8086 or an 8088.
    
    push sp                     ;push sp
    pop ax                      ;retrieve value
    cmp ax,sp                   ;is it the same value that was pushed?
    je Try286                   ;if same, it is a 80286 or higher
    mov ax,88                   ;nope, set register to reflect 8088
    jmp short ProcDone          ;bail out



    ;the second step is to determine whether the chip is an 80286.
    ;The key difference is the IOPL bits in the flag register; the 80386
    ;and 80486 has them, the 80286 does not.  The 80286 will not allow them
    ;to be set; the 80386 and 80486 will.

Try286:
    pushf                       ;push flags
    pop ax                      ;retreive them
    or ax,03000h                ;set IOPL bits
    push ax                     ;stuff back
    popf                        ;pop flags back - this is where the 80286 
                                ; will put them back the way they were
    pushf                       ;push them back
    pop ax                      ;see if CPU overrode the IOPL bits
    test ax,03000h              ;if the IOPL bits are reset, the CPU did
                                ; and the chip is an 80286
    jnz Try386                  ;nope, go see if we're an 80386
    mov ax,286                  ;set register to reflect we're an 80286
    jmp short ProcDone          ;bail out

    
    
    ;the third step is to determine whether the chip is an 80386.
    ;the key difference is the alignment check bit in the flags
    ;register: the 80486 has one, the 80386 does not.  As with the
    ;80286 and the IOPL bits, the 80386 will not let you set that bit,
    ;but the 80486 will.

Try386:
    db 66h                      ;(32 bit)
    pushf                       ;push extended flags register
    pop ax                      ;read low word
    and ax,00fffh               ;clear IOPL bits - level zero
    pop dx                      ;read high word
    or dx,00004h                ;set alignment check bit
    push dx                     ;push flags back
    push ax                     ;push flags back
    db 66h                      ;(32 bit)
    popf                        ;pop flags register - this is where
                                ; the 80386 will undo your work
    db 66h                      ;(32 bits) 
    pushf                       ;push flags back
    pop ax                      ;read what we did
    pop dx                      ;find out if the CPU reset the
                                ; alignment check bit
    test dx,4                   ;
    jnz short Try486            ;if it didn't, the chip is an 80486
    mov ax,386                  ;set register to reflect we're an 8386
    jmp short ProcDone          ;bail out


    ;this routine does NOT take into account the Pentium (80586)
    ;therefore, this routine will report an '486' for both the
    ;80486 and the Pentium chips
    
Try486:
    mov ax,486                  ;must be a 80486


ProcDone:    
    ret                         ;we're thru - bail out

WhichCPU ENDP
;---------------------------------------------------------------------
;---------------------------------------------------------------------
;---------------------------------------------------------------------





;                      CODE STARTS HERE

;---------------------------------------------------------------------
Start:    
    ;MEMORY MOVES
    ;
    ;timing loop
    ;
    xor  ax,ax                  ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov StartLow,dx             ;save it (low word)
    
    
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    mov Counter,0               ;initialize the loop counter

DoIt1:    
    call MemoryMove             ;call the memory mover proc
    inc Counter                 ;inc the counter
    cmp Counter,40*8            ;40 loops = 1 million
    jne DoIt1                   ;if it's not the required # of loops, do more
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


    ;timing loop
    ;
    xor  ax,ax                  ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov FinishLow,dx            ;save it (low word)


    ;get difference from start and stop times
    ;
    xor ax,ax                   ;zero out register
    mov ax,FinishLow            ;put stop times in
    sub ax,StartLow             ;sub start from it - ax now holds difference

    mov bx,SEG Output1          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output1+12    ;offset is 13 characters into the string
    mov cx,5                    ;convert 5 digits
    call Num2Str

    mov bx,SEG Output1          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output1       ;get offset of string
    call PrintString            ;print string
;---------------------------------------------------------------------
;---------------------------------------------------------------------




;---------------------------------------------------------------------
;---------------------------------------------------------------------
    ;REGISTER TO REGISTER
    ;
    ;timing loop
    ;
    xor ax,ax                   ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov StartLow,dx             ;save it (low word)

    
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    mov Counter,0               ;initialize the loop counter

DoIt2:    
    call RegToReg               ;call the register to register mover proc
    inc Counter                 ;inc the counter
    cmp Counter,40*8            ;40 loops = 1 million
    jne DoIt2                   ;if it's not the required # of loops, do more
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


    ;timing loop
    ;
    xor ax,ax                   ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov FinishLow,dx            ;save it (low word)


    ;get difference from start and stop times
    xor ax,ax                   ;zero out register
    mov ax,FinishLow            ;put stop times in
    sub ax,StartLow             ;sub start from it - ax now holds difference

    mov bx,SEG Output2          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output2+12    ;offset is 13 characters into the string
    mov cx,5                    ;convert 5 digits
    call Num2Str

    mov bx,SEG Output2          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output2       ;get offset of string
    call PrintString            ;print string
;---------------------------------------------------------------------
;---------------------------------------------------------------------




;---------------------------------------------------------------------
;---------------------------------------------------------------------
    ;VARIABLE TO REGISTER
    ;
    ;timing loop
    ;
    xor ax,ax                   ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov StartLow,dx             ;save it (low word)

    
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    mov Counter,0               ;initialize the loop counter

DoIt3:    
    call MemToReg               ;call the variable to register mover proc
    inc Counter                 ;inc the counter
    cmp Counter,40*8            ;40 loops = 1 million
    jne DoIt3                   ;if it's not the required # of loops, do more
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


    ;timing loop
    ;
    xor ax,ax                   ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov FinishLow,dx            ;save it (low word)
    
    ;get difference from start and stop times
    xor ax,ax                   ;zero out register
    mov ax,FinishLow            ;put stop times in
    sub ax,StartLow             ;sub start from it - ax now holds difference

    mov bx,SEG Output3          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output3+12    ;offset is 13 characters into the string
    mov cx,5                    ;convert 5 digits
    call Num2Str

    mov bx,SEG Output3          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output3       ;get offset of string
    call PrintString            ;print string
;---------------------------------------------------------------------
;---------------------------------------------------------------------




;---------------------------------------------------------------------
;---------------------------------------------------------------------
    ;MEMORY MOVES (requested by Richard)
    ;
    ;timing loop
    ;
    xor ax,ax                   ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov StartLow,dx             ;save it (low word)

    
    
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    mov Counter,0               ;initialize the loop counter

DoIt4:    
    call MemoryMove             ;call the memory mover proc
    inc Counter                 ;inc the counter
    cmp Counter,40*100          ;40 loops = 1 million
    jne DoIt4                   ;if it's not the required # of loops, do more
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


    ;timing loop
    ;
    xor ax,ax                   ;zero out register
    int 1Ah                     ;how many clock ticks since midnight
    mov FinishLow,dx            ;save it (low word)


    ;get difference from start and stop times
    ;
    xor ax,ax                   ;zero out register
    mov ax,FinishLow            ;put stop times in
    sub ax,StartLow             ;sub start from it - ax now holds difference

    mov bx,SEG Output4          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output4+12    ;offset is 13 characters into the string
    mov cx,5                    ;convert 5 digits
    call Num2Str

    mov bx,SEG Output4          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output4       ;get offset of string
    call PrintString            ;print string
;---------------------------------------------------------------------
;---------------------------------------------------------------------

    



;---------------------------------------------------------------------
;---------------------------------------------------------------------
    xor ax,ax                   ;zero out register
    call WhichCPU               ;call proc to determine CPU type
    cmp ax,386                  ;is it at least a 386?
    jae Do386Tests              ;yes, go do 386-specific tests
    jmp CreateReport            ;nope, bail out (286 or lower)
;---------------------------------------------------------------------
;---------------------------------------------------------------------





;---------------------------------------------------------------------
;---------------------------------------------------------------------
Do386Tests:
    ;EXTENDED REGISTER TO EXTENDED REGISTER
    ;
    ;timing loop
    ;
    
    mov bx,SEG Msg386           ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Msg386        ;get offset of string
    call PrintString            ;print string
    
    
    xor ax,ax                   ;look at the low system timer byte
    int 1Ah                     ;how many clock ticks since midnight
    mov StartLow,dx             ;save it (low word)

    
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    mov Counter,0               ;initialize the loop counter

DoIt5:    
    call ERegToEReg               ;call the extended register mover proc
    inc Counter                 ;inc the counter
    cmp Counter,40*8            ;40 loops = 1 million
    jne DoIt5                   ;if it's not the required # of loops, do more
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


    ;timing loop
    ;
    xor ax,ax                   ;look at the low system timer byte
    int 1Ah                     ;how many clock ticks since midnight
    mov FinishLow,dx            ;save it (low word)


    ;get difference from start and stop times
    xor ax,ax                   ;zero out register
    mov ax,FinishLow            ;put stop times in
    sub ax,StartLow             ;sub start from it - ax now holds difference

    mov bx,SEG Output5          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output5+12    ;offset is 13 characters into the string
    mov cx,5                    ;convert 5 digits
    call Num2Str

    mov bx,SEG Output5          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output5       ;get offset of string
    call PrintString            ;print string

;---------------------------------------------------------------------
;---------------------------------------------------------------------





;---------------------------------------------------------------------
;---------------------------------------------------------------------
    ;VARIABLE TO EXTENDED REGISTER
    ;
    ;timing loop
    ;
    xor ax,ax                   ;look at the low system timer byte
    int 1Ah                     ;how many clock ticks since midnight
    mov StartLow,dx             ;save it (low word)

    
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    mov Counter,0               ;initialize the loop counter

DoIt6:    
    call MemToEReg                ;call the variable to register mover proc
    inc Counter                 ;inc the counter
    cmp Counter,40*8            ;40 loops = 1 million
    jne DoIt6                   ;if it's not the required # of loops, do more
    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


    ;timing loop
    ;
    xor ax,ax                   ;look at the low system timer byte
    int 1Ah                     ;how many clock ticks since midnight
    mov FinishLow,dx            ;save it (low word)
    
    ;get difference from start and stop times
    xor ax,ax                   ;zero out register
    mov ax,FinishLow            ;put stop times in
    sub ax,StartLow             ;sub start from it - ax now holds difference

    mov bx,SEG Output6          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output6+12    ;offset is 13 characters into the string
    mov cx,5                    ;convert 5 digits
    call Num2Str

    mov bx,SEG Output6          ;get segment of Output1 string
    mov ds,bx                   ;put it in ds
    mov bx,OFFSET Output6       ;get offset of string
    call PrintString            ;print string
;---------------------------------------------------------------------
;---------------------------------------------------------------------







CreateReport:
    ;display default prompt
    mov ax,SEG CRLF
    mov ds,ax
    mov bx,OFFSET CRLF
    call PrintString
    
    mov ax,SEG Prompt
    mov ds,ax
    mov bx,OFFSET Prompt
    call PrintString
    
    ;get user input         
    xor ax,ax               ;zero out register
    xor bx,bx               ;zero out register
    xor cx,cx               ;zero out register
    xor dx,dx               ;zero out register
    mov ah,3Fh              ;function to ????????
    xor bx,bx               ;zero out register
    mov cx,73               ;# of bytes to get
    mov dx,SEG UserInput    ;get segment of string to hold user's input
    mov ds,dx               ;put it in ds
    mov dx,OFFSET UserInput ;put offset of same string into dx
    int 21h                 ;call DOS to do it

    
Open:    
    mov ax,SEG FileName     ;get segment of filename
    mov ds,ax               ;put it in ds
    mov dx,OFFSET FileName  ;get offset of filename
    mov ah,3Dh              ;function to open a file
    mov al,00000010b        ;bit 1 (zero-based) set for read/write access
    int 21h                 ;call DOS to do it
    mov Handle,ax           ;save handle
    jnc SeekEnd

    
Create:
    mov ax,SEG FileName     ;get segment of filename
    mov ds,ax               ;put it in ds
    mov dx,OFFSET FileName  ;get offset of filename
    mov ah,3Ch              ;function to create a file
    mov cl,00100000b        ;bit 5 (zero-based) set means file is normal
    int 21h                 ;call DOS to do it

    mov ax,SEG FileName     ;get segment of filename
    mov ds,ax               ;put it in ds
    mov dx,OFFSET FileName  ;get offset of filename
    mov ah,3Dh              ;function to open a file
    mov al,00000010b        ;bit 1 (zero-based) set for read/write access
    int 21h                 ;call DOS to do it
    mov Handle,ax           ;save handle
    jnc SeekEnd


CreateError:
    mov ax,SEG BadCreate    ;point to error msg about creating the file
    mov ds,ax               ;put it in ds
    mov bx,OFFSET BadCreate ;put offset in bx
    call PrintString        ;print the msg
    jmp Done                ;bail out


SeekEnd:
    mov ah,42h              ;function to set current file position
    mov al,02h              ;02 = end of file
    mov bx,Handle           ;handle from opening file
    mov cx,0                ;high byte of offset from file position
    mov dx,0                ;low byte of offset from file position
    int 21h                 ;call DOS to do it
    
    
Write:                      
    mov ax,SEG Output1      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Output1   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Output2      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Output2   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Output3      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Output3   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Output4      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Output4   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Msg386       ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Msg386    ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Output5      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Output5   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Output6      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Output6   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it
    
    mov ax,SEG UserInput    ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET UserInput ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    mov ax,SEG Delimit      ;get segment of string to write to disk
    mov ds,ax               ;put it in ds
    mov dx,OFFSET Delimit   ;get offset of string to write to disk
    xor ax,ax               ;zero out register
    mov ah,40h              ;function to write to device/file (handle)
    mov bx,Handle           ;handle to write to (saved from OPEN function)
    mov cx,73               ;how many characters to write
    int 21h                 ;call DOS to do it

    
Close:
    mov ah,3Eh              ;function to close
    mov bx,Handle           ;handle to close (saved from OPEN function)
    int 21h                 ;call DOS to do it


Done:
    mov ax,4C00h            ;function to terminate program & normal exit code
    int 21h                 ;call DOS to do it
    END                     ;gone...
