; SlosDosA.ASM    Assembly portion of SlowDos. This handles the interrupt
;                 functions which slow the system down.
;Copyright Nombas 1992. For the public domain; do not remove copyright notice.

_TEXT segment byte public 'CODE'

   public   _InstallMolasses, _RemoveMolasses
   assume   cs:_TEXT, ds:NOTHING, es:NOTHING

   MolassesCount  dw ?
   int13_ptr  equ this dword         ;Old interrupt vector 13H
   int13_ofs  dw ?                   ;Offset address of the old handler
   int13_seg  dw ?                   ;Segment address of the old handler
   int08_ptr  equ this dword         ;Old interrupt vector 13H
   int08_ofs  dw ?                   ;Offset address of the old handler
   int08_seg  dw ?                   ;Segment address of the old handler
   in_int     db 0                   ;used to catch if already in an interrupt
                                     ; so shouldn't delay

   save_bx     dw    ?
   INTERNAL_MOLASSESCOUNT  equ   800


internal_loop  proc  near  ; loop for INTERNAL_MOLASSESCOUNT
   mov   save_bx, bx
   mov   bx, INTERNAL_MOLASSESCOUNT
iagain:
   cmp   bx, 0
   je    bx_is_zero
   dec   bx
   jmp   iagain
bx_is_zero:
   mov   bx, save_bx
   ret
internal_loop  endp
 

   save_ax     dw    ?

hang_out proc near
   mov   save_ax, ax
   mov   ax, MolassesCount

hang_out_loop:
   cmp   ax, 0
   je    hang_out_end
   call  internal_loop
   dec   ax
   jmp   hang_out_loop
hang_out_end:

   mov   ax, save_ax
   ret
hang_out endp


int08 proc far
   cmp   in_int, 0         ;in some cases already in interrupt so
   je    delay             ; skip our delay
   jmp   [int08_ptr]

delay:
   inc   in_int
   pushf
   call  [int08_ptr]       ;Call old interrupt handler using INT 08H emulation

   sti                     ;Enable interrupts

   call  hang_out

   cli                     ;disable interrupts to reset flag
   dec   in_int            ; and return from interrupt
   iret
int08    endp

int13    proc far

   inc   in_int            ;Increment in-interrupt flag
   pushf                   ;Call old interrupt handler
   call  [int13_ptr]       ; using INT 13H emulation
   dec   in_int            ;Reset BIOS disk flag

   iret                    ;pop flags and return
int13    endp


_InstallMolasses proc near
   push  bp
   mov   bp, sp
   push  es
   push  ds
   push  cs
   pop   ds

   mov   ax, [bp+4]
   mov   MolassesCount, ax

   ; set up interrupt 13 to flag when it's busy
   mov   ax, 3513h         ;Get interrupt vector 13H
   int   21h               ;Call DOS interrupt
   mov   int13_ofs, bx     ;Store handler address in
   mov   int13_seg, es     ; corresponding variables
   mov   ax, 2513h         ;Funct. no.: Set interrupt 13H
   mov   dx, offset int13  ;DS:DX contains the handler address
   int   21h               ;Call DOS interrupt

   ; set up timer interrupt to point to ours
   mov   ax, 3508h
   int   21h
   mov   int08_ofs, bx
   mov   int08_seg, es
   mov   ax, 2508h
   mov   dx, offset int08
   int   21h

   pop   ds
   pop   es
   pop   bp
   ret
_InstallMolasses endp


_RemoveMolasses proc near
   push  ds
   ; reinstall to old 13 handler
   mov   ax, 2513h            ;Funct. no.: Set INT 13H handler
   mov   ds, int13_seg        ;Segment address of the old handler
   mov   dx, int13_ofs        ;Offset address of the old handler
   int   21h                  ;Reinstall old handler

   ; reinstall old timer routine
   mov   ax, 2508h
   mov   ds, int08_seg
   mov   dx, int08_ofs
   int   21h

   pop   ds
   ret
_RemoveMolasses endp

_TEXT ends

END
