                .SEQ
CODE            Segment WORD PUBLIC 'CODE'
CODE            EndS

include vga.inc

CODE            Segment
                Assume  CS:Code, DS:ABS40

                Org     2Ch
EnvironSeg      Label   Word
                Org     80h
ArgumentCount   Label   Byte
                Org     81h
Arguments       Label   Byte
 
                Assume  CS:Code, DS:Code
                
                Org     100h
Start:          Mov     Bx, Offset EndCode
                Add     Bx, 20Fh; add space for stack and rounding
                And     Bx, 0FFF0h; Round to a paragraph

                Mov     Sp, Bx; Move stack
                Sub     Sp, 2

                Shr     Bx, 1;  Convert from bytes to paragraphs
                Shr     Bx, 1
                Shr     Bx, 1
                Shr     Bx, 1
                Mov     Ah, 4Ah; Adjust memory use to minimum
                Int     21h;    Assumes ES is as on entry



                Mov     Bl, 10h
                Mov     Ah, 12h;        Test for VGA/EGA
                Int     10h
                Cmp     Bl, 10h
                Jne     VGA_EGA_Found;            Neither VGA/EGA

                Mov     Dx, Offset BadCard
                Mov     Ah, 9
                Int     21h
                Mov     Al, 1
                Mov     Ah, 4Ch
                Int     21h

BadCard         Db      'R requires a VGA/EGA card to function.',0Dh,0Ah,'$'


                Assume  CS:Code, DS:ABS40

VGA_EGA_Found:  Push    Ds
                Mov     Ax, 40h
                Mov     Ds, Ax
                Cmp     video_rows, 25
                Jbe     RunStd
                Pop     Ds

                Assume  CS:Code, DS:Code

                Call    SetStdMode

                Call    RunProg

                Push    Ax; save returncode

                Call    SetHiMode

                Pop     Ax; Get returncode

                Mov     Ah, 4Ch
                Int     21h

RunStd:         Pop     Ds
                Call    RunProg
                
                Mov     Ah, 4Ch
                Int     21h

SaveRows        db      ?
CurPosition     dw      ?
CurChar         dw      ?
ScrollCount     db      ?

                Assume  CS:Code, DS:ABS40

SetStdMode      Proc    Near
                Push    Ds
                Push    Es
                Mov     Ax, 40h
                Mov     Ds, Ax
                Mov     Al, video_rows
                Mov     SaveRows, Al

                Call    Near Ptr GetCurrentChar
                Mov     CurChar, Ax
                Mov     CurPosition, Dx
                
                Inc     Dh
                Cmp     Dh, video_rows
                Ja      NoClear

                Mov     Cx, Dx
                Mov     Dh, video_rows
                Mov     Dl, Byte Ptr crt_cols
                Dec     Dl
                Mov     Bx, CurChar
                Mov     Ax, 0600h
                Int     10h
                
NoClear:        Xor     Cx, Cx
                Mov     Dx, CurPosition
                Mov     Dl, Byte Ptr crt_cols
                Dec     Dl
                Mov     Bx, CurChar
                Mov     Ah, 06h
                Mov     Al, Dh
                Sub     Al, 24
                Jle     NoScroll
                Mov     ScrollCount, Al
                Int     10h
                Jmp     ChangeTo_Std

NoScroll:       Xor     Al, Al
                Mov     ScrollCount, Al

ChangeTo_Std:   Mov     Ax, 1A00h; Check Vga/Ega
                Int     10h
                Cmp     Al, 1Ah
                Jne     Ega_8x14

                Mov     Ax, 1114h; Load 9x16 charset, program controller
                Mov     Bl, 0
                Int     10h

                Mov     Ax, 1200h;  Enable cursor emulation
                Mov     Bl, 34h
                Int     10h
                Jmp     SetCursor_Std

Ega_8x14:       Mov     Ax, 1111h; Load 8x14 charset, program controller
                Mov     Bl, 0
                Int     10h
                And     info, 0FEh

SetCursor_Std:  Mov     Ah, 1;  Set cursor type
                Mov     Cx, 0707h
                Int     10h

                Mov     Ah, 2;  Move cursor
                Mov     Bh, active_page
                Mov     Dx, CurPosition
                Sub     Dh, ScrollCount
                Int     10h

                Pop     Es
                Pop     Ds
                Ret
SetStdMode      EndP

SetHiMode       Proc    Near
                Push    Ds
                Push    Es
                Mov     Ax, 40h
                Mov     Ds, Ax
                Mov     Al, video_rows
                Mov     SaveRows, Al
                Call    Near Ptr GetCurrentChar
; the line below is commented out.  In this case, I want
; the value saved when setting std mode to be used
;                Mov     CurChar, Ax
                Mov     CurPosition, Dx
                Mov     Ax, 1112h; Load 8x8 charset; program controller
                Mov     Bl, 0
                Int     10h

                Mov     Ax, 1200h; Select alternate print screen routine
                Mov     Bl, 20h
                Int     10h
                
                Mov     Ax, 1A00h; Check Vga/Ega
                Int     10h
                Cmp     Al, 01Ah
                Jne     Ega_8x8

                Mov     Ax, 1201h;  Disable cursor emulation
                Mov     Bl, 34h
                Int     10h
                Jmp     SetCursor_8x8

Ega_8x8:        Or      info, 1   

SetCursor_8x8:  Mov     Ah, 1;  Set cursor type
                Mov     Cx, 0707h
                Int     10h

                Mov     Ah, 2;  Position cursor
                Mov     Bh, active_page
                Mov     Dx, CurPosition
                Int     10h

                Mov     Cx, CurPosition
                Inc     Ch
                Cmp     Ch, video_rows
                Ja      NoClearExcess

                Xor     Cl, Cl
                Mov     Dh, video_rows
                Mov     Dl, Byte Ptr crt_cols
                Dec     Dl
                Mov     Bx, CurChar
                Mov     Ax, 0600h
                Int     10h

NoClearExcess:  Pop     Es
                Pop     Ds
                Ret
SetHiMode       EndP

;      Returns: Ax - current char & attribute
;               Dx - current position


GetCurrentChar  Proc    Near

                Mov     Ax, crt_start
                Shr     Ax, 1
                Shr     Ax, 1
                Shr     Ax, 1
                Shr     Ax, 1
                Mov     Ah, 0B8h
                Mov     Es, Ax

                Xor     Bx, Bx
                Mov     Bl, active_page
                Shl     Bx, 1
                Mov     Dx, cursor_posn[Bx]

                Xor     Bx, Bx
                Mov     Bl, Dl
                Shl     Bx, 1
                Mov     Al, Byte Ptr crt_cols
                Mul     Dh
                Add     Bx, Ax
                Mov     Ax, Es:[Bx]

                Ret

GetCurrentChar  EndP

ProgPathName    db      128 dup(0)

ParamBlock      dw      0
CmdLine         dw      080h, 0
Fcb1            dw      05Ch, 0
Fcb2            dw      06Ch, 0
 
Errors          dw      UnknErr
                dw      Err1
                dw      Err2
                dw      UnknErr
                dw      UnknErr
                dw      UnknErr
                dw      UnknErr
                dw      UnknErr
                dw      Err8
                dw      UnknErr
                dw      Err10
                dw      Err11
 
UnknErr         db      'Unknown Error.',0Dh,0Ah,'$'
Err1            db      'Invalid function.',0Dh,0Ah,'$'
Err2            db      'File not found.',0Dh,0Ah,'$'
Err8            db      'Not enough memory.',0Dh,0Ah,'$'
Err10           db      'Bad environment.',0Dh,0Ah,'$'
Err11           db      'Bad format.',0Dh,0Ah,'$'
 
NoProgError     db      'No program named.',0Dh,0Ah,'$'
NotFoundError   db      'Program not found.',0Dh,0Ah,'$'

PathStr         db      'PATH='
ComSuffix       db      '.COM',0
ExeSuffix       db      '.EXE',0

NoSuffixAdded   db      0; false, 1=true
PathGiven       db      0; false, 1=true
PathPtr         dw      0
ProgName        db      128 dup(0)
EndProgName     dw      0
EndPathName     dw      0
 
RunProg         Proc    Near
                Mov     Ax, Cs
                Mov     Ds, Ax

                Assume  Cs:Code, Ds:Code

                Mov     Si, Offset ArgumentCount
                Mov     Cl, [Si]
                Inc     Si
                Xor     Ch, Ch
                Jcxz    NoProg
                Mov     Di, Offset ProgName
                Jmp     SkipInitBlks
 
NoProg:         Mov     Dx, Offset NoProgError
                Mov     Ah, 9
                Int     21h
                Mov     Al, 1
                Ret
 
SkipInitBlks:   Lodsb
                Cmp     Al, ' '
                Jne     CopyProgName10
                Loop    SkipInitBlks
                Jmp     NoProg
 
CopyProgName:   Lodsb
                Cmp     Al, ' '
                Je      CopyArgs
                Cmp     Al, '.'; Suffix given?
                Jne     CopyProgName10; Not here anyway
                Mov     NoSuffixAdded, 1; Yes, mark the fact
                Jmp     CopyProgName20
 
CopyProgName10: Cmp     Al, '\'; Path given?
                Jne     CopyProgName20; Not here anyway
                Mov     PathGiven, 1; Yes, mark the fact
 
CopyProgName20: Stosb
                Loop    CopyProgName
                Mov     ArgumentCount, 0; No Args
                Mov     EndProgName, Di
                Jmp     ProcessProgName
 
CopyArgs:       Dec     Cx
                Mov     ArgumentCount, Cl
                Mov     EndProgName, Di
                Jcxz    ProcessProgName
                Mov     Di, Offset Arguments
            Rep Movsb
 
ProcessProgName:Mov     Si, Offset ProgName
                Mov     Di, Offset ProgPathName
                Mov     Cx, EndProgName
                Sub     Cx, Si
            Rep Movsb
                Mov     EndPathName, Di
                Xor     Al, Al
                Stosb
 
                Cmp     ProgName+1, ':'; Is the disc given?
                Jne     StartSearch;    no
                Mov     PathGiven, 1;   yes, mark it as a limited search
 
StartSearch:    Cmp     PathGiven, 0;   Was a path or disc given?
                Je      TryPathes;      No, setup for trying pathes
                Jmp     TryFirstOpen;   Yes, limit the search
 
TryPathes:      Mov     Es, EnvironSeg
                Mov     Di, 0
FindPathes:     Cmp     Byte Ptr Es:[Di], 0
                Je      NoPathes
                Push    Di
                Mov     Si, Offset PathStr
                Mov     Cx, 5
           Repe Cmpsb
                Je      PathesFound
                Pop     Di
                Xor     Al, Al
                Mov     Cx, -1
          Repne Scasb
                Jmp     FindPathes
 
NoPathes:       Mov     PathPtr, Di
                Mov     Ax, Cs
                Mov     Es, Ax
                Jmp     TryFirstOpen; try current disc/dir first
 
PathesFound:    Mov     Ax, Cs
                Mov     Es, Ax
                Pop     Dx
                Mov     PathPtr, Di
                Jmp     TryFirstOpen; first try current disc/directory
 
NextPath:       Mov     Si, PathPtr
                Mov     Di, Offset ProgPathName
                Mov     Ds, EnvironSeg
                Cmp     Byte Ptr[Si], 0
                Jne     CopyPath
                Mov     Ax, Cs
                Mov     Ds, Ax
                Jmp     NotFound
 
CopyPath:       Lodsb
                Cmp     Al,';'; end of this path
                Je      CopyName;   Yes
                Cmp     Al, 0; end of all pathes
                Je      LastPath
                Stosb
                Jmp     CopyPath
 
LastPath:       Dec     Si;     save adr of null
CopyName:       Mov     Ax, Cs
                Mov     Ds, Ax
                Mov     PathPtr, Si
                Cmp     Byte Ptr -1[Di], '\'
                Je      CopyName10
                Mov     Al, '\'
                Stosb
 
CopyName10:     Mov     Si, Offset ProgName
                Mov     Cx, EndProgName
                Sub     Cx, Si
            Rep Movsb
                Mov     EndPathName, Di
                Xor     Al, Al
                Stosb
                Jmp     TryFirstOpen
 
TryFirstOpen:   Cmp     NoSuffixAdded, 0
                Jne     TryOnlyOpen
                Mov     Si, Offset ExeSuffix
                Mov     Di, EndPathName
                Mov     Cx, 5
            Rep Movsb
                Call    TryOpen
                Jc      TrySecondOpen
                Jmp     Run
 
TrySecondOpen:  Mov     Si, Offset ComSuffix
                Mov     Di, EndPathName
                Mov     Cx, 5
            Rep Movsb
                Call    TryOpen
                Jc      CheckForNext
                Jmp     Run
 
TryOnlyOpen:    Call    TryOpen
                Jc      CheckForNext
                Jmp     Run
 
CheckForNext:   Cmp     PathGiven, 0; Was a path or disc given?
                Jne     NotFound;       Yes, the search is limited.
                Jmp     NextPath;       No, try next path if any
 
NotFound:       Mov     Ah, 9
                Mov     Dx, Offset NotFoundError
                Int     21h
                Mov     Al, 1
                Ret

Run:            Mov     CmdLine+2, Cs
                Mov     Fcb1+2, Cs
                Mov     Fcb2+2, Cs

; now that the program's name was eliminated from out
; run string, we need to reparse the rest of the line to
; setup the FCB's properly in case called program uses them

                Mov     Si, Offset Arguments
                Mov     Di, 05Ch; First FCB
                Mov     Ax, 2901h; skip leading separators, default rest

                Mov     Di, 06Ch; Second FCB
                Mov     Ax, 2901h; same as before

                Mov     Ax, 4B00h
                Mov     Bx, Offset ParamBlock
                Mov     Dx, Offset ProgPathName
                Int     21h

                Mov     Bx, Cs
                Mov     Ds, Bx
                Mov     Es, Bx

                Jnc     Done; no error

                Mov     Bx, Offset Errors
                Add     Bx, Ax
                Add     Bx, Ax
                Cmp     Ax, 11
                Jbe     ReportError
                Mov     Bx, Offset Errors
 
ReportError:    Mov     Dx, [Bx]
                Mov     Ah, 9
                Int     21h
                Mov     Al, 1
                Ret
 
Done:           Mov     Ah, 4Dh
                Int     21h

                Ret

RunProg         EndP                

 
TryOpen         Proc    Near
                Mov     Ax, 3D00h
                Mov     Dx, Offset ProgPathName
                Int     21h
                Jc      TryOpenFail
                Mov     Bx, Ax
                Mov     Ah, 3Eh
                Int     21h;            Found file, now close it again
                Clc     ;               Mark success
TryOpenFail:    Ret
TryOpen         EndP

EndCode         Label   Near

CODE            Ends                

                End     Start

                Assume  Cs:Code,Ds:Code,Es:Code
 
 

