//
//  Source render drag/drop sample
//
//  Author : Andrew Clinch
//
//  Disclaimer :
//  In no event shall Andrew Clinch be liable for any damages whatsoever
//  (including, without limitation, damaged or loss of business profits, business
//  interruption, loss of business information, or other pecuniary loss) arising
//  out of the use or inability to use this sample code, even if Andrew Clinch
//  has been advised of the possibility of such damages.
//

/*
 * This file was generated by the SOM Compiler.
 * FileName: srctrans.CPP.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitxc: Development
 */
#define SrcTransient_Class_Source
#include "srctrans.xih"

MRESULT EXPENTRY DragWndProc( HWND hwnd, ULONG msg,
                                   MPARAM mp1, MPARAM mp2 );

HMODULE hmod;

/*
 * -- Instance Data Comment (actual defn in SrcTransient.xih)
 */
/*
typedef void SrcTransientData;
*/

/*
 * -- Method Procedures for SrcTransient
 */

/*
 * 
 *  METHOD: wpFormatDragItem                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Allow the object to set its drag info
 * 
 * 
 */

SOM_Scope BOOL   SOMLINK src_wpFormatDragItem(SrcTransient *somSelf,
		PDRAGITEM pdrgItem)
{
    HAB     hab;
    HWND    hwnd;
    PSZ     pszRealName;
    ULONG   pcbRealName=260;
    PDRAGSTRUCT  pDragData;
    /* SrcTransientData *somThis = SrcTransientGetData(somSelf); */
    SrcTransientMethodDebug("SrcTransient","src_wpFormatDragItem");

    // Call the parent method
    parent_wpFormatDragItem(somSelf,pdrgItem);

    // Set the Rendering mechanism to DRM_OS2FILE, DRF_UNKNOWN and null
    // out the hstrSourceName to force the target to send a DM_RENDER
    // to the object window
    pdrgItem->hstrRMF = DrgAddStrHandle ("<DRM_OS2FILE, DRF_UNKNOWN>");
    pdrgItem->hstrSourceName = DrgAddStrHandle ("");

    // Register the class
    hab = WinQueryAnchorBlock(HWND_DESKTOP);
    if (!WinRegisterClass( hab , "DragObjectWin", (PFNWP)DragWndProc ,
                            CS_SIZEREDRAW | CS_SYNCPAINT, sizeof(pDragData)))
        {
        return FALSE;
        }

    // Set up the window data structure
    pDragData = (PDRAGSTRUCT) somSelf->wpAllocMem(sizeof(*pDragData), FALSE);
    pDragData->somSelf = somSelf;
    pDragData->cb = sizeof(*pDragData);

    // Create the window
    hwnd =                                        /* create frame window */
        WinCreateWindow(
            HWND_OBJECT,                /* parent-window handle                    */
            "DragObjectWin",            /* pointer to registered class name        */
            "",                         /* pointer to window text                  */
            0,                          /* window style                            */
            0, 0, 0, 0,                 /* position of window                      */
            NULLHANDLE,                 /* owner-window handle                     */
            HWND_TOP,                   /* handle to sibling window                */
            (USHORT) IDD_DRAGWIN,       /* window identifier                       */
            (PVOID) pDragData,          /* pointer to buffer                       */
            NULL);                      /* pointer to structure with pres. params. */

    if (!hwnd)
        {
        return FALSE;
        }

    // Set the hwndItem to the Object window handle, so that the DM_RENDER
    // gets sent to it when a Drag/Drop occurrs
    pdrgItem->hwndItem = hwnd;

    return TRUE;
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta
/*
 * 
 *  METHOD: clsQueryModuleHandle                           ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    This method returns the module handle of this class.  If this is the
 *    first invocation, DosQueryModuleHandle is called to save the handle
 *    for future invocations.
 * 
 *  RETURN:
 * 
 *    0              Unsuccessful
 *    non-zero       module handle
 * 
 */

SOM_Scope HMODULE   SOMLINK srcM_clsQueryModuleHandle(M_SrcTransient *somSelf)
{
    PSZ     pszPathName;
    APIRET  rc;

    /* M_SrcTransientData *somThis = M_SrcTransientGetData(somSelf); */
    M_SrcTransientMethodDebug("M_SrcTransient","srcM_clsQueryModuleHandle");

    if (hmod == NULLHANDLE)
    {
       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       pszPathName = (SOMClassMgrObject->somLocateClassFile(
                        SOM_IdFromString("SrcTransient"),
                        0, 0));
       rc = DosQueryModuleHandle( pszPathName, &hmod);
       if (rc)
       {
          return 0L;
       }

    }   /* end if (hmod == NULLHANDLE) */

    return (hmod);
}

/*
 * 
 *  METHOD: clsQueryIconData                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Return the class icon.
 * 
 */

SOM_Scope ULONG   SOMLINK srcM_wpclsQueryIconData(M_SrcTransient *somSelf,
		PICONINFO pIconInfo)
{
    /* M_SrcTransientData *somThis = M_SrcTransientGetData(somSelf); */
    M_SrcTransientMethodDebug("M_SrcTransient","srcM_wpclsQueryIconData");

	if (pIconInfo)
	{
	pIconInfo->fFormat = ICON_RESOURCE;
	pIconInfo->hmod= somSelf->clsQueryModuleHandle();
	pIconInfo->resid= ID_ICON;
	}

	return (sizeof(ICONINFO));
}

/*
 *  FUNCTION:   DragWndProc
 *
 *  DESCRIPTION:
 * 
 *    Window procedure for drag window
 * 
 */
MRESULT EXPENTRY DragWndProc( HWND hwnd, ULONG msg,
                                   MPARAM mp1, MPARAM mp2 )
{
    PDRAGSTRUCT     pDragData;
    PDRAGTRANSFER   pDragTrans;
    ULONG           cbLength;
    PSZ             pBuffer;
    PSZ             pBufferEnd;
    M_SrcTransient  *somSelfClass;

	switch (msg)
	{
		case WM_CREATE:

            // Set the window pointer to our data structure
			WinSetWindowPtr(hwnd, QWL_USER, (PVOID)mp1);
            break;

        case DM_RENDER:

            // Retrieve the window pointer
			pDragData = (PDRAGSTRUCT) WinQueryWindowPtr(hwnd, QWL_USER);
			if (pDragData == NULL)
				{
				break;
				}

            // Get the DRAGTRANSFER structure
            pDragTrans = (PDRAGTRANSFER) PVOIDFROMMP(mp1);

            // Extract the target foldername and perform a copy
            // ******************************************************
            // The following few lines seem to be a bit dodgy.  If you are
            // reading this (and you are!!), and you know a better way of
            // getting object pointers to class objects etc., please send
            // me some info on CIS - 100241,1425.  I do a lot of that stuff
            // and would appreciate it if anyone could tell me how to do
            // it "cleaner"
            cbLength = DrgQueryStrName(pDragTrans->hstrRenderToName, cbLength, pBuffer);
            pBuffer = new char[cbLength+1];
            cbLength = DrgQueryStrName(pDragTrans->hstrRenderToName, cbLength, pBuffer);
            pBuffer[cbLength] = '\0';
            pBufferEnd = strrchr(pBuffer, '\\');
            pBufferEnd[0] = '\0';
            somSelfClass = (M_SrcTransient *)pDragData->somSelf->somGetClass();
            pDragData->somSelf->wpCopyObject(
                somSelfClass->wpclsQueryFolder(pBuffer, FALSE), FALSE);
            delete pBuffer;
            break;

    }   /* end switch(msg) */

	return (WinDefWindowProc(hwnd, msg, mp1, mp2) );
    
}

