'     SBFOOT.BAS demonstrates BLOADing a graphic footer on the bottom
'     row of an EGA or VGA screen in QuickBASIC programs.  Row numbers
'     at the left edge show the screen to be available for text.   If
'     running in the QB environment, keep the graphic with the host
'     program.  A footer routine can be "canned" as a SUB or $INCLUDE
'     file and reused to identify programs as yours.
'    
DEFINT A-Z
CLS
'////////////////////////// SCREEN selection  ////////////////////////////
' This routine is used to enable FOOTER.BAS as a demo with options. 
TOP:                                   
PRINT "AN EGA or VGA MONITOR IS"
PRINT "REQUIRED TO RUN."
PRINT
PRINT "Press  ESC   to End"
PRINT "Press   E    for 350 pix screen"
PRINT " Or     V    for 480 pix screen"

     DO
       TR$ = INKEY$
     LOOP WHILE TR$ = ""
       IF TR$ = CHR$(27) THEN
            CLS : END
       ELSEIF TR$ = "E" OR TR$ = "e" THEN
            SCREEN 9
            Q = 0                ' Page variables
            VP = 0
            SC = 9
            LN = 25
       ELSEIF TR$ = "V" OR TR$ = "v" THEN
            SCREEN 12
            Q = 130              ' Page variables
            VP = 5
            SC = 12
            LN = 30
       ELSE
           COLOR 14: PRINT "Press Esc, E, or V."
           SLEEP 2: COLOR 7
           CLS : GOTO TOP
       END IF
 
'--- SCREEN has been set by the user.  In most programs the routine ----
'--- above is replaced with a straight forward SCREEN9 or SCREEN12. ----
'////////////////////////////////////////////////////////////////////////
CLS
DIM PIT(902)          ' When the footer graphic is to occupy only one line,
WW$ = "AUKANDA.BAX"   ' it can be 14 tall if SCREEN 9; 16 if SCREEN 12.
DEF SEG = VARSEG(PIT(0))          ' Identify the array address and
BLOAD WW$, VARPTR(PIT(0))         ' BLOAD the graphic clip to that
DEF SEG                           ' array, PIT.   Reset default.
'--- The footer graphic is now in memory -----------------------------
'--- AUKANDA.BAX occupies 239 X 15 pixels tall.

'   Page text --------------------------------------------------------
LOCATE 8, 20: PRINT "SCREEN"; SC; ","; LN; "Lines."

LOCATE 10, 20: PRINT "Text lines are cleared using"
LOCATE 11, 20: PRINT "CLS 2 with VIEW PRINT."
LOCATE 13, 25: PRINT "Press any key to GO."

VIEW PRINT 1 TO 24 + VP
 FOR N = 1 TO 23 + VP       ' Write a number on 29 lines.
      PRINT N
 NEXT
 LOCATE 24 + VP, 1: PRINT 24 + VP;

 PUT (3, 334 + Q), PIT, PSET         'PUT array data (picture) on screen.

' --- "AUKANDA.BAX" is now on the screen --------------------------

 LINE (250, 348 + Q)-(630, 348 + Q), 7
 LINE (250, 349 + Q)-(630, 349 + Q), 9  'Footer accent line. For composition.


 WHILE INKEY$ = "": WEND  'Wait

 CLS 2: SLEEP 1         ' Clear the text lines 1 thru 29 .

'  Page 2  ------------------------------------------------------------

'   Page text ---------------------------------------------------------
 FOR N = 1 TO 23 + VP       ' Write a number on 29 lines again.
      PRINT N               ' with min. code.
 NEXT
 LOCATE 24 + VP, 1: PRINT 24 + VP; ' Line 29 must have scrolling supressed.

 LOCATE 13, 25: PRINT "Press any key to GO."
 PUT (3, 334 + Q), PIT, PSET         'PUT array data (picture) on screen.

 WHILE INKEY$ = "": WEND    ' Wait
 CLS                        ' Clear the text lines and the footer graphic.

'  Page 3  -------------------------------------------------------------

 PUT (350, 329 + Q), PIT, PSET           'PUT array data (picture) on screen.
 LINE (1, 343 + Q)-(348, 343 + Q), 7
 LINE (1, 444 + Q)-(348, 444 + Q), 9     'Footer accent line. For composition.
 SLEEP 1

'   Page text ----------------------------------------------------------
 FOR N = 1 TO 23 + VP
      PRINT N
 NEXT
 LOCATE 24 + VP, 1: PRINT 24 + VP; '  Text on the last two lines must
 LOCATE 25 + VP, 1: PRINT 25 + VP; '  end with a semicolon to suppress
                                   '  the carraige return (scroll up).

 LOCATE 10, 20: PRINT "You may still PRINT text on all rows"
 LOCATE 11, 20: PRINT "while using a graphic footer."
 LOCATE 13, 25: PRINT "Press any key to GO."
 WHILE INKEY$ = "": WEND  'Wait
 CLS
'-------------------------- Clear all and end -----------------

