#include <windows.h>
#include "test.rh"
#include "checkpw.h"

BOOL __export CALLBACK RegDlgProc(HWND  hDlg,UINT  message, WPARAM wParam, LPARAM /*lParam*/)
{
	 switch (message)
	 {
		  case WM_INITDIALOG:            /* message: initialize dialog box */
				return (TRUE);

		  case WM_COMMAND:               /* message: received a command */
				{
				switch(wParam)
					{
					case IDOK:
						{
						char szName[200];
						char szCode[200];
						GetDlgItemText(hDlg,IDC_USER, szName, sizeof(szName));
						GetDlgItemText(hDlg,IDC_SN, szCode, sizeof(szCode));
						if(CheckPassWord(szName, szCode))
							MessageBox(hDlg,"Access code is OK","",MB_OK);
						else
							MessageBox(hDlg,"Incorrect Access code ","",MB_OK);
						}
						break;

					case IDCANCEL:
						EndDialog(hDlg, FALSE); /* Exits the dialog box        */
						break;

					default:
						break;
					}
				}
				break;
	 }
	 return (FALSE);               /* Didn't process a message    */
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE /*hPrevInstance*/,
                   LPSTR /*lpCmdLine*/, int /*nCmdShow*/)
{
DialogBox(hInstance,MAKEINTRESOURCE(IDC_MAINDLG),NULL,(DLGPROC)RegDlgProc);
return TRUE;
}

