#if ! defined( NET_RESOURCE_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define NET_RESOURCE_CLASS_HEADER

class CNetResourceInformation : public CObject
{
   DECLARE_SERIAL( CNetResourceInformation )

   private:

      void m_Initialize( void );

   public:

      CNetResourceInformation();
      virtual ~CNetResourceInformation();

      /*
      ** Patterned after NETRESOURCE
      */

      CString   LocalName;
      CString   RemoteName;
      CString   Comment;
      CString   Provider;
      DWORD     Scope;
      DWORD     Type;
      DWORD     DisplayType;
      DWORD     Usage;

      virtual void Copy( NETRESOURCE *source );
      virtual void Empty( void );
      virtual void Serialize( CArchive& archive );
};

class CNetResource : public CObject
{
   DECLARE_DYNAMIC( CNetResource )

   private:

      void m_Initialize( void );

   protected:

      DWORD m_ErrorCode;

      HANDLE m_ResumeHandle;

      NETRESOURCE m_NetResource;

   public:

      enum Scope {
                    scopeConnected  = RESOURCE_CONNECTED,
                    scopeAll        = RESOURCE_GLOBALNET,
                    scopePersistent = RESOURCE_REMEMBERED
                 };

      enum Type  {
                    typeAny   = RESOURCETYPE_ANY,
                    typeDisk  = RESOURCETYPE_DISK,
                    typePrint = RESOURCETYPE_PRINT
                 };

      enum Usage {
                    usageAll         = 0,
                    usageConnectable = RESOURCEUSAGE_CONNECTABLE,
                    usageContainer   = RESOURCEUSAGE_CONTAINER
                 };

      CNetResource();
      CNetResource( LPCTSTR machine_name );
      virtual ~CNetResource();

      virtual BOOL  Enumerate( CNetResourceInformation& information );
      virtual DWORD GetErrorCode( void ) const;
      virtual BOOL  GetNext( CNetResourceInformation& information );
};

#endif // NET_RESOURCE_CLASS_HEADER
