#if ! defined( NET_SESSION_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define NET_SESSION_CLASS_HEADER

class CSessionInformation : public CObject
{
   DECLARE_SERIAL( CSessionInformation )

   private:

      void m_Initialize( void );

   public:

      CSessionInformation();
      virtual ~CSessionInformation();

      /*
      ** Patterned after SESSION_INFO_502
      */

      CString   ClientName;
      CString   UserName;
      DWORD     NumberOfOpens;
      CTimeSpan Time;
      CTimeSpan IdleTime;
      DWORD     UserFlags;
      CString   ClientTypeName;
      CString   Transport;

      virtual void Copy( SESSION_INFO_502 *source );
      virtual void Empty( void );
      virtual void Serialize( CArchive& archive );
};

class CNetSession : public CObject
{
   DECLARE_SERIAL( CNetSession )

   private:

      void m_Initialize( void );

   protected:

      CString m_ServerName;
      CString m_ClientName;

      BOOL m_Retrieved0;
      BOOL m_Retrieved1;
      BOOL m_Retrieved2;
      BOOL m_Retrieved10;
      BOOL m_Retrieved502;

      LPWSTR m_WideServerName;

      DWORD m_ErrorCode;
      DWORD m_ResumeHandle;

      virtual void m_Get_0_Data( void );
      virtual void m_Get_1_Data( void );
      virtual void m_Get_2_Data( void );
      virtual void m_Get_10_Data( void );
      virtual void m_Get_502_Data( void );

   public:

      CNetSession();
      CNetSession( LPCTSTR machine_name );
      virtual ~CNetSession();

      virtual void  Close( void );
      virtual BOOL  Enumerate( CSessionInformation& information );
      virtual DWORD GetErrorCode( void ) const;
      virtual BOOL  GetNext( CSessionInformation& information );
      virtual void  Open( LPCTSTR machine_name = NULL );
      virtual void  Serialize( CArchive& archive );
};

#endif // NET_SESSION_CLASS_HEADER
