#ifndef NAMED_PIPE_CLASS_HEADER

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define NAMED_PIPE_CLASS_HEADER

class CNamedPipe : public CDummyFile
{
   public:

      enum NamedPipeTypes
      {
         typeServerEnd = PIPE_SERVER_END,
         typeMessage   = PIPE_TYPE_MESSAGE
      };

   private:

      void m_Initialize( DWORD input_buffer_size, DWORD output_buffer_size );

   protected:

      HANDLE m_PipeHandle;

      BOOL m_AutomaticallyDelete;

      NamedPipeTypes m_TypeOfPipe; // From GetInfo()

      DWORD m_ErrorCode;

      LPVOID m_InputBuffer;
      LPVOID m_OutputBuffer;

      DWORD m_MaximumNumberOfInstances; // From GetInfo()

      DWORD m_InputBufferSize;
      DWORD m_OutputBufferSize;
      DWORD m_NumberOfBytesToWrite;
      DWORD m_NumberOfBytesRead;
      DWORD m_Timeout;

      CString m_PipeName;

      /*
      ** Information returned from GetNamedPipeHandleState()
      */

      DWORD m_PipeState;
      DWORD m_NumberOfInstances;
      DWORD m_MaximumNumberOfBytesBeforeRemoteTransmission;
      DWORD m_MaximumNumberOfMillisecondsBeforeRemoteTransmission;

      CString m_UserNameOfClientProcess;
      
   public:

      CNamedPipe( DWORD input_buffer_size = 4096, DWORD output_buffer_size = 4096 );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CNamedPipe();

      /*
      ** The Win32 API
      */

      virtual BOOL Call( CString& name_of_pipe, 
                         LPVOID   write_buffer, 
                         DWORD    size_of_write_buffer, 
                         LPVOID   read_buffer, 
                         DWORD    size_of_read_buffer, 
                         DWORD   *address_of_number_of_bytes_read,
                         DWORD    number_of_milliseconds_to_wait = NMPWAIT_WAIT_FOREVER ); // CallNamedPipe

      virtual BOOL Connect( LPOVERLAPPED overlapped_p = NULL ); // ConnectNamedPipe

      virtual BOOL Create( LPCTSTR server_name,
                           LPCTSTR name_of_pipe,
                           DWORD   open_mode       = PIPE_ACCESS_DUPLEX,
                           DWORD   type_of_pipe    = PIPE_TYPE_BYTE,
                           DWORD   number_of_pipes = PIPE_UNLIMITED_INSTANCES,
                           LPSECURITY_ATTRIBUTES security_attributes_p = NULL );

      virtual BOOL Disconnect( void ); // DisconnectNamedPipe
      virtual BOOL GetState( void ); // GetNamedPipeHandleState
      virtual BOOL GetInformation( void ); // GetNamedPipeInfo

      virtual BOOL Peek( LPVOID buffer_address,
                         DWORD  size_of_buffer,
                         DWORD& number_of_bytes_read,
                         DWORD& number_of_bytes_available,
                         DWORD& number_of_bytes_remaining_in_message );
      
      virtual BOOL SetState( DWORD new_pipe_mode,
                             DWORD maximum_number_of_bytes_before_transmission, 
                             DWORD maximum_number_of_milliseconds_before_transmission );
      
      virtual BOOL Transact( LPOVERLAPPED overlapped_p = NULL ); // TransactNamedPipe
      
      virtual BOOL Wait( LPCTSTR server_name,
                         LPCTSTR name_of_pipe, 
                         DWORD   number_of_milliseconds = NMPWAIT_USE_DEFAULT_WAIT );

      /*
      ** API's to make life a little easier 
      */

      virtual BOOL Open( void );
      virtual void Close( void );
      virtual UINT Read( void *buffer, UINT size_of_buffer );
      virtual BOOL Write( void ); // Send whatever is in the output buffer
      virtual BOOL Write( const CString& string_to_write ); // Send the string
      virtual BOOL Write( const CByteArray& data_to_write );
      virtual void Write( const void *buffer, UINT number_of_bytes_to_write );
      virtual DWORD GetErrorCode( void ) const;

      /*
      ** Operators
      */

      /*
      ** [] when reading comes from the input buffer
      ** [] when writine (putting into array) goes into outputbuffer
      */
};

#endif // NAMED_PIPE_CLASS_HEADER
