#ifndef REMOTE_ACCESS_SERVICE_CLASS_HEADER

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define REMOTE_ACCESS_SERVICE_CLASS_HEADER

#pragma warning ( disable : 4097 )

/*
** We have to declare a typedef because of the funcky way Microsoft declared RASAMB in RAS.H
*/

typedef RASAMB _rasamb;

class CRASAuthenticationMessageBlock : public _rasamb
{
   private:

      void m_Initialize( void );

   public:

      CRASAuthenticationMessageBlock();
      CRASAuthenticationMessageBlock( const RASAMB *source );
      CRASAuthenticationMessageBlock( const CRASAuthenticationMessageBlock& source );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CRASAuthenticationMessageBlock();

      void  Copy( const RASAMB *source );
      void  Copy( const CRASAuthenticationMessageBlock& source );
      BYTE  GetLana( void ) const;
      DWORD GetErrorCode( void ) const;
      void  GetErrorString( CString& return_string ) const;
};

/*
** We have to declare a typedef because of the funcky way Microsoft declared RASAMB in RAS.H
*/

typedef RASPPPNBF _raspppnbf;

class CRASNetBEUIFramer : public _raspppnbf
{
   private:

      void m_Initialize( void );

   public:

      CRASNetBEUIFramer();
      CRASNetBEUIFramer( const RASPPPNBF *source );
      CRASNetBEUIFramer( const CRASNetBEUIFramer& source );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CRASNetBEUIFramer();

      void  Copy( const RASPPPNBF* source );
      void  Copy( const CRASNetBEUIFramer& source );
      BYTE  GetLana( void ) const;
      DWORD GetErrorCode( void ) const;
      DWORD GetNetBiosErrorCode( void ) const;
      void  GetErrorString( CString& return_string ) const;
      void  GetWorkstationName( CString& return_string ) const;
};

/*
** We have to declare a typedef because of the funcky way Microsoft declared RASAMB in RAS.H
*/

typedef RASPPPIPX _raspppipx;

class CRASInternetworkPacketExchange : public _raspppipx
{
   private:

      void m_Initialize( void );

   public:

      CRASInternetworkPacketExchange();
      CRASInternetworkPacketExchange( const RASPPPIPX * source );
      CRASInternetworkPacketExchange( const CRASInternetworkPacketExchange& source );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CRASInternetworkPacketExchange();

      void   Copy( const RASPPPIPX * source );
      void   Copy( const CRASInternetworkPacketExchange& source );
      DWORD  GetErrorCode( void ) const;
      void   GetIPXAddress( CString& return_string ) const;
};

/*
** We have to declare a typedef because of the funcky way Microsoft declared RASAMB in RAS.H
*/

typedef RASPPPIP _raspppip;

class CRASInternetProtocol : public _raspppip
{
   private:

      void m_Initialize( void );

   public:

      CRASInternetProtocol();
      CRASInternetProtocol( const RASPPPIP * source );
      CRASInternetProtocol( const CRASInternetProtocol& source );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CRASInternetProtocol();

      void   Copy( const RASPPPIP * source );
      void   Copy( const CRASInternetProtocol& source );
      DWORD  GetErrorCode( void ) const;
      void   GetIPAddress( CString& return_string ) const;
};

#pragma warning ( default : 4097 )

class CRAS : public CObject
{
   private:

      void m_Initialize( void );
      void m_GetConnectionsIntoMemory( LPRASCONN& return_value, DWORD& number_of_entries );

   protected:

      LONG m_ErrorCode;

      HRASCONN m_RasConnectionHandle;

      RASCONNSTATUS m_RasConnectionStatus;

   public:

      enum Protocols
      {
         protocolAuthenticationMessageBlock = RASP_Amb,
         protocolNetBEUIFramer              = RASP_PppNbf,
         protocolInternetworkPacketExchange = RASP_PppIpx,
         protocolInternetProtocol           = RASP_PppIp
      };

      CRAS();
      CRAS( DWORD input_buffer_size );
      CRAS( DWORD input_buffer_size, DWORD output_buffer_size );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CRAS();

      /*
      ** The Win32 API
      */

      virtual BOOL Dial( LPCTSTR who_to_call ); // RasDial
      virtual HRASCONN GetConnection( LPCTSTR name_of_connection );
      virtual BOOL GetConnections( CStringArray& connections ); // RasEnumConnections
      virtual BOOL GetConnectionStatus( void ); // RasGetConnectStatus
      virtual BOOL GetErrorCode( void ) const;
      virtual BOOL GetErrorString( CString& error_string ); // RasGetErrorString
      virtual BOOL GetPhoneBookEntries( CStringArray& phone_book_entries );
      virtual BOOL GetProtocolInformation( CRASAuthenticationMessageBlock& data_to_get );
      virtual BOOL GetProtocolInformation( CRASNetBEUIFramer& data_to_get );
      virtual BOOL GetProtocolInformation( CRASInternetworkPacketExchange& data_to_get );
      virtual BOOL GetProtocolInformation( CRASInternetProtocol& data_to_get );
      virtual BOOL HangUp( LPCTSTR name_of_connection = NULL );
      virtual BOOL IsConnected( void );

      /*
      ** API's to make life a little easier 
      */

      virtual BOOL Open( LPCTSTR who_to_call ); // Dial()
      virtual BOOL Close( LPCTSTR name_of_connection = NULL ); // HangUp();

      /*
      ** Operators
      */

      /*
      ** [] when reading comes from the input buffer
      ** [] when writine (putting into array) goed into outputbuffer
      */
};

#endif // REMOTE_ACCESS_SERVICE_CLASS_HEADER
