#if ! defined( SERVER_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define SERVER_CLASS_HEADER

class CServer : public CObject
{
   DECLARE_SERIAL( CServer )

   private:

      void m_Initialize( void );

   protected:

      CString m_ServerName;
      CString m_Comment;
      CString m_UserPath;
      CString m_Domain;

      BOOL m_Retrieved102;
      BOOL m_Retrieved503;
      BOOL m_Retrieved599;

      DWORD m_MajorVersion;
      DWORD m_MinorVersion;
      DWORD m_NumberOfUsers;
      DWORD m_NumberOfOpens;
      DWORD m_Platform;
      DWORD m_Type;
      DWORD m_Users;

      LPWSTR m_WideName;

      virtual void m_Get_102_Data( void );
      virtual void m_Get_503_Data( void );
      virtual void m_Get_599_Data( void );

   public:

      CServer();
      CServer( LPCTSTR machine_name );
      virtual ~CServer();

      virtual void  Close( void );
      virtual void  GetComment( CString& comment );
      virtual void  GetDomain( CString& domain );
      virtual void  GetName( CString& name );
      virtual DWORD GetMajorVersion( void );
      virtual DWORD GetMinorVersion( void );
      virtual DWORD GetNumberOfOpens( void );
      virtual DWORD GetNumberOfUsers( void );
      virtual DWORD GetPlatform( void );
      virtual void  GetPlatformName( CString& name );
      virtual DWORD GetType( void );
      virtual void  GetUserPath( CString& path );
      virtual DWORD GetUsers( void );
      virtual void  Open( LPCTSTR machine_name = NULL );
      virtual void  Serialize( CArchive& archive );
};

#endif // SERVER_CLASS_HEADER
