#if ! defined ( URL_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define URL_CLASS_HEADER

class CUniversalNamingConvention;

class CUniformResourceLocator : public CObject
{
   DECLARE_SERIAL( CUniformResourceLocator )

   public:

      CUniformResourceLocator();
      CUniformResourceLocator( const CUniversalNamingConvention& source );
      CUniformResourceLocator( const CUniformResourceLocator& source );
      CUniformResourceLocator( LPCTSTR source );

      /*
      ** Destructor should be virtual according to MSJ article in Sept 1992
      ** "Do More with Less Code:..."
      */

      virtual ~CUniformResourceLocator();

      /*
      ** Parse stuff like:
      ** telnet://www.microsoft.com:1234
      ** socket://131.26.31.100:6000
      ** http://www.microsoft.com/hello.html
      */

      /*
      ** Data
      */

      CString ProtocolName;
      CString MachineName;
      CString PathName;
      CString PortName;
      CString URL;

      /*
      ** Methods
      */

      virtual int  Compare( const CUniformResourceLocator& source );
      virtual void Copy( const CUniformResourceLocator& source );
      virtual void Copy( const CUniversalNamingConvention& source );
      virtual void Copy( LPCTSTR source );
      virtual void Empty( void );
      virtual void Make( void );
      virtual void Serialize( CArchive& archive );

      virtual BOOL operator == ( const CUniformResourceLocator& right_url );
      virtual CUniformResourceLocator& operator = ( const CUniversalNamingConvention& source );
      virtual CUniformResourceLocator& operator = ( const CUniformResourceLocator& source );
      virtual CUniformResourceLocator& operator = ( LPCTSTR source );

      operator LPCTSTR() { return( (LPCTSTR) URL ); }
};   

#endif // URL_CLASS_HEADER
