#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL( CNetSession, CObject, 1 )

CNetSession::CNetSession()
{
   m_Initialize();
}

CNetSession::CNetSession( LPCTSTR machine_name )
{
   Open( machine_name );
}

CNetSession::~CNetSession()
{
   Close();
}

void CNetSession::Close( void )
{
   if ( m_WideServerName != NULL )
   {
      delete [] m_WideServerName;
   }

   m_Initialize();
}

BOOL CNetSession::Enumerate( CSessionInformation& information )
{
   SESSION_INFO_502 *information_p = (SESSION_INFO_502 *) NULL;

   SESSION_INFO_502 s;

   ::ZeroMemory( &s, sizeof( s ) );

   information_p = &s;

   DWORD prefered_maximum_length = sizeof( SESSION_INFO_502 ) * 128;
   DWORD number_of_entries_read  = 0;
   DWORD total_number_of_entries = 0;

   m_ErrorCode = ::NetSessionEnum( (LPTSTR) m_WideServerName, 
                    (LPTSTR) NULL, 
                    (LPTSTR) NULL, 
                     502,
                    (LPBYTE *) &information_p,
                     prefered_maximum_length,
                    &number_of_entries_read,
                    &total_number_of_entries,
                    &m_ResumeHandle );

   if ( information_p != (SESSION_INFO_502 *) NULL )
   {
      information.Copy( information_p );
      return( TRUE );
   }

   return( FALSE );
}

DWORD CNetSession::GetErrorCode( void ) const
{
   return( m_ErrorCode );
}

BOOL CNetSession::GetNext( CSessionInformation& information )
{
   return( Enumerate( information ) );
}

void CNetSession::m_Get_0_Data( void )
{
   LPBYTE buffer = (LPBYTE) NULL;

   /*
   ** One of the children got loose in the heder files again...
   **
   ** Also, we can't get 101 information because it doesn't work if you supply
   ** a machine name... Go Figure...
   */

   ::NetSessionGetInfo( (LPTSTR) m_WideServerName, NULL, NULL, 0, &buffer );

   if ( buffer != NULL )
   {
      SESSION_INFO_0 *information_p = (SESSION_INFO_0 *) buffer;

#if ! defined( UNICODE )
      ::UNICODE_to_ASCII( (LPCWSTR) information_p->sesi0_cname, information_p->sesi0_cname );
#endif

      /*
      ** Now store the info we want...
      */

      m_ServerName = information_p->sesi0_cname;
      m_Retrieved0 = TRUE;
   }
}

void CNetSession::m_Get_1_Data( void )
{
}

void CNetSession::m_Get_2_Data( void )
{
}

void CNetSession::m_Get_10_Data( void )
{
}

void CNetSession::m_Get_502_Data( void )
{
}

void CNetSession::m_Initialize( void )
{
   m_ServerName.Empty();
   m_ClientName.Empty();

   m_Retrieved0   = FALSE;
   m_Retrieved1   = FALSE;
   m_Retrieved2   = FALSE;
   m_Retrieved10  = FALSE;
   m_Retrieved502 = FALSE;

   m_WideServerName = (LPWSTR) NULL;

   m_ErrorCode    = 0;
   m_ResumeHandle = 0;
}

void CNetSession::Open( LPCTSTR server_name )
{
   Close();

   if ( server_name != NULL )
   {
      m_WideServerName = new WCHAR[ ::strlen( server_name ) + 1 ];

#if defined( UNICODE )
      ::strcpy( m_WideServerName, server_name );
#else
      ::ASCII_to_UNICODE( server_name, m_WideServerName );
#endif

      m_ServerName = server_name;
   }
}

void CNetSession::Serialize( CArchive& archive )
{
   CObject::Serialize( archive );

   if ( archive.IsStoring() )
   {
      archive << m_ServerName;
   }
   else
   {
      archive >> m_ServerName;
   }
}

/*
** CSessionInformation stuff
*/

IMPLEMENT_SERIAL( CSessionInformation, CObject, 1 )

CSessionInformation::CSessionInformation()
{
   m_Initialize();
}

CSessionInformation::~CSessionInformation()
{
   m_Initialize();
}

void CSessionInformation::Copy( SESSION_INFO_502 *source )
{
#if ! defined( UNICODE )
   ::UNICODE_to_ASCII( (LPCWSTR) source->sesi502_cname,       source->sesi502_cname       );
   ::UNICODE_to_ASCII( (LPCWSTR) source->sesi502_username,    source->sesi502_username    );
   ::UNICODE_to_ASCII( (LPCWSTR) source->sesi502_cltype_name, source->sesi502_cltype_name );
   ::UNICODE_to_ASCII( (LPCWSTR) source->sesi502_transport,   source->sesi502_transport   );
#endif

   ClientName     = source->sesi502_cname;
   UserName       = source->sesi502_username;
   ClientTypeName = source->sesi502_cltype_name;
   Transport      = source->sesi502_transport;
   NumberOfOpens  = source->sesi502_num_opens;
   Time           = CTimeSpan( source->sesi502_time      );
   IdleTime       = CTimeSpan( source->sesi502_idle_time );
   UserFlags      = source->sesi502_user_flags;

#if ! defined( UNICODE )
   ::ASCII_to_UNICODE( source->sesi502_cname,       (LPWSTR) source->sesi502_cname       );
   ::ASCII_to_UNICODE( source->sesi502_username,    (LPWSTR) source->sesi502_username    );
   ::ASCII_to_UNICODE( source->sesi502_cltype_name, (LPWSTR) source->sesi502_cltype_name );
   ::ASCII_to_UNICODE( source->sesi502_transport,   (LPWSTR) source->sesi502_transport   );
#endif
}

void CSessionInformation::Empty( void )
{
   m_Initialize();
}

void CSessionInformation::m_Initialize( void )
{
   ClientName.Empty();
   UserName.Empty();
   ClientTypeName.Empty();
   Transport.Empty();
   NumberOfOpens = 0;
   Time          = CTimeSpan( 0 );
   IdleTime      = CTimeSpan( 0 );
   UserFlags     = 0;
}

void CSessionInformation::Serialize( CArchive& archive )
{
   CObject::Serialize( archive );

   if ( archive.IsStoring() )
   {
      archive << ClientName;
      archive << UserName;
      archive << NumberOfOpens;
      archive << Time;
      archive << IdleTime;
      archive << UserFlags;
      archive << ClientTypeName;
      archive << Transport;
   }
   else
   {
      archive >> ClientName;
      archive >> UserName;
      archive >> NumberOfOpens;
      archive >> Time;
      archive >> IdleTime;
      archive >> UserFlags;
      archive >> ClientTypeName;
      archive >> Transport;
   }
}


