#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/*
** CRASAuthenticationMessageBlock
*/

CRASAuthenticationMessageBlock::CRASAuthenticationMessageBlock()
{
   m_Initialize();
}

CRASAuthenticationMessageBlock::CRASAuthenticationMessageBlock( const RASAMB *source )
{
   m_Initialize();
   Copy( source );
}

CRASAuthenticationMessageBlock::CRASAuthenticationMessageBlock( const CRASAuthenticationMessageBlock& source )
{
   m_Initialize();
   Copy( source );
}

CRASAuthenticationMessageBlock::~CRASAuthenticationMessageBlock()
{
   m_Initialize();
}

void CRASAuthenticationMessageBlock::m_Initialize( void )
{
   ::ZeroMemory( (RASAMB *) this, sizeof( RASAMB ) );
   dwSize = sizeof( RASAMB );
}

void CRASAuthenticationMessageBlock::Copy( const RASAMB *source )
{
   dwError = source->dwError;
   bLana   = source->bLana;
   ::strcpy( szNetBiosError, source->szNetBiosError );
}

void CRASAuthenticationMessageBlock::Copy( const CRASAuthenticationMessageBlock& source )
{
   dwError = source.dwError;
   bLana   = source.bLana;
   ::strcpy( szNetBiosError, source.szNetBiosError );
}

BYTE CRASAuthenticationMessageBlock::GetLana( void ) const
{
   return( bLana );
}

DWORD CRASAuthenticationMessageBlock::GetErrorCode( void ) const
{
   return( dwError );
}

void CRASAuthenticationMessageBlock::GetErrorString( CString &return_string ) const
{
   return_string = szNetBiosError;
}

/*
** CRASNetBEUIFramer
*/

CRASNetBEUIFramer::CRASNetBEUIFramer()
{
   m_Initialize();
}

CRASNetBEUIFramer::CRASNetBEUIFramer( const RASPPPNBF *source )
{
   m_Initialize();
   Copy( source );
}

CRASNetBEUIFramer::CRASNetBEUIFramer( const CRASNetBEUIFramer& source )
{
   m_Initialize();
   Copy( source );
}

CRASNetBEUIFramer::~CRASNetBEUIFramer()
{
   m_Initialize();
}

void CRASNetBEUIFramer::m_Initialize( void )
{
   ::ZeroMemory( (RASPPPNBF *) this, sizeof( RASPPPNBF ) );
   dwSize = sizeof( RASPPPNBF );
}

void CRASNetBEUIFramer::Copy( const RASPPPNBF *source )
{
   dwError        = source->dwError;
   dwNetBiosError = source->dwNetBiosError;
   bLana          = source->bLana;
   ::strcpy( szNetBiosError,    source->szNetBiosError    );
   ::strcpy( szWorkstationName, source->szWorkstationName );
}

void CRASNetBEUIFramer::Copy( const CRASNetBEUIFramer& source )
{
   dwError        = source.dwError;
   dwNetBiosError = source.dwNetBiosError;
   bLana          = source.bLana;                      
   ::strcpy( szNetBiosError,    source.szNetBiosError    );
   ::strcpy( szWorkstationName, source.szWorkstationName );
}

BYTE CRASNetBEUIFramer::GetLana( void ) const
{
   return( bLana );
}

DWORD CRASNetBEUIFramer::GetErrorCode( void ) const
{
   return( dwError );
}

DWORD CRASNetBEUIFramer::GetNetBiosErrorCode( void ) const
{
   return( dwNetBiosError );
}

void CRASNetBEUIFramer::GetErrorString( CString& return_string ) const
{
   return_string = szNetBiosError;
}

void CRASNetBEUIFramer::GetWorkstationName( CString& return_string ) const
{
   return_string = szWorkstationName;
}

/*
** CRASInternetworkPacketExchange
*/

CRASInternetworkPacketExchange::CRASInternetworkPacketExchange()
{
   m_Initialize();
}

CRASInternetworkPacketExchange::CRASInternetworkPacketExchange( const RASPPPIPX * source )
{
   m_Initialize();
   Copy( source );
}

CRASInternetworkPacketExchange::CRASInternetworkPacketExchange( const CRASInternetworkPacketExchange& source )
{
   m_Initialize();
   Copy( source );
}

CRASInternetworkPacketExchange::~CRASInternetworkPacketExchange()
{
   m_Initialize();
}

void CRASInternetworkPacketExchange::m_Initialize( void )
{
   ::ZeroMemory( (RASPPPIPX *) this, sizeof( RASPPPIPX ) );
   dwSize = sizeof( RASPPPIPX );
}

void CRASInternetworkPacketExchange::Copy( const RASPPPIPX * source )
{
   dwError = source->dwError;
   ::strcpy( szIpxAddress, source->szIpxAddress );
}

void CRASInternetworkPacketExchange::Copy( const CRASInternetworkPacketExchange& source )
{
   dwError = source.dwError;
   ::strcpy( szIpxAddress, source.szIpxAddress );
}

DWORD CRASInternetworkPacketExchange::GetErrorCode( void ) const
{
   return( dwError );
}

void CRASInternetworkPacketExchange::GetIPXAddress( CString& return_string ) const
{
   return_string =szIpxAddress;
}

/*
** CRASInternetProtocol
*/

CRASInternetProtocol::CRASInternetProtocol()
{
   m_Initialize();
}

CRASInternetProtocol::CRASInternetProtocol( const RASPPPIP * source )
{
   m_Initialize();
   Copy( source );
}

CRASInternetProtocol::CRASInternetProtocol( const CRASInternetProtocol& source )
{
   m_Initialize();
   Copy( source );
}

CRASInternetProtocol::~CRASInternetProtocol()
{
   m_Initialize();
}

void CRASInternetProtocol::m_Initialize( void )
{
   ::ZeroMemory( (RASPPPIP *) this, sizeof( RASPPPIP ) );
   dwSize = sizeof( RASPPPIP );
}

void CRASInternetProtocol::Copy( const RASPPPIP * source )
{
   dwError = source->dwError;
   ::strcpy( szIpAddress, source->szIpAddress );
}

void CRASInternetProtocol::Copy( const CRASInternetProtocol& source )
{
   dwError = source.dwError;
   ::strcpy( szIpAddress, source.szIpAddress );
}

DWORD CRASInternetProtocol::GetErrorCode( void ) const
{
   return( dwError );
}

void CRASInternetProtocol::GetIPAddress( CString& return_string ) const
{
   return_string = szIpAddress;
}

/*
** CRAS
*/

CRAS::CRAS()
{
   m_Initialize();
}

CRAS::~CRAS()
{
   m_Initialize();
}

void CRAS::m_Initialize( void )
{
   ASSERT_VALID( this );

   ::ZeroMemory( &m_RasConnectionStatus, sizeof( m_RasConnectionStatus ) );
   m_RasConnectionStatus.dwSize = sizeof( m_RasConnectionStatus );

   m_ErrorCode           = 0;
   m_RasConnectionHandle = NULL;
}

BOOL CRAS::Close( LPCTSTR name_of_connection )
{
   ASSERT_VALID( this );
   return( HangUp( name_of_connection ) );
}

BOOL CRAS::Dial( LPCTSTR who_to_dial )
{
   ASSERT_VALID( this );

   RASDIALPARAMS dialing_parameters;

   ::ZeroMemory( &dialing_parameters, sizeof( dialing_parameters ) );

   dialing_parameters.dwSize = sizeof( dialing_parameters );
   strcpy( dialing_parameters.szEntryName, who_to_dial );

   m_RasConnectionHandle = NULL;

   m_ErrorCode = ::RasDial( NULL, NULL, &dialing_parameters, 0, NULL, &m_RasConnectionHandle );

   if ( m_ErrorCode == 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

void CRAS::m_GetConnectionsIntoMemory( LPRASCONN& connections, DWORD& number_of_connections )
{
   ASSERT_VALID( this );

   DWORD size_of_buffer         = 64 * sizeof( RASCONN );
   DWORD number_of_bytes_needed = size_of_buffer;
   DWORD number_of_entries      = 0;

   LPRASCONN memory_buffer = (LPRASCONN) new BYTE[ size_of_buffer ]; // Get room for 64 entries (to begin with)

   if ( memory_buffer == NULL )
   {
      m_ErrorCode = ERROR_NOT_ENOUGH_MEMORY;
      return;
   }

   ::ZeroMemory( memory_buffer, size_of_buffer );

   memory_buffer->dwSize = sizeof( RASCONN );

   m_ErrorCode = ::RasEnumConnections( memory_buffer, &number_of_bytes_needed, &number_of_entries );

   if ( m_ErrorCode != 0 )
   {
      if ( m_ErrorCode == ERROR_BUFFER_TOO_SMALL || m_ErrorCode == ERROR_NOT_ENOUGH_MEMORY )
      {
         delete [] memory_buffer;

         memory_buffer = (LPRASCONN) new BYTE[ number_of_bytes_needed ];

         if ( memory_buffer == NULL )
         {
            m_ErrorCode = ERROR_NOT_ENOUGH_MEMORY;
            return;
         }

         ::ZeroMemory( memory_buffer, number_of_bytes_needed );

         memory_buffer->dwSize = sizeof( RASCONN );
         m_ErrorCode = ::RasEnumConnections( memory_buffer, &number_of_bytes_needed, &number_of_entries );
      }
   }

   connections           = memory_buffer;
   number_of_connections = number_of_entries;
}

HRASCONN CRAS::GetConnection( LPCTSTR name_of_connection )
{
   ASSERT_VALID( this );

   if ( name_of_connection == NULL )
   {
      return( NULL );
   }

   LPRASCONN connections       = NULL;
   DWORD     number_of_entries = 0;

   m_GetConnectionsIntoMemory( connections, number_of_entries );

   HRASCONN return_value = NULL;

   if ( m_ErrorCode == 0 )
   {
      DWORD index = 0;

      while( index < number_of_entries )
      {
         if ( ::strcmpi( name_of_connection, connections[ index ].szEntryName ) == 0 )
         {
            return_value = connections[ index ].hrasconn;
            index = number_of_entries;
         }

         index++;
      }
   }

   delete [] connections;

   return( return_value );
}

BOOL CRAS::GetConnections( CStringArray& connection_names )
{
   ASSERT_VALID( this );

   connection_names.RemoveAll();

   LPRASCONN connections       = NULL;
   DWORD     number_of_entries = 0;

   m_GetConnectionsIntoMemory( connections, number_of_entries );

   BOOL return_value = FALSE;

   if ( m_ErrorCode == 0 )
   {
      return_value = TRUE;

      DWORD index = 0;

      while( index < number_of_entries )
      {
         connection_names.Add( connections[ index ].szEntryName );
         index++;
      }
   }

   delete [] connections;

   return( return_value );
}

BOOL CRAS::GetConnectionStatus( void )
{
   ASSERT_VALID( this );

   m_ErrorCode = ::RasGetConnectStatus( m_RasConnectionHandle, &m_RasConnectionStatus );

   if ( m_ErrorCode == 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CRAS::GetErrorCode( void ) const
{
   ASSERT_VALID( this );
   return( m_ErrorCode );
}

BOOL CRAS::GetErrorString( CString& return_string )
{
   ASSERT_VALID( this );

   TCHAR string[ 4096 ];

   ::ZeroMemory( string, sizeof( string ) );

   if ( ::RasGetErrorString( m_ErrorCode, string, sizeof( string ) ) == 0 )
   {
      return_string = string;
      return( TRUE );
   }
   else
   {
      return_string.Empty();
      return( FALSE );
   }
}

BOOL CRAS::GetPhoneBookEntries( CStringArray& phone_book_entries )
{
   ASSERT_VALID( this );

   phone_book_entries.RemoveAll();

   DWORD size_of_buffer         = 64 * sizeof( RASENTRYNAME );
   DWORD number_of_bytes_needed = size_of_buffer;
   DWORD number_of_entries      = 0;

   LPRASENTRYNAME memory_buffer = (LPRASENTRYNAME) new BYTE[ size_of_buffer ]; // Get room for 64 entries (to begin with)

   if ( memory_buffer == NULL )
   {
      m_ErrorCode = ERROR_NOT_ENOUGH_MEMORY;
      return( FALSE );
   }

   ::ZeroMemory( memory_buffer, size_of_buffer );

   memory_buffer->dwSize = sizeof( RASENTRYNAME );

   m_ErrorCode = ::RasEnumEntries( NULL, NULL, memory_buffer, &number_of_bytes_needed, &number_of_entries );

   if ( m_ErrorCode != 0 )
   {
      if ( m_ErrorCode == ERROR_BUFFER_TOO_SMALL || m_ErrorCode == ERROR_NOT_ENOUGH_MEMORY )
      {
         delete [] memory_buffer;

         memory_buffer = (LPRASENTRYNAME) new BYTE[ number_of_bytes_needed ];

         if ( memory_buffer == NULL )
         {
            m_ErrorCode = ERROR_NOT_ENOUGH_MEMORY;
            return( FALSE );
         }

         ::ZeroMemory( memory_buffer, number_of_bytes_needed );

         memory_buffer->dwSize = sizeof( RASENTRYNAME );
         m_ErrorCode = ::RasEnumEntries( NULL, NULL, memory_buffer, &number_of_bytes_needed, &number_of_entries );
      }
   }

   BOOL return_value = FALSE;

   if ( m_ErrorCode == 0 )
   {
      return_value = TRUE;

      DWORD index = 0;

      while( index < number_of_entries )
      {
         phone_book_entries.Add( memory_buffer[ index ].szEntryName );
         index++;
      }
   }

   delete [] memory_buffer;

   return( return_value );
}

BOOL CRAS::GetProtocolInformation( CRASAuthenticationMessageBlock& data_to_get )
{
   ASSERT_VALID( this );

   RASAMB return_data;

   DWORD size_of_return_data = sizeof( return_data );

   ::ZeroMemory( &return_data, size_of_return_data );

   return_data.dwSize = size_of_return_data;

   if ( ::RasGetProjectionInfo( m_RasConnectionHandle, RASP_Amb, (LPVOID) &return_data, &size_of_return_data ) == 0 )
   {
      data_to_get.Copy( CRASAuthenticationMessageBlock( &return_data ) );

      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CRAS::GetProtocolInformation( CRASNetBEUIFramer& data_to_get )
{
   ASSERT_VALID( this );

   RASPPPNBF return_data;

   DWORD size_of_return_data = sizeof( return_data );

   ::ZeroMemory( &return_data, size_of_return_data );

   return_data.dwSize = size_of_return_data;

   if ( ::RasGetProjectionInfo( m_RasConnectionHandle, RASP_PppNbf, (LPVOID) &return_data, &size_of_return_data ) == 0 )
   {
      data_to_get.Copy( CRASNetBEUIFramer( &return_data ) );

      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CRAS::GetProtocolInformation( CRASInternetworkPacketExchange& data_to_get )
{
   ASSERT_VALID( this );

   RASPPPIPX return_data;

   DWORD size_of_return_data = sizeof( return_data );

   ::ZeroMemory( &return_data, size_of_return_data );

   return_data.dwSize = size_of_return_data;

   if ( ::RasGetProjectionInfo( m_RasConnectionHandle, RASP_PppIpx, (LPVOID) &return_data, &size_of_return_data ) == 0 )
   {
      data_to_get.Copy( CRASInternetworkPacketExchange( &return_data ) );

      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CRAS::GetProtocolInformation( CRASInternetProtocol& data_to_get )
{
   ASSERT_VALID( this );

   RASPPPIP return_data;

   DWORD size_of_return_data = sizeof( return_data );

   ::ZeroMemory( &return_data, size_of_return_data );

   return_data.dwSize = size_of_return_data;

   if ( ::RasGetProjectionInfo( m_RasConnectionHandle, RASP_PppIp, (LPVOID) &return_data, &size_of_return_data ) == 0 )
   {
      data_to_get.Copy( CRASInternetProtocol( &return_data ) );

      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CRAS::HangUp( LPCTSTR name_of_connection )
{
   ASSERT_VALID( this );

   if ( name_of_connection == NULL )
   {
      m_ErrorCode = ::RasHangUp( m_RasConnectionHandle );
      m_RasConnectionHandle = NULL;
   }
   else
   {
      HRASCONN temp_handle = GetConnection( name_of_connection );
      m_ErrorCode = ::RasHangUp( temp_handle );
   }

   if ( m_ErrorCode == 0 )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}

BOOL CRAS::IsConnected( void )
{
   ASSERT_VALID( this );

   GetConnectionStatus();

   if ( m_RasConnectionStatus.rasconnstate == RASCS_Connected )
   {
      return( TRUE );
   }
   else
   {
      return( FALSE );
   }
}
                                                              
BOOL CRAS::Open( LPCTSTR what_to_open )
{
   ASSERT_VALID( this );
   return( Dial( what_to_open ) );
}

