#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CDeviceControlBlock::CDeviceControlBlock()
{
   DCBlength = sizeof( DCB );
   fBinary = TRUE; // Always TRUE for NT
}

CDeviceControlBlock::CDeviceControlBlock( const DCB * source )
{
   DCBlength = sizeof( DCB );

   Copy( source );
}

CDeviceControlBlock::~CDeviceControlBlock()
{
   DCBlength = 0;
}

void CDeviceControlBlock::Copy( const CDeviceControlBlock& source )
{
   Copy( (DCB *) &source );
}

void CDeviceControlBlock::Copy( const DCB* source )
{
   BaudRate          = source->BaudRate;
   fBinary           = source->fBinary;
   fParity           = source->fParity;
   fOutxCtsFlow      = source->fOutxCtsFlow;
   fOutxDsrFlow      = source->fOutxDsrFlow;
   fDtrControl       = source->fDtrControl;
   fDsrSensitivity   = source->fDsrSensitivity;
   fTXContinueOnXoff = source->fTXContinueOnXoff;
   fOutX             = source->fOutX;
   fInX              = source->fInX;
   fErrorChar        = source->fErrorChar;
   fNull             = source->fNull;
   fRtsControl       = source->fRtsControl;
   fDummy2           = source->fDummy2;
   wReserved         = source->wReserved;
   XonLim            = source->XonLim;
   XoffLim           = source->XoffLim;
   ByteSize          = source->ByteSize;
   Parity            = source->Parity;
   StopBits          = source->StopBits;
   XonChar           = source->XonChar;
   XoffChar          = source->XoffChar;
   ErrorChar         = source->ErrorChar;
   EofChar           = source->EofChar;
   EvtChar           = source->EvtChar;
}
