#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL( CDrawingObjectGrid, CObject, 1 )

CDrawingObjectGrid::CDrawingObjectGrid()
{
   m_Initialize();
}

CDrawingObjectGrid::CDrawingObjectGrid( DWORD number_of_rows, DWORD number_of_columns )
{
   m_Initialize();
   SetSize( number_of_rows, number_of_columns );
}

CDrawingObjectGrid::~CDrawingObjectGrid()
{
   RemoveAll();
}

void CDrawingObjectGrid::Draw( CDC& device_context )
{
   int index = 0;
   int number_of_elements = m_ObjectArray.GetSize();

   CRectangle *object_p = (CRectangle *) NULL;

   while( index < number_of_elements )
   {
      object_p = (CRectangle *) m_ObjectArray[ index ];
      
      if ( object_p != NULL )
      {
         object_p->Draw( device_context );
      }

      index++;
   }
}

CRectangle*& CDrawingObjectGrid::ElementAt( DWORD row_number, DWORD column_number )
{
   return( (CRectangle *&) m_ObjectArray.ElementAt( ( row_number * m_NumberOfColumns ) + column_number ) );
}

CRectangle* CDrawingObjectGrid::GetAt( DWORD row_number, DWORD column_number )
{
   return( (CRectangle *) m_ObjectArray.ElementAt( ( row_number * m_NumberOfColumns ) + column_number ) );
}

DWORD CDrawingObjectGrid::GetHeight( void ) const
{
   DWORD height = 0;
   DWORD index  = 0;

   CRectangle *object_p = (CRectangle *) NULL;

   while( index < m_NumberOfRows )
   {
      object_p = (CRectangle *) m_ObjectArray[ index ];

      if ( object_p != NULL )
      {
         height += object_p->GetHeight();
         height += m_VerticalSpacing;
      }

      index++;
   }

   if ( m_NumberOfRows > 0 )
   {
      height -= m_VerticalSpacing;
   }

   return( height );
}

int CDrawingObjectGrid::GetHorizontalSpacing( void ) const
{
   return( m_HorizontalSpacing );
}

BOOL CDrawingObjectGrid::GetIndexFromPoint( DWORD& _row_index, DWORD& _column_index, const CPoint& point )
{
   DWORD row_index    = 0;
   DWORD column_index = 0;

   CRectangle *object_p = (CRectangle *) NULL;

   CRect rectangle;

   while( row_index < (DWORD) m_NumberOfRows )
   {
      column_index = 0;

      while( column_index < (DWORD) m_NumberOfColumns )
      {
         object_p = GetAt( row_index, column_index );

         if ( object_p != NULL )
         {
            object_p->GetRectangle( rectangle );

            if ( rectangle.PtInRect( point ) == TRUE )
            {
               _row_index    = row_index;
               _column_index = column_index;
               return( TRUE );
            }
         }

         column_index++;
      }

      row_index++;
   }

   return( FALSE );
}

void CDrawingObjectGrid::GetName( CString& name_of_grid ) const
{
   name_of_grid = m_Name;
}

DWORD CDrawingObjectGrid::GetNumberOfColumns( void ) const
{
   return( m_NumberOfColumns );
}

DWORD CDrawingObjectGrid::GetNumberOfRows( void ) const
{
   return( m_NumberOfRows );
}

void CDrawingObjectGrid::GetRectangle( CRect& rectangle ) const
{
   if ( m_ObjectArray[ 0 ] == NULL )
   {
      rectangle.SetRectEmpty();
      return;
   }

   CRectangle *object_p = (CRectangle *) m_ObjectArray[ 0 ];

   if ( object_p == NULL )
   {
      rectangle.SetRectEmpty();
      return;
   }

   CRect object_rectangle;

   object_p->GetRectangle( object_rectangle );

   rectangle.left   = object_rectangle.left;
   rectangle.top    = object_rectangle.top;
   rectangle.right  = rectangle.left + GetWidth();
   rectangle.bottom = rectangle.top  + GetHeight();
}

DWORD CDrawingObjectGrid::GetVerticalSpacing( void ) const
{
   return( m_VerticalSpacing );
}

DWORD CDrawingObjectGrid::GetWidth( void ) const
{
   DWORD width = 0;
   DWORD index = 0;

   CRectangle *object_p = NULL;

   while( index < m_NumberOfColumns )
   {
      object_p = (CRectangle *) m_ObjectArray[ index ];

      if ( object_p != NULL )
      {
         width += object_p->GetWidth();
         width += m_HorizontalSpacing;
      }

      index++;
   }

   if ( m_NumberOfColumns > 0 )
   {
      width -= m_HorizontalSpacing;
   }

   return( width );
}

void CDrawingObjectGrid::m_Initialize( void )
{
   RemoveAll();
   m_VerticalSpacing   = 1;
   m_HorizontalSpacing = 1;
   m_NumberOfRows      = 0;
   m_NumberOfColumns   = 0;

   m_Name.Empty();
}

void CDrawingObjectGrid::RemoveAll( void )
{
   int index = 0;
   int number_of_elements = m_ObjectArray.GetSize();

   CRectangle *object_p = NULL;

   while( index < number_of_elements )
   {
      object_p = (CRectangle *) m_ObjectArray[ index ];

      if ( object_p != NULL )
      {
         delete object_p;
      }

      index++;
   }

   m_ObjectArray.RemoveAll();

   m_NumberOfRows    = 0;
   m_NumberOfColumns = 0;
}

void CDrawingObjectGrid::Serialize( CArchive& archive )
{
   CObject::Serialize( archive );

   if ( archive.IsStoring() )
   {
      archive << m_NumberOfRows;
      archive << m_NumberOfColumns;
      archive << m_VerticalSpacing;
      archive << m_HorizontalSpacing;
      archive << m_Name;
   }
   else
   {
      archive >> m_NumberOfRows;
      archive >> m_NumberOfColumns;
      archive >> m_VerticalSpacing;
      archive >> m_HorizontalSpacing;
      archive >> m_Name;
   }

   m_ObjectArray.Serialize( archive );
}

void CDrawingObjectGrid::SetAt( DWORD row_number, DWORD column_number, CRectangle *new_element )
{
   DWORD index = ( row_number * m_NumberOfColumns ) + column_number;

   CRectangle *object_p = (CRectangle *) m_ObjectArray[ index ];

   if ( object_p != NULL )
   {
      if ( object_p == new_element )
      {
         return;
      }
      else
      {
         delete object_p;
      }
   }

   m_ObjectArray[ index ] = new_element;
}

void CDrawingObjectGrid::SetFillColor( DWORD row_number, DWORD column_number, COLORREF color )
{
   CRectangle *object_p = GetAt( row_number, column_number );

   if ( object_p != NULL )
   {
      object_p->SetFillColor( color );
   }
}

void CDrawingObjectGrid::SetHorizontalSpacing( DWORD horizontal_spacing )
{
   m_HorizontalSpacing = horizontal_spacing;
}

void CDrawingObjectGrid::SetLineColor( DWORD row_number, DWORD column_number, COLORREF color )
{
   CRectangle *object_p = GetAt( row_number, column_number );

   if ( object_p != NULL )
   {
      object_p->SetLineColor( color );
   }
}

void CDrawingObjectGrid::SetName( LPCTSTR name_of_grid )
{
   if ( name_of_grid != NULL )
   {
      m_Name = name_of_grid;
   }
   else
   {
      m_Name.Empty();
   }
}

void CDrawingObjectGrid::SetRectangle( const CRect& source )
{
   if ( m_ObjectArray[ 0 ] == NULL )
   {
      return;
   }

   CRectangle *object_p = (CRectangle *) m_ObjectArray[ 0 ];

   if ( object_p == NULL )
   {
      return;
   }

   DWORD vertical_size   = object_p->GetHeight();
   DWORD horizontal_size = object_p->GetWidth();

   DWORD vertical_location   = source.top;
   DWORD horizontal_location = source.left;

   DWORD column_index = 0;
   DWORD row_index    = 0;

   CPoint point;

   while( row_index < m_NumberOfRows )
   {
      column_index        = 0;
      horizontal_location = source.left;

      while( column_index < m_NumberOfColumns )
      {
         point.x = horizontal_location;
         point.y = vertical_location;

         object_p = GetAt( row_index, column_index );

         if ( object_p != NULL )
         {
            object_p->SetLocation( point );
         }

         horizontal_location += (horizontal_size + m_HorizontalSpacing );
         column_index++;
      }

      vertical_location += ( vertical_size + m_VerticalSpacing );
      row_index++;
   }
}

void CDrawingObjectGrid::SetSize( DWORD number_of_rows, DWORD number_of_columns )
{
   RemoveAll();

   m_NumberOfRows    = number_of_rows;
   m_NumberOfColumns = number_of_columns;
   m_ObjectArray.SetSize( m_NumberOfRows * m_NumberOfColumns );
}

void CDrawingObjectGrid::SetVerticalSpacing( DWORD vertical_spacing )
{
   m_VerticalSpacing = vertical_spacing;
}

/*
** And now for some labels
*/

IMPLEMENT_SERIAL( CLabeledGrid, CDrawingObjectGrid, 1 )

CLabeledGrid::CLabeledGrid()
{
   m_Initialize();
}

CLabeledGrid::CLabeledGrid( DWORD number_of_rows, DWORD number_of_columns )
{
   m_Initialize();
   SetSize( number_of_rows, number_of_columns );
}

CLabeledGrid::~CLabeledGrid()
{
   m_RowNamesFont.DeleteObject();
   m_RowsTitleFont.DeleteObject();
   m_ColumnNamesFont.DeleteObject();
   m_ColumnsTitleFont.DeleteObject();
}

void CLabeledGrid::Draw( CDC& device_context )
{
   /*
   ** Go draw the CRectangles...
   */

   CDrawingObjectGrid::Draw( device_context );

   int x_coordinate = 0;
   int y_coordinate = 0;
   int left_margin  = 0;
   int top_margin   = 0;

   CRectangle *rectangle_p = NULL;

   CRect rect;

   CString name;

   DWORD index = 0;

   CFont *old_font;

   CString grid_name;

   old_font = device_context.SelectObject( &m_RowNamesFont );

   rectangle_p = GetAt( 0, 0 );
   rectangle_p->GetRectangle( rect );

   left_margin = rect.left;
   top_margin  = rect.top;

   if ( m_LabelOptions & LABELED_GRID_ROW_NAMES )
   {
      index = 0;

      device_context.SelectObject( &m_RowNamesFont );

      left_margin -= ( m_NumberOfLogicalUnitsInLongestRowName + ( m_HorizontalSpacing * 2 ) );

      while( index < m_NumberOfRows )
      {
         rectangle_p = GetAt( index, 0 );

         rectangle_p->GetRectangle( rect );

         GetRowName( index, name );

         device_context.TextOut( left_margin, rect.top, name );

         index++;
      }
   }

   if ( m_LabelOptions & LABELED_GRID_COLUMN_NAMES )
   {
      index = 0;

      device_context.SelectObject( &m_ColumnNamesFont );

      top_margin -= ( m_VerticalSpacing + 20 ); // Should be height of column names font

      while( index < m_NumberOfColumns )
      {
         rectangle_p = GetAt( 0, index );

         rectangle_p->GetRectangle( rect );

         GetColumnName( index, name );

         device_context.TextOut( rect.left, top_margin, name );

         index++;
      }
   }

   if ( m_LabelOptions & LABELED_GRID_COLUMNS_TITLE )
   {
      GetRectangle( rect );

      x_coordinate  = rect.left;
      x_coordinate += ( rect.Width() / 2 );
      x_coordinate -= ( m_NumberOfLogicalUnitsInColumnsTitle / 2 );
      y_coordinate  = ( top_margin - 30 );

      GetColumnsTitle( name );
      device_context.SelectObject( &m_ColumnsTitleFont );
      device_context.TextOut( x_coordinate, y_coordinate, name );
   }

   if ( m_LabelOptions & LABELED_GRID_ROWS_TITLE )
   {
      GetRectangle( rect );

      y_coordinate = rect.bottom;

      GetRowsTitle( name );
      device_context.SelectObject( &m_RowsTitleFont );

      x_coordinate  = ( left_margin - 30 ); // Should be "- Font.Height()" instead of "- 30"
      y_coordinate -= ( rect.Width() / 2 );
      y_coordinate += ( m_NumberOfLogicalUnitsInRowsTitle / 2 );

      device_context.TextOut( x_coordinate, y_coordinate, name );
   }

   device_context.SelectObject( old_font );
}

void CLabeledGrid::GetColumnName( DWORD column_number, CString& column_name ) const
{
   if ( column_number >= (DWORD) m_ColumnNames.GetSize() )
   {
      column_name.Empty();
      return;
   }

   column_name = m_ColumnNames[ column_number ];
}

void CLabeledGrid::GetColumnsTitle( CString& columns_title ) const
{
   columns_title = m_ColumnsTitle;
}

void CLabeledGrid::GetRowName( DWORD row_number, CString& row_name ) const
{
   if ( row_number >= (DWORD) m_RowNames.GetSize() )
   {
      row_name.Empty();
      return;
   }

   row_name = m_RowNames[ row_number ];
}

void CLabeledGrid::GetRowsTitle( CString& rows_title ) const
{
   rows_title = m_RowsTitle;
}

void CLabeledGrid::m_Initialize( void )
{
   m_ColumnFontSize                          = 0;
   m_ColumnsTitleFontSize                    = 0;
   m_RowFontSize                             = 0;
   m_RowsTitleFontSize                       = 0;
   m_NumberOfLogicalUnitsInLongestRowName    = 0;
   m_NumberOfLogicalUnitsInLongestColumnName = 0;
   m_NumberOfLogicalUnitsInRowsTitle         = 0;
   m_NumberOfLogicalUnitsInColumnsTitle      = 0;
   m_LabelOptions                            = 0;
   m_RowsTitle.Empty();
   m_ColumnsTitle.Empty();
}

void CLabeledGrid::m_SetColumnFontSize( CDC& device_context, DWORD font_size )
{
   m_ColumnFontSize = font_size;

   TRY
   {
      LOGFONT lf;

      ::ZeroMemory( &lf, sizeof( lf ) );

      lf.lfHeight         = -::MulDiv( m_ColumnFontSize, device_context.GetDeviceCaps( LOGPIXELSY ), 72 );
      lf.lfCharSet        = DEFAULT_CHARSET;
      lf.lfQuality        = DEFAULT_QUALITY;
      lf.lfWeight         = FW_NORMAL;
      lf.lfClipPrecision  = CLIP_LH_ANGLES | CLIP_STROKE_PRECIS;
      lf.lfPitchAndFamily = FF_SWISS;
      lf.lfEscapement     = 0;

      m_ColumnNamesFont.CreateFontIndirect( &lf );
   }
   CATCH( CResourceException, e )
   {
      TRACE( "CLabeledGrid::m_SetColumnFontSize(), font creation failed\n" );
      return;
   }
   END_CATCH
}

void CLabeledGrid::m_SetColumnsTitleFontSize( CDC& device_context, DWORD font_size )
{
   m_ColumnsTitleFontSize = font_size;

   TRY
   {
      LOGFONT lf;

      ::ZeroMemory( &lf, sizeof( lf ) );

      lf.lfHeight         = -::MulDiv( m_ColumnsTitleFontSize, device_context.GetDeviceCaps( LOGPIXELSY ), 72 );
      lf.lfCharSet        = DEFAULT_CHARSET;
      lf.lfQuality        = DEFAULT_QUALITY;
      lf.lfWeight         = FW_NORMAL;
      lf.lfClipPrecision  = CLIP_LH_ANGLES | CLIP_STROKE_PRECIS;
      lf.lfPitchAndFamily = FF_SWISS;
      lf.lfEscapement     = 0;

      m_ColumnsTitleFont.CreateFontIndirect( &lf );
   }
   CATCH( CResourceException, e )
   {
      TRACE( "CLabeledGrid::m_SetColumnsTitleFontSize(), font creation failed\n" );
      return;
   }
   END_CATCH
}

void CLabeledGrid::m_SetRowFontSize( CDC& device_context, DWORD font_size )
{
   m_RowFontSize = font_size;

   TRY
   {
      LOGFONT lf;

      ::ZeroMemory( &lf, sizeof( lf ) );

      lf.lfHeight         = -::MulDiv( m_RowFontSize, device_context.GetDeviceCaps( LOGPIXELSY ), 72 );
      lf.lfCharSet        = DEFAULT_CHARSET;
      lf.lfQuality        = DEFAULT_QUALITY;
      lf.lfWeight         = FW_NORMAL;
      lf.lfClipPrecision  = CLIP_LH_ANGLES | CLIP_STROKE_PRECIS;
      lf.lfPitchAndFamily = FF_SWISS;
      lf.lfEscapement     = 0;

      m_RowNamesFont.CreateFontIndirect( &lf );
   }
   CATCH( CResourceException, e )
   {
      TRACE( "CLabeledGrid::m_SetColumnFontSize(), font creation failed\n" );
      return;
   }
   END_CATCH
}

void CLabeledGrid::m_SetRowsTitleFontSize( CDC& device_context, DWORD font_size )
{
   m_RowsTitleFontSize = font_size;

   TRY
   {
      LOGFONT lf;

      ::ZeroMemory( &lf, sizeof( lf ) );

      lf.lfHeight         = -::MulDiv( m_RowsTitleFontSize, device_context.GetDeviceCaps( LOGPIXELSY ), 72 );
      lf.lfCharSet        = DEFAULT_CHARSET;
      lf.lfQuality        = DEFAULT_QUALITY;
      lf.lfWeight         = FW_NORMAL;
      lf.lfClipPrecision  = CLIP_LH_ANGLES | CLIP_STROKE_PRECIS;
      lf.lfPitchAndFamily = FF_SWISS;
      lf.lfEscapement     = 900;

      m_RowsTitleFont.CreateFontIndirect( &lf );
   }
   CATCH( CResourceException, e )
   {
      TRACE( "CLabeledGrid::m_SetColumnFontSize(), font creation failed\n" );
      return;
   }
   END_CATCH
}

void CLabeledGrid::PrepareForPainting( CDC&  device_context, 
                                       DWORD row_font_size,
                                       DWORD column_font_size,
                                       DWORD rows_title_font_size,
                                       DWORD columns_title_font_size )
{
   m_SetColumnFontSize( device_context, column_font_size );
   m_SetRowFontSize( device_context, row_font_size );
   m_SetColumnsTitleFontSize( device_context, columns_title_font_size );
   m_SetRowsTitleFontSize( device_context, rows_title_font_size );

   CSize size;

   DWORD index         = 0;
   DWORD biggest_value = 0;

   CFont *old_font = (CFont *) NULL;

   old_font = device_context.SelectObject( &m_RowsTitleFont );

   size = device_context.GetTextExtent( m_RowsTitle, m_RowsTitle.GetLength() );

   m_NumberOfLogicalUnitsInRowsTitle = size.cx;

   device_context.SelectObject( &m_ColumnsTitleFont );

   size = device_context.GetTextExtent( m_ColumnsTitle, m_ColumnsTitle.GetLength() );

   m_NumberOfLogicalUnitsInColumnsTitle = size.cx;

   device_context.SelectObject( &m_RowNamesFont );

   CString name;

   while( index < m_NumberOfRows )
   {
      GetRowName( index, name );

      if ( (DWORD) name.GetLength() > biggest_value )
      {
         size = device_context.GetTextExtent( name, name.GetLength() );
      }

      index++;
   }

   m_NumberOfLogicalUnitsInLongestRowName = size.cx;

   index         = 0;
   biggest_value = 0;

   device_context.SelectObject( &m_ColumnNamesFont );

   while( index < m_NumberOfColumns )
   {
      GetColumnName( index, name );

      if ( (DWORD) name.GetLength() > biggest_value )
      {
         size = device_context.GetTextExtent( name, name.GetLength() );
      }

      index++;
   }

   m_NumberOfLogicalUnitsInLongestColumnName = size.cx;

   device_context.SelectObject( old_font );
}

void CLabeledGrid::RemoveAll()
{
   CDrawingObjectGrid::RemoveAll();

   m_ColumnNames.RemoveAll();
   m_RowNames.RemoveAll();
}

void CLabeledGrid::Serialize( CArchive& archive )
{
   CDrawingObjectGrid::Serialize( archive );

   if ( archive.IsStoring() )
   {
      archive << m_ColumnsTitle;
      archive << m_RowsTitle;
   }
   else
   {
      archive >> m_ColumnsTitle;
      archive >> m_RowsTitle;
   }

   m_ColumnNames.Serialize( archive );
   m_RowNames.Serialize( archive );
}

void CLabeledGrid::SetColumnName( DWORD column_number, LPCTSTR column_name )
{
   if ( column_number > m_NumberOfColumns )
   {
      return;
   }

   if ( column_name == NULL )
   {
      m_ColumnNames.SetAt( column_number, "" );
   }
   else
   {
      m_ColumnNames.SetAt( column_number, column_name );
   }
}

void CLabeledGrid::SetColumnsTitle( LPCTSTR columns_title )
{
   if ( columns_title == NULL )
   {
      m_ColumnsTitle.Empty();
   }
   else
   {
      m_ColumnsTitle = columns_title;
   }
}

void CLabeledGrid::SetLabelOptions( DWORD options )
{
   m_LabelOptions = options;
}

void CLabeledGrid::SetRowName( DWORD row_number, LPCTSTR row_name )
{
   if ( row_number > m_NumberOfRows )
   {
      return;
   }

   if ( row_name == NULL )
   {
      m_RowNames.SetAt( row_number, "" );
   }
   else
   {
      m_RowNames.SetAt( row_number, row_name );
   }
}

void CLabeledGrid::SetRowsTitle( LPCTSTR rows_title )
{
   if ( rows_title == NULL )
   {
      m_RowsTitle.Empty();
   }
   else
   {
      m_RowsTitle = rows_title;
   }
}

void CLabeledGrid::SetSize( DWORD number_of_rows, DWORD number_of_columns )
{
   CDrawingObjectGrid::SetSize( number_of_rows, number_of_columns );

   m_ColumnNames.SetSize( m_NumberOfColumns );
   m_RowNames.SetSize( m_NumberOfRows );
}
