#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CLZFile::CLZFile()
{
   m_Initialize( 4096, 4096 );
}

CLZFile::~CLZFile()
{
   TRACE( "Destroying a CSimpleSocket object\n" );
   Close();
}

void CLZFile::Close( void )
{
   ASSERT_VALID( this );

   if ( m_FileHandle >= 0 )
   {
      ::LZClose( m_FileHandle );
      m_FileHandle = LZERROR_BADINHANDLE;
      m_hFile = CFile::hFileNull;
      Name.Empty();
   }
}

LONG CLZFile::GetErrorCode( void ) const
{
   return( m_ErrorCode );
}

LONG CLZFile::Seek( LONG offset, UINT from )
{
	ASSERT_VALID( this );
	ASSERT( m_hFile != (UINT) hFileNull );
	ASSERT( from == begin || from == end || from == current);
	ASSERT( begin == FILE_BEGIN && end == FILE_END && current == FILE_CURRENT );

	DWORD dwNew = ::LZSeek( (HANDLE) m_FileHandle, offset, from );

	if (dwNew  < 0 )
   {
		CFileException::ThrowOsError( dwNew );
   }

	return( dwNew );
}

