#include <wfc.h>

CNamedPipe::CNamedPipe( DWORD _input_buffer_size, DWORD _output_buffer_size )
{
   m_Initialize( _input_buffer_size, _output_buffer_size );
}

CNamedPipe::~CNamedPipe()
{
   if ( m_AutomaticallyDelete == TRUE )
   {
      if ( m_PipeHandle != (HANDLE) NULL )
      {
         Close();
      }
   }

   if ( m_InputBuffer != (LPVOID) NULL )
   {
      /*
      ** Free our memory
      */

      delete [] m_InputBuffer;

      m_InputBuffer = (LPVOID) NULL;
      m_InputBufferSize = 0L;
   }

   if ( m_OutputBuffer != (LPVOID) NULL )
   {
      /*
      ** Free our memory
      */

      delete [] m_OutputBuffer;

      m_OutputBuffer = (LPVOID) NULL;
      m_OutputBufferSize = 0L;
   }
}

void CNamedPipe::m_Initialize( DWORD _input_buffer_size, DWORD _output_buffer_size )
{
   m_AutomaticallyDelete = TRUE;
   m_ErrorCode  = 0L;
   m_PipeHandle = INVALID_HANDLE_VALUE;
   m_Timeout    = NMPWAIT_USE_DEFAULT_WAIT;
   m_PipeName.Empty();

   m_InputBufferSize  = _input_buffer_size;
   m_OutputBufferSize = _output_buffer_size;

   m_InputBuffer  = new BYTE[ m_InputBufferSize  ];
   m_OutputBuffer = new BYTE[ m_OutputBufferSize ];
}

BOOL CNamedPipe::Call( CString& pipe_name, 
                       LPVOID   write_buffer, 
                       DWORD    size_of_write_buffer, 
                       LPVOID   read_buffer, 
                       DWORD    size_of_read_buffer, 
                       DWORD   *address_of_number_of_bytes_read,
                       DWORD    number_of_milliseconds_to_wait )
{
   /*
   ** Writes to the pipe then reads from it
   */

   BOOL return_value;

   return_value = ::CallNamedPipe( pipe_name, 
                                   write_buffer,
                                   size_of_write_buffer,
                                   read_buffer,
                                   size_of_read_buffer,
                                   address_of_number_of_bytes_read,
                                   number_of_milliseconds_to_wait );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

void CNamedPipe::Close( void )
{
   if ( m_PipeHandle != INVALID_HANDLE_VALUE )
   {
      ::CloseHandle( m_PipeHandle );
      m_PipeHandle = INVALID_HANDLE_VALUE;
   }
}

BOOL CNamedPipe::Connect( LPOVERLAPPED overlapped_p )
{
   BOOL return_value;

   return_value = ::ConnectNamedPipe( m_PipeHandle, overlapped_p );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Create( LPCTSTR server_name,
                         LPCTSTR pipe_name,
                         DWORD   open_mode,
                         DWORD   type_of_pipe,
                         DWORD   number_of_pipes,
           LPSECURITY_ATTRIBUTES security_attributes_p )
{
   /*
   ** Check parameters for errors
   */

   if ( pipe_name == NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;
      return( FALSE );
   }

   m_PipeName = "\\\\";

   if ( server_name == NULL )
   {
      m_PipeName += ".";
   }
   else
   {
      m_PipeName += server_name;
   }

   m_PipeName += "\\pipe\\";
   m_PipeName += pipe_name;

   m_PipeHandle = ::CreateNamedPipe( m_PipeName,
                                     open_mode,
                                     type_of_pipe, 
                                     number_of_pipes,
                                     m_OutputBufferSize,
                                     m_InputBufferSize,
                                     m_Timeout,
                                     security_attributes_p );

   if ( m_PipeHandle == INVALID_HANDLE_VALUE )
   {
      m_ErrorCode = ::GetLastError();
      return( FALSE );
   }
   else
   {
      return( TRUE );
   }
}

BOOL CNamedPipe::Disconnect( void )
{
   BOOL return_value;

   return_value = ::DisconnectNamedPipe( m_PipeHandle );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

DWORD CNamedPipe::GetErrorCode( void ) const
{
   return( m_ErrorCode );
}

BOOL CNamedPipe::GetInformation( void )
{
   BOOL return_value;

   DWORD type_of_pipe                = 0;
   DWORD size_of_output_buffer       = 0;
   DWORD size_of_input_buffer        = 0;
   DWORD maximum_number_of_instances = 0;

   return_value = ::GetNamedPipeInfo( m_PipeHandle,
                                     &type_of_pipe,
                                     &size_of_output_buffer,
                                     &size_of_input_buffer,
                                     &maximum_number_of_instances );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::GetState( void )
{
   BOOL return_value;

   TCHAR temp_string[ 513 ];

   ::ZeroMemory( temp_string, sizeof( temp_string ) );

   return_value = ::GetNamedPipeHandleState( m_PipeHandle,
                                            &m_PipeState,
                                            &m_NumberOfInstances,
                                            &m_MaximumNumberOfBytesBeforeRemoteTransmission,
                                            &m_MaximumNumberOfMillisecondsBeforeRemoteTransmission,
                                             temp_string,
                                             sizeof( temp_string ) );

   m_UserNameOfClientProcess = temp_string;

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Peek( LPVOID buffer_address, 
                       DWORD  size_of_buffer,
                       DWORD& number_of_bytes_read,
                       DWORD& number_of_bytes_available,
                       DWORD& number_of_bytes_remaining_in_message )
{
   BOOL return_value;

   return_value = ::PeekNamedPipe( m_PipeHandle, 
                                   buffer_address, 
                                   size_of_buffer, 
                                  &number_of_bytes_read,
                                  &number_of_bytes_available,
                                  &number_of_bytes_remaining_in_message );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::SetState( DWORD new_pipe_mode, 
                           DWORD maximum_number_of_bytes_before_transmission, 
                           DWORD maximum_number_of_milliseconds_before_transmission )
{
   BOOL return_value;

   return_value = ::SetNamedPipeHandleState( m_PipeHandle,
                                            &new_pipe_mode,
                                            &maximum_number_of_bytes_before_transmission,
                                            &maximum_number_of_milliseconds_before_transmission );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Transact( LPOVERLAPPED overlapped_p )
{
   BOOL return_value;

   return_value = ::TransactNamedPipe( m_PipeHandle,
                                       m_OutputBuffer,
                                       m_NumberOfBytesToWrite,
                                       m_InputBuffer,
                                       m_InputBufferSize,
                                      &m_NumberOfBytesRead,
                                       overlapped_p );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Wait( LPCTSTR name_of_server ,LPCTSTR name_of_pipe, DWORD number_of_milliseconds )
{
   /*
   ** Check parameters for errors
   */

   if ( name_of_pipe == NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;
      return( FALSE );
   }

   BOOL return_value;

   CString full_pipe_name( "\\\\" ); // like \\servername\pipe\pipename

   if ( name_of_server == NULL )
   {
      full_pipe_name += ".";
   }
   else
   {
      full_pipe_name += name_of_server;
   }

   full_pipe_name += "\\pipe\\";
   full_pipe_name += name_of_pipe;

   return_value = ::WaitNamedPipe( full_pipe_name, number_of_milliseconds );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}
