#include "test.h"
#pragma hdrstop

void test_CRegistry( void )
{
   CRegistry registry;

   if ( registry.Connect( CRegistry::keyLocalMachine ) != TRUE )
   {
      TRACE( "Can't connect to registry\n" );
      return;
   }

   if ( registry.Open( "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application", (CRegistry::CreatePermissions)(CRegistry::permissionRead | CRegistry::permissionSetValue) ) != TRUE )
   {
      TRACE( "Can't open key\n" );
      
      ReportError( registry.GetErrorCode() );
      return;
   }

   CStringArray string_array;

   string_array.RemoveAll();

   if ( registry.GetStringArrayValue( "Sources", string_array ) == TRUE )
   {
      int index = 0;
      int number_of_strings = string_array.GetSize();

      TRACE1( "There are %d strings\n", number_of_strings );

      CString temp_string;

      while( index < number_of_strings )
      {
         temp_string = string_array[ index ];

         TRACE2( "%d - \"%s\"\n", index + 1, (LPCTSTR) temp_string );
         index++;
      }

      if ( registry.SetStringArrayValue( "TempSources", string_array ) != TRUE )
      {
         ReportError( registry.GetErrorCode() );
      }
   }

   if ( registry.SetValue( "QFile", "Sammy" ) != TRUE )
   {
      TRACE( "registry.SetValue failed\n" );
      ReportError( registry.GetErrorCode() );
   }
   else
   {
      TRACE( "Set QFile to Sammy\n" );
   }

   CString temp_sammy( "" );

   if ( registry.GetValue( "QFile", temp_sammy ) != TRUE )
   {
      TRACE( "registry.GetValue failed\n" );
      ReportError( registry.GetErrorCode() );
   }
   else
   {
      if ( temp_sammy.Compare( "Sammy" ) == 0 )
      {
         TRACE( "GetValue OK\n" );
      }
      else
      {
         TRACE1( "FAIL! QFile is \"%s\"\n", (LPCTSTR) temp_sammy );
      }
   }
}
