unit Frmmain1;
(*
 wInformation Main form
 Carm Vecchio -    09/09/1995
 71762.271@compuserve.com
*)
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Menus, ExtCtrls,
  frmAbout, TabNotBk, FileCtrl, Gauges,
  readme;

type
  TfrmNmfiMain = class(TForm)
    ToolBar: TPanel;
    StatusBar: TPanel;
    sbExit: TSpeedButton;
    sbAbout: TSpeedButton;
    chkConfirmExit: TCheckBox;
    TabbedNotebook1: TTabbedNotebook;
    cbDrive: TDriveComboBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    txtDriveType: TEdit;
    txtDriveSize: TEdit;
    txtDriveFree: TEdit;
    Gauge1: TGauge;
    Label9: TLabel;
    Label1: TLabel;
    txtSysMem: TEdit;
    Bevel1: TBevel;
    GroupBox1: TGroupBox;
    gageGDI: TGauge;
    Label11: TLabel;
    gageUser: TGauge;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    pnlWinDir: TPanel;
    pnlWinSysDir: TPanel;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    txtWinVer: TEdit;
    txtDosVer: TEdit;
    txtCPU: TEdit;
    txtMathCo: TEdit;
    txtWinMode: TEdit;
    Label10: TLabel;
    txtPageMem: TEdit;
    Label15: TLabel;
    Bevel2: TBevel;
    cmdCompact: TBitBtn;
    cbOnTop: TCheckBox;
    sbReadMe: TSpeedButton;
    MainMenu1: TMainMenu;
    mnuFile: TMenuItem;
    mnuReadMe: TMenuItem;
    mnuAbout: TMenuItem;
    N1: TMenuItem;
    mnuExit: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure sbExitClick(Sender: TObject);
    procedure sbAboutClick(Sender: TObject);
    procedure chkConfirmExitClick(Sender: TObject);
    procedure cbDriveChange(Sender: TObject);
    procedure TabbedNotebook1Click(Sender: TObject);
    procedure cmdCompactClick(Sender: TObject);
    procedure cbOnTopClick(Sender: TObject);
    procedure sbReadMeClick(Sender: TObject);
  private
    { Private declarations }
    FileNeedsToBeSaved : BOOLEAN;
    FileName : string;
    AppTitle : string;
    ConfirmExit : BOOLEAN;
  public
    { Public declarations }
    procedure    DisplayHint(Sender:TObject);
    procedure    fGetSystemInformation;
    procedure    fGetDiskInfo(szDisk : char);
    procedure    fGetMemoryInformation;
  end;

var
  frmNmfiMain: TfrmNmfiMain;

implementation

{$R *.DFM}

function nmfiDriveType(ltr : char) : string;
   var d : integer;
begin
  d := ord(UpCase(ltr)) - ORD('A');
  if d in [0..25] then { A..Z }
  begin
    { Windows KERNAL API function }
    d := GetDriveType(d);
    case d of
      DRIVE_REMOVABLE  : Result := 'Floppy Drive';
      DRIVE_FIXED      : Result := 'Hard Drive';
      DRIVE_REMOTE     : Result := 'CD or Network Drive';
    else Result := 'Unknown Drive Type'
    end; { case }
  end
  else
    Result := ltr + ' is a bad Drive letter.';
end; { of nmfiDriveType() }

procedure TfrmNmfiMain.DisplayHint(Sender: TObject);
begin
  StatusBar.Caption := Application.Hint;
end;

procedure TfrmNmfiMain.fGetDiskInfo(szDisk : char);

var    lReturn, Factor  :longint;
       aLabel           : string[2];
const  KB = 1024;
begin
  szDisk := (UpCase(szDisk)); { 'A'..'Z' }

  { local unit function }
  txtDriveType.text := nmfiDriveType(szDisk);

  { DELPHI system function - 0 is current drive, 1..26 is A..Z}
  lReturn := DiskSize( ord(szDisk) - ord('A') + 1 );

  if lReturn > (10 * (KB * KB)) then
  begin
    factor := (KB * KB);
    aLabel := 'MB';
  end
  else
  begin
    factor := kb;
    aLabel := 'KB';
  end;

  txtDriveSize.Text := IntToStr( lReturn div factor ) + alabel;
  Gauge1.MaxValue := lReturn div factor ;

  { DELPHI system function - 0 is current drive, 1..26 is A..Z }
  lReturn := DiskFree( ord(szDisk) - ord('A') + 1 );

  txtDriveFree.Text := IntToStr( lReturn div factor ) + alabel;
  Gauge1.Progress := lReturn  div factor ;

  { displays Form Caption with ICON on the desktop if minimized }
  Self.Caption := AppTitle + '- ' + szDisk + ': ' +
             IntToStr(Gauge1.PercentDone) + '% Free Disk Space';
  Application.Title := Caption;
end;

procedure TfrmNmfiMain.fGetMemoryInformation;
begin
  { Global Heap - Windows API system function}
  txtSysMem.Text := IntToStr(GetFreeSpace(0) DIV 1024) + 'K';

  { System Resources - Windows API system function }
  Self.Caption := AppTitle + ' - ' +
          IntToStr(GetFreeSystemResources(GFSR_SYSTEMRESOURCES)) + '% Free Resources';
  { displays Form Caption with ICON on the desktop if minimized }
  Application.Title := Caption;

  gageUSER.Progress := GetFreeSystemResources(GFSR_USERRESOURCES);
  gageGDI.Progress := GetFreeSystemResources(GFSR_GDIRESOURCES);
end;

procedure TfrmNmfiMain.fGetSystemInformation;
var
   dwSysflags,
   dwAvailable,
   dwVersion           : longint;
   wDosVer, wWinVer    : WORD;
   b : array[0..144] of char;

begin
  Self.Caption := AppTitle;
  Application.Title := Caption;

  { Win & DOS Versions - Windows API system function}
  dwVersion := GetVersion;
  wWinVer := LoWord(dwVersion);
  txtWinVer.Text := IntToStr(LoByte(wWinVer)) + '.' + IntToStr(HiByte(wWinVer));
  wDosVer := HiWord(dwVersion);
  txtDosVer.Text := IntToStr(HiByte(wDosVer)) + '.' + IntToStr(LoByte(wDosVer));

  { WinFlags - Windows API system function }
  dwSysFlags := GetWinFlags;

  if (dwSysFlags and WF_WIN386) = WF_WIN386 then txtWinMode.Text := '386 Enhanced'
  else txtWinMode.Text := 'Standard';

  if (dwSysFlags and WF_80x87) = WF_80x87 then txtMathCo.Text := 'Yes'
  else txtMathCo.Text := 'No';

  if (dwSysFlags and WF_Paging) = WF_Paging then txtPageMem.Text := 'Yes'
  else txtPageMem.Text := 'No';

  if (dwSysFlags and WF_CPU286) = WF_CPU286 then
      txtCPU.Text := '80286'
  else
  if (dwSysFlags and WF_CPU386) = WF_CPU386 then
      txtCPU.Text := '80386'
  else
  if (dwSysFlags and WF_CPU486) = WF_CPU486 then
      txtCPU.Text := '80486 or better'
  else        txtCPU.Text := 'unknown type';

{ Win directory locations - Windows API system function }
  GetWindowsDirectory(b,sizeof(b));
  pnlWinDir.Caption := strpas(b);

  GetSystemDirectory(b,sizeof(b));
  pnlWinSysDir.Caption := strpas(b);
end;

procedure TfrmNmfiMain.Exit1Click(Sender: TObject);
begin
  self.close;
end;

procedure TfrmNmfiMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
if ConfirmExit then
  CanClose := MessageDlg('You are about to close '+ application.Title + '. Are you sure?',
    mtInformation, [mbYes, mbNo], 0) = mrYes;

end;

procedure TfrmNmfiMain.FormCreate(Sender: TObject);
begin
  FileNeedsToBeSaved := FALSE;
  ConfirmExit := FALSE;
  FileName := '';
  Application.OnHint := DisplayHint;
  AppTitle := Application.Title;
  { Open Main Form in the Upper Left of the Desktop }
  self.top := (Screen.Height - self.height) div 4  ;
  self.left := (Screen.Width - self.Width) div 4 ;
  { Initialize Top Tab window data }
  fGetSystemInformation;
end;

procedure TfrmNmfiMain.sbExitClick(Sender: TObject);
begin
  self.Close;
end;

procedure TfrmNmfiMain.sbAboutClick(Sender: TObject);
var StayOnTop : boolean;
    f : TfrmNmfiAbout;
begin
{ The ABOUT Box is MODAL. When the Main Form is set to
  always STAY ON TOP, the About Box has focus but can be hidden
  underneath the Main Form. This makes it difficult to close the
  About Box using the mouse, although pressing RETURN will click
  the OK button since its DEFAULT attribute is set to TRUE. The
  extra code in this function handles the Mouse access situation.
}
  StayOnTop := cbOnTop.Checked;
  if cbOnTop.Checked then cbOnTop.Checked := false;

  try
    f := TfrmNmfiAbout.Create(self , AppTitle);
    f.ShowModal;
  finally
    f.free;
  end;
  if StayOnTop then cbOnTop.Checked := True;
end;

procedure TfrmNmfiMain.chkConfirmExitClick(Sender: TObject);
begin
  ConfirmExit := chkConfirmExit.checked;
end;

procedure TfrmNmfiMain.cbDriveChange(Sender: TObject);
begin
  fGetDiskInfo(cbDrive.Drive);
end;

procedure TfrmNmfiMain.TabbedNotebook1Click(Sender: TObject);
begin
  case TabbedNotebook1.PageIndex of  { which tab was clicked? }
  { change HINT based on active tab }
  0 : begin
      fGetSystemInformation;
      TabbedNotebook1.Hint := 'System Statistics.'
      end;
  1 : begin
        fGetDiskInfo(cbDrive.Drive);
        TabbedNotebook1.Hint := 'Disk Drive Statistics.'
      end;
  2 : begin
        fGetMemoryInformation;
        TabbedNotebook1.Hint := 'Resource Statistics.'
      end;
  end; { case }
end;

procedure TfrmNmfiMain.cmdCompactClick(Sender: TObject);
var mem : longint;
begin
  Screen.Cursor := crHourglass;
(*  mem := GlobalCompact(0); { how much is there to free? } *)
  mem := $ffffff; { 16 meg }
{ Defragments Global Memory  - Windows API system function }
  GlobalCompact(mem); { try free up to value of MEM }
  fGetMemoryInformation;
  Screen.Cursor := crDefault;
end;

procedure TfrmNmfiMain.cbOnTopClick(Sender: TObject);
begin
  if cbOnTop.checked then frmNmfiMain.FormStyle := fsStayOnTop
  else frmNmfiMain.FormStyle := fsNormal;
end;

procedure TfrmNmfiMain.sbReadMeClick(Sender: TObject);
var f : TfrmReadMe;
begin
  try
    f := TfrmReadMe.Create(self);
    f.showmodal;
  finally
    f.Free;
  end;
end;

end.
