;
;  Test file for D51 V2.x
;  04/29/95
;
page0	equ	0
page1	equ	100h
page2	equ	200h
page3	equ	300h
page4	equ	400h
page5	equ	500h
page6	equ	600h
page7	equ	700h
;
	org	0
;
reset:	ajmp	start		; reset vector
;
	org	3
;
ie0vec:	ajmp	exint0		; external 0 interrupt
;
	org	0bh
;
tf0vec:	ajmp	timer0		; timer 0 overflow interrupt
;
	org	13h
;
ie1vec:	ajmp	exint1		; external 1 interrupt
;
	org	1bh
;
tf1vec:	ajmp	timer1		; timer 1 overflow interrupt
;
	org	23h
;
servec:	ajmp	serial		; serial port interrupt
;
exint0:	mov	dptr,#ex0txt
	acall	print
	ljmp	dlost1
;
ex0txt:	db	'external interrupt 0',0
;
exint1:	mov	dptr,#ex1txt
	acall	print
	ljmp	lost
;
ex1txt:	db	'external interrupt 1',0
;
timer0:	mov	dptr,#t0text
	acall	print
	ajmp	ajmp1
;
t0text:	db	'timer 0 expired',0
;
timer1:	mov	dptr,#t1text
	acall	print
	ajmp	ljmp1
;
t1text:	db	'timer 1 expired',0
;
serial:	reti
;
print:	nop	; routine to output a text string (?)
	ret
;
;  now for all the opcodes in numerical order:
;
start:	nop			; 00
	ajmp	page0		; 01
ajmp1:	ljmp	ljmp1		; 02
ljmp1:	rr	a		; 03
	inc	a		; 04
	inc	12h		; 05
	inc	@r0		; 06
	inc	@r1		; 07
	inc	r0		; 08
	inc	r1		; 09
	inc	r2		; 0a
	inc	r3		; 0b
	inc	r4		; 0c
jbclp:	inc	r5		; 0d
	inc	r6		; 0e
	inc	r7		; 0f
;
	jbc	12h,jbclp	; 10
	acall	subrt		; 11
	lcall	subrt		; 12
	rrc	a		; 13
	dec	a		; 14
	dec	12h		; 15
	dec	@r0		; 16
	dec	@r1		; 17
	dec	r0		; 18
	dec	r1		; 19
	dec	r2		; 1a
	dec	r3		; 1b
	dec	r4		; 1c
	dec	r5		; 1d
	dec	r6		; 1e
	dec	r7		; 1f
;
subrt:	jb	12h,jblp	; 20
	ajmp	page1		; 21
	ret			; 22
	rl	a		; 23
jblp:	add	a,#34h		; 24
	add	a,56h		; 25
	add	a,@r0		; 26
	add	a,@r1		; 27
	add	a,r0		; 28
	add	a,r1		; 29
	add	a,r2		; 2a
	add	a,r3		; 2b
	add	a,r4		; 2c
	add	a,r5		; 2d
	add	a,r6		; 2e
	add	a,r7		; 2f
;
	jnb	12h,jnblp	; 30
	acall	page1		; 31
	reti			; 32
jnblp:	rlc	a		; 33
	addc	a,#12h		; 34
	addc	a,12h		; 35
	addc	a,@r0		; 36
	addc	a,@r1		; 37
	addc	a,r0		; 38
	addc	a,r1		; 39
	addc	a,r2		; 3a
	addc	a,r3		; 3b
	addc	a,r4		; 3c
	addc	a,r5		; 3d
	addc	a,r6		; 3e
	addc	a,r7		; 3f
;
	jc	jclp		; 40
	ajmp	page2		; 41
jclp:	orl	12h,a		; 42
	orl	12h,#34h	; 43
	orl	a,#56h		; 44
	orl	a,12h		; 45
	orl	a,@r0		; 46
	orl	a,@r1		; 47
	orl	a,r0		; 48
	orl	a,r1		; 49
	orl	a,r2		; 4a
	orl	a,r3		; 4b
	orl	a,r4		; 4c
	orl	a,r5		; 4d
	orl	a,r6		; 4e
	orl	a,r7		; 4f
;
	jnc	jnblp		; 50
	acall	page2		; 51
	anl	12h,a		; 52
	anl	12h,#34h	; 53
	anl	a,#56h		; 54
	anl	a,12h		; 55
	anl	a,@r0		; 56
	anl	a,@r1		; 57
	anl	a,r0		; 58
	anl	a,r1		; 59
	anl	a,r2		; 5a
	anl	a,r3		; 5b
	anl	a,r4		; 5c
	anl	a,r5		; 5d
	anl	a,r6		; 5e
	anl	a,r7		; 5f
;
	jz	jzlp		; 60
	ajmp	page3		; 61
jzlp:	xrl	12h,a		; 62
	xrl	12h,#34h	; 63
	xrl	a,#56h		; 64
	xrl	a,12h		; 65
	xrl	a,@r0		; 66
	xrl	a,@r1		; 67
	xrl	a,r0		; 68
	xrl	a,r1		; 69
	xrl	a,r2		; 6a
	xrl	a,r3		; 6b
	xrl	a,r4		; 6c
	xrl	a,r5		; 6d
	xrl	a,r6		; 6e
	xrl	a,r7		; 6f
;
	jnz	jnzlp		; 70
	acall	page3		; 71
	orl	c,12h		; 72
	jmp	@a+dptr		; 73
jnzlp:	mov	a,#12h		; 74
	mov	12h,#34h	; 75
	mov	@r0,#12h	; 76
	mov	@r1,#34h	; 77
	mov	r0,#01h		; 78
	mov	r1,#23h		; 79
	mov	r2,#45h		; 7a
	mov	r3,#67h		; 7b
	mov	r4,#89h		; 7c
	mov	r5,#12h		; 7d
	mov	r6,#34h		; 7e
	mov	r7,#56h		; 7f
;
	sjmp	there		; 80
	ajmp	page4		; 81
	anl	c,12h		; 82
there:	movc	a,@a+pc		; 83
	div	ab		; 84
	mov	12h,34h		; 85
	mov	12h,@r0		; 86
	mov	34h,@r1		; 87
	mov	12h,r0		; 88
	mov	34h,r1		; 89
	mov	56h,r2		; 8a
	mov	78h,r3		; 8b
	mov	01h,r4		; 8c
	mov	23h,r5		; 8d
	mov	45h,r6		; 8e
	mov	67h,r7		; 8f
;
	mov	dptr,#there	; 90
	acall	page4		; 91
	mov	12h,c		; 92
	movc	a,@a+dptr	; 93
	subb	a,#12h		; 94
	subb	a,34h		; 95
	subb	a,@r0		; 96
	subb	a,@r1		; 97
	subb	a,r0		; 98
	subb	a,r1		; 99
	subb	a,r2		; 9a
	subb	a,r3		; 9b
	subb	a,r4		; 9c
	subb	a,r5		; 9d
	subb	a,r6		; 9e
	subb	a,r7		; 9f
;
	orl	c,/12h		; a0
	ajmp	page5		; a1
lost:	mov	c,12h		; a2
	inc	dptr		; a3
	mul	ab		; a4
	db	0a5h		; a5
	mov	@r0,16		; a6
	mov	@r1,17		; a7
	mov	r0,18		; a8
	mov	r1,19		; a9
	mov	r2,20		; aa
	mov	r3,21		; ab
	mov	r4,22		; ac
	mov	r5,23		; ad
	mov	r6,24		; ae
	mov	r7,25		; af
;
loop:	anl	c,/12h		; b0
	acall	page5		; b1
	cpl	12h		; b2
	cpl	c		; b3
	cjne	a,#12h,loop	; b4
	cjne	a,12h,loop	; b5
	cjne	@r0,#12h,loop	; b6
	cjne	@r1,#34h,loop	; b7
	cjne	r0,#1,loop	; b8
	cjne	r1,#2,loop	; b9
	cjne	r2,#3,loop	; ba
	cjne	r3,#4,loop	; bb
	cjne	r4,#5,loop	; bc
	cjne	r5,#6,loop	; bd
	cjne	r6,#7,loop	; be
	cjne	r7,#8,lost	; bf
;
	push	12h		; c0
	ajmp	page6		; c1
dlost1:	clr	12h		; c2
	clr	c		; c3
	swap	a		; c4
	xch	a,12h		; c5
	xch	a,@r0		; c6
	xch	a,@r1		; c7
	xch	a,r0		; c8
	xch	a,r1		; c9
	xch	a,r2		; ca
	xch	a,r3		; cb
	xch	a,r4		; cc
	xch	a,r5		; cd
	xch	a,r6		; ce
	xch	a,r7		; cf
;
dloop:	pop	34h		; d0
	acall	page6		; d1
	setb	12h		; d2
	setb	c		; d3
	da	a		; d4
	djnz	12h,dloop	; d5
	xchd	a,@r0		; d6
	xchd	a,@r1		; d7
	djnz	r0,dloop	; d8
	djnz	r1,dloop	; d9
	djnz	r2,dloop	; da
	djnz	r3,dloop	; db
	djnz	r4,dloop	; dc
	djnz	r5,dloop	; dd
	djnz	r6,dloop	; de
	djnz	r7,dlost1	; df
;
	movx	a,@dptr		; e0
	ajmp	page7		; e1
	movx	a,@r0		; e2
	movx	a,@r1		; e3
	clr	a		; e4
	mov	a,12h		; e5
	mov	a,@r0		; e6
	mov	a,@r1		; e7
	mov	a,r0		; e8
	mov	a,r1		; e9
	mov	a,r2		; ea
	mov	a,r3		; eb
	mov	a,r4		; ec
	mov	a,r5		; ed
	mov	a,r6		; ee
	mov	a,r7		; ef
;
	movx	@dptr,a		; f0
	acall	page7		; f1
	movx	@r0,a		; f2
	movx	@r1,a		; f3
	cpl	a		; f4
	mov	12h,a		; f5
	mov	@r0,a		; f6
	mov	@r1,a		; f7
	mov	r0,a		; f8
	mov	r1,a		; f9
	mov	r2,a		; fa
	mov	r3,a		; fb
	mov	r4,a		; fc
	mov	r5,a		; fd
	mov	r6,a		; fe
	mov	r7,a		; ff
;
	ljmp	start		; all done
;
text:	db	'This is a message',0
;
btable:	db	1,2,3,4,5,6,7,8
;
wtable:	dw	1234h,5678h
;
	end	 ; End of Test File for D51
;

